/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.store;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.cache.store.CacheStoreSession;
import org.apache.ignite.cache.store.CacheStoreSessionListener;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite.internal.processors.cache.CacheStoreBalancingWrapper;
import org.apache.ignite.internal.processors.cache.CacheStorePartialUpdateException;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.store.CacheLocalStore;
import org.apache.ignite.internal.processors.cache.store.CacheStoreManager;
import org.apache.ignite.internal.processors.cache.store.GridCacheWriteBehindStore;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridEmptyIterator;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.GridSetWrapper;
import org.apache.ignite.internal.util.lang.GridInClosure3;
import org.apache.ignite.internal.util.lang.GridMetadataAwareAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.transactions.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridCacheStoreManagerAdapter
extends GridCacheManagerAdapter
implements CacheStoreManager {
    private static final int SES_ATTR = GridMetadataAwareAdapter.EntryKey.CACHE_STORE_MANAGER_KEY.key();
    private static final IgniteProductVersion LOCAL_STORE_KEEPS_PRIMARY_AND_BACKUPS_SINCE = IgniteProductVersion.fromString("1.5.22");
    protected CacheStore<Object, Object> store;
    protected CacheStore<?, ?> cfgStore;
    private CacheStoreBalancingWrapper<Object, Object> singleThreadGate;
    private ThreadLocal<SessionData> sesHolder;
    private ThreadLocalSession locSes;
    private boolean locStore;
    private boolean writeThrough;
    private Collection<CacheStoreSessionListener> sesLsnrs;
    private boolean globalSesLsnrs;

    public void initialize(@Nullable CacheStore cfgStore, Map sesHolders) throws IgniteCheckedException {
        GridKernalContext ctx = this.igniteContext();
        CacheConfiguration cfg = this.cacheConfiguration();
        this.writeThrough = cfg.isWriteThrough();
        this.cfgStore = cfgStore;
        this.store = this.cacheStoreWrapper(ctx, cfgStore, cfg);
        this.singleThreadGate = this.store == null ? null : new CacheStoreBalancingWrapper<Object, Object>(this.store, cfg.getStoreConcurrentLoadAllThreshold());
        ThreadLocal sesHolder0 = null;
        if (cfgStore != null) {
            sesHolder0 = (ThreadLocal)sesHolders.get(cfgStore);
            if (sesHolder0 == null) {
                sesHolder0 = new ThreadLocal();
                this.locSes = new ThreadLocalSession(sesHolder0);
                if (ctx.resource().injectStoreSession(cfgStore, this.locSes)) {
                    sesHolders.put(cfgStore, sesHolder0);
                }
            } else {
                this.locSes = new ThreadLocalSession(sesHolder0);
            }
        }
        this.sesHolder = sesHolder0;
        this.locStore = U.hasAnnotation(cfgStore, CacheLocalStore.class);
    }

    @Override
    public boolean isWriteThrough() {
        return this.writeThrough;
    }

    private CacheStore cacheStoreWrapper(GridKernalContext ctx, @Nullable CacheStore cfgStore, CacheConfiguration cfg) {
        if (cfgStore == null || !cfg.isWriteBehindEnabled()) {
            return cfgStore;
        }
        GridCacheWriteBehindStore store = new GridCacheWriteBehindStore(this, ctx.gridName(), cfg.getName(), ctx.log(GridCacheWriteBehindStore.class), cfgStore);
        store.setFlushSize(cfg.getWriteBehindFlushSize());
        store.setFlushThreadCount(cfg.getWriteBehindFlushThreadCount());
        store.setFlushFrequency(cfg.getWriteBehindFlushFrequency());
        store.setBatchSize(cfg.getWriteBehindBatchSize());
        return store;
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        if (this.store instanceof LifecycleAware) {
            try {
                if (this.cctx.config().isWriteBehindEnabled() && !this.cctx.isNear()) {
                    ((LifecycleAware)((Object)this.store)).start();
                }
            }
            catch (Exception e) {
                throw new IgniteCheckedException("Failed to start cache store: " + e, e);
            }
        }
        CacheConfiguration cfg = this.cctx.config();
        if (this.cfgStore != null) {
            if (!cfg.isWriteThrough() && !cfg.isReadThrough()) {
                U.quietAndWarn(this.log, "Persistence store is configured, but both read-through and write-through are disabled. This configuration makes sense if the store implements loadCache method only. If this is the case, ignore this warning. Otherwise, fix the configuration for the cache: " + cfg.getName(), "Persistence store is configured, but both read-through and write-through are disabled for cache: " + cfg.getName());
            }
            if (!cfg.isWriteThrough() && cfg.isWriteBehindEnabled()) {
                U.quietAndWarn(this.log, "To enable write-behind mode for the cache store it's also required to set CacheConfiguration.setWriteThrough(true) property, otherwise the persistence store will be never updated. Consider fixing configuration for the cache: " + cfg.getName(), "Write-behind mode for the cache store also requires CacheConfiguration.setWriteThrough(true) property. Fix configuration for the cache: " + cfg.getName());
            }
        }
        this.sesLsnrs = CU.startStoreSessionListeners(this.cctx.kernalContext(), cfg.getCacheStoreSessionListenerFactories());
        if (this.sesLsnrs == null) {
            this.sesLsnrs = this.cctx.shared().storeSessionListeners();
            this.globalSesLsnrs = true;
        }
        if (this.isLocal()) {
            for (ClusterNode node : this.cctx.kernalContext().cluster().get().forRemotes().nodes()) {
                if (LOCAL_STORE_KEEPS_PRIMARY_AND_BACKUPS_SINCE.compareTo(node.version()) <= 0 || IgniteSystemProperties.getBoolean("IGNITE_LOCAL_STORE_KEEPS_PRIMARY_ONLY")) continue;
                IgniteProductVersion v = LOCAL_STORE_KEEPS_PRIMARY_AND_BACKUPS_SINCE;
                this.log.warning("Since Ignite " + v.major() + "." + v.minor() + "." + v.maintenance() + " Local Store keeps primary and backup partitions. " + "To keep primary partitions only please set system property " + "IGNITE_LOCAL_STORE_KEEPS_PRIMARY_ONLY" + " to 'true'.");
                break;
            }
        }
    }

    @Override
    protected void stop0(boolean cancel) {
        if (this.store instanceof LifecycleAware) {
            try {
                if (this.cctx.config().isWriteBehindEnabled() && !this.cctx.isNear()) {
                    ((LifecycleAware)((Object)this.store)).stop();
                }
            }
            catch (Exception e) {
                U.error(this.log(), "Failed to stop cache store.", e);
            }
        }
        if (!this.globalSesLsnrs) {
            try {
                CU.stopStoreSessionListeners(this.cctx.kernalContext(), this.sesLsnrs);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to stop store session listeners for cache: " + this.cctx.name(), e);
            }
        }
    }

    @Override
    public boolean isLocal() {
        return this.locStore;
    }

    @Override
    public boolean configured() {
        return this.store != null;
    }

    @Override
    public CacheStore<?, ?> configuredStore() {
        return this.cfgStore;
    }

    @Override
    @Nullable
    public final Object load(@Nullable IgniteInternalTx tx, KeyCacheObject key) throws IgniteCheckedException {
        return this.loadFromStore(tx, key, true);
    }

    @Nullable
    private Object loadFromStore(@Nullable IgniteInternalTx tx, KeyCacheObject key, boolean convert) throws IgniteCheckedException {
        if (this.store != null) {
            if (key.internal()) {
                return null;
            }
            Object storeKey = this.cctx.unwrapBinaryIfNeeded(key, !this.convertBinary());
            if (this.log.isDebugEnabled()) {
                this.log.debug(S.toString("Loading value from store for key", "key", storeKey, true));
            }
            this.sessionInit0(tx);
            boolean threwEx = true;
            Object val = null;
            try {
                val = this.singleThreadGate.load(storeKey);
                threwEx = false;
            }
            catch (ClassCastException e) {
                this.handleClassCastException(e);
            }
            catch (CacheLoaderException e) {
                throw new IgniteCheckedException(e);
            }
            catch (Exception e) {
                throw new IgniteCheckedException(new CacheLoaderException(e));
            }
            finally {
                this.sessionEnd0(tx, threwEx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Loaded value from store [key=" + key + ", val=" + val + ']');
            }
            if (convert) {
                val = this.convert(val);
                return val;
            }
            return val;
        }
        return null;
    }

    private Object convert(Object val) {
        if (val == null) {
            return null;
        }
        return this.locStore ? ((IgniteBiTuple)val).get1() : val;
    }

    @Override
    public boolean isWriteBehind() {
        return this.cctx.config().isWriteBehindEnabled();
    }

    @Override
    public boolean isWriteToStoreFromDht() {
        return this.isWriteBehind() || this.locStore;
    }

    public final void localStoreLoadAll(@Nullable IgniteInternalTx tx, Collection keys, GridInClosure3 vis) throws IgniteCheckedException {
        assert (this.store != null);
        assert (this.locStore);
        this.loadAllFromStore(tx, keys, null, vis);
    }

    public final boolean loadAll(@Nullable IgniteInternalTx tx, Collection keys, IgniteBiInClosure vis) throws IgniteCheckedException {
        if (this.store != null) {
            this.loadAllFromStore(tx, keys, vis, null);
            return true;
        }
        for (Object key : keys) {
            vis.apply(key, null);
        }
        return false;
    }

    private void loadAllFromStore(@Nullable IgniteInternalTx tx, Collection<? extends KeyCacheObject> keys, final @Nullable IgniteBiInClosure<KeyCacheObject, Object> vis, final @Nullable GridInClosure3<KeyCacheObject, Object, GridCacheVersion> verVis) throws IgniteCheckedException {
        boolean convert;
        assert (vis != null ^ verVis != null);
        assert (verVis == null || this.locStore);
        boolean bl = convert = verVis == null;
        if (!keys.isEmpty()) {
            if (keys.size() == 1) {
                KeyCacheObject key = F.first(keys);
                if (convert) {
                    vis.apply(key, this.load(tx, key));
                } else {
                    IgniteBiTuple t = (IgniteBiTuple)this.loadFromStore(tx, key, false);
                    if (t != null) {
                        verVis.apply(key, t.get1(), (GridCacheVersion)t.get2());
                    }
                }
                return;
            }
            Collection<Object> keys0 = F.viewReadOnly(keys, new C1<KeyCacheObject, Object>(){

                @Override
                public Object apply(KeyCacheObject key) {
                    return GridCacheStoreManagerAdapter.this.cctx.unwrapBinaryIfNeeded(key, !GridCacheStoreManagerAdapter.this.convertBinary());
                }
            }, new IgnitePredicate[0]);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Loading values from store for keys: " + keys0);
            }
            this.sessionInit0(tx);
            boolean threwEx = true;
            try {
                CI2<Object, Object> c = new CI2<Object, Object>(){

                    @Override
                    public void apply(Object k, Object val) {
                        if (convert) {
                            Object v = GridCacheStoreManagerAdapter.this.convert(val);
                            vis.apply(GridCacheStoreManagerAdapter.this.cctx.toCacheKeyObject(k), v);
                        } else {
                            IgniteBiTuple v = (IgniteBiTuple)val;
                            if (v != null) {
                                verVis.apply(GridCacheStoreManagerAdapter.this.cctx.toCacheKeyObject(k), v.get1(), v.get2());
                            }
                        }
                    }
                };
                if (keys.size() > this.singleThreadGate.loadAllThreshold()) {
                    Map map = this.store.loadAll(keys0);
                    if (map != null) {
                        for (Map.Entry e : map.entrySet()) {
                            c.apply(this.cctx.toCacheKeyObject(e.getKey()), e.getValue());
                        }
                    }
                } else {
                    this.singleThreadGate.loadAll(keys0, (IgniteBiInClosure<Object, Object>)c);
                }
                threwEx = false;
            }
            catch (ClassCastException e) {
                this.handleClassCastException(e);
            }
            catch (CacheLoaderException e) {
                throw new IgniteCheckedException(e);
            }
            catch (Exception e) {
                throw new IgniteCheckedException(new CacheLoaderException(e));
            }
            finally {
                this.sessionEnd0(tx, threwEx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Loaded values from store for keys: " + keys0);
            }
        }
    }

    public final boolean loadCache(final GridInClosure3 vis, Object[] args) throws IgniteCheckedException {
        if (this.store != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Loading all values from store.");
            }
            this.sessionInit0(null);
            boolean threwEx = true;
            try {
                this.store.loadCache(new IgniteBiInClosure<Object, Object>(){

                    @Override
                    public void apply(Object k, Object o) {
                        Object v;
                        GridCacheVersion ver = null;
                        if (GridCacheStoreManagerAdapter.this.locStore) {
                            IgniteBiTuple t = (IgniteBiTuple)o;
                            v = t.get1();
                            ver = (GridCacheVersion)t.get2();
                        } else {
                            v = o;
                        }
                        KeyCacheObject cacheKey = GridCacheStoreManagerAdapter.this.cctx.toCacheKeyObject(k);
                        vis.apply(cacheKey, v, ver);
                    }
                }, args);
                threwEx = false;
            }
            catch (CacheLoaderException e) {
                throw new IgniteCheckedException(e);
            }
            catch (Exception e) {
                throw new IgniteCheckedException(new CacheLoaderException(e));
            }
            finally {
                this.sessionEnd0(null, threwEx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Loaded all values from store.");
            }
            return true;
        }
        LT.warn(this.log, "Calling Cache.loadCache() method will have no effect, CacheConfiguration.getStore() is not defined for cache: " + this.cctx.namexx());
        return false;
    }

    @Override
    public final boolean put(@Nullable IgniteInternalTx tx, Object key, Object val, GridCacheVersion ver) throws IgniteCheckedException {
        if (this.store != null) {
            if (key instanceof GridCacheInternal) {
                return true;
            }
            key = this.cctx.unwrapBinaryIfNeeded(key, !this.convertBinary());
            val = this.cctx.unwrapBinaryIfNeeded(val, !this.convertBinary());
            if (this.log.isDebugEnabled()) {
                this.log.debug(S.toString("Storing value in cache store", "key", key, true, "val", val, true));
            }
            this.sessionInit0(tx);
            boolean threwEx = true;
            try {
                this.store.write(new CacheEntryImpl<Object, Object>(key, this.locStore ? F.t(val, ver) : val));
                threwEx = false;
            }
            catch (ClassCastException e) {
                this.handleClassCastException(e);
            }
            catch (CacheWriterException e) {
                throw new IgniteCheckedException(e);
            }
            catch (Exception e) {
                throw new IgniteCheckedException(new CacheWriterException(e));
            }
            finally {
                this.sessionEnd0(tx, threwEx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(S.toString("Stored value in cache store", "key", key, true, "val", val, true));
            }
            return true;
        }
        return false;
    }

    public final boolean putAll(@Nullable IgniteInternalTx tx, Map map) throws IgniteCheckedException {
        if (F.isEmpty(map)) {
            return true;
        }
        if (map.size() == 1) {
            Map.Entry e = map.entrySet().iterator().next();
            return this.put(tx, e.getKey(), ((IgniteBiTuple)e.getValue()).get1(), (GridCacheVersion)((IgniteBiTuple)e.getValue()).get2());
        }
        if (this.store != null) {
            EntriesView entries = new EntriesView(map);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Storing values in cache store [entries=" + entries + ']');
            }
            this.sessionInit0(tx);
            boolean threwEx = true;
            try {
                this.store.writeAll(entries);
                threwEx = false;
            }
            catch (ClassCastException e) {
                this.handleClassCastException(e);
            }
            catch (Exception e2) {
                CacheWriterException e2;
                if (!(e2 instanceof CacheWriterException)) {
                    e2 = new CacheWriterException(e2);
                }
                if (!entries.isEmpty()) {
                    ArrayList keys = new ArrayList(entries.size());
                    for (Cache.Entry<?, ?> entry : entries) {
                        keys.add(entry.getKey());
                    }
                    throw new CacheStorePartialUpdateException(keys, e2);
                }
                throw new IgniteCheckedException(e2);
            }
            finally {
                this.sessionEnd0(tx, threwEx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Stored value in cache store [entries=" + entries + ']');
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean remove(@Nullable IgniteInternalTx tx, Object key) throws IgniteCheckedException {
        if (this.store != null) {
            if (key instanceof GridCacheInternal) {
                return false;
            }
            key = this.cctx.unwrapBinaryIfNeeded(key, !this.convertBinary());
            if (this.log.isDebugEnabled()) {
                this.log.debug(S.toString("Removing value from cache store", "key", key, true));
            }
            this.sessionInit0(tx);
            boolean threwEx = true;
            try {
                this.store.delete(key);
                threwEx = false;
            }
            catch (ClassCastException e) {
                this.handleClassCastException(e);
            }
            catch (CacheWriterException e) {
                throw new IgniteCheckedException(e);
            }
            catch (Exception e) {
                throw new IgniteCheckedException(new CacheWriterException(e));
            }
            finally {
                this.sessionEnd0(tx, threwEx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(S.toString("Removed value from cache store", "key", key, true));
            }
            return true;
        }
        return false;
    }

    public final boolean removeAll(@Nullable IgniteInternalTx tx, Collection keys) throws IgniteCheckedException {
        if (F.isEmpty(keys)) {
            return true;
        }
        if (keys.size() == 1) {
            Object key = keys.iterator().next();
            return this.remove(tx, key);
        }
        if (this.store != null) {
            Collection<Object> keys0 = this.cctx.unwrapBinariesIfNeeded(keys, !this.convertBinary());
            if (this.log.isDebugEnabled()) {
                this.log.debug(S.toString("Removing values from cache store", "keys", keys0, true));
            }
            this.sessionInit0(tx);
            boolean threwEx = true;
            try {
                this.store.deleteAll(keys0);
                threwEx = false;
            }
            catch (ClassCastException e) {
                this.handleClassCastException(e);
            }
            catch (Exception e2) {
                CacheWriterException e2;
                if (!(e2 instanceof CacheWriterException)) {
                    e2 = new CacheWriterException(e2);
                }
                if (!keys0.isEmpty()) {
                    throw new CacheStorePartialUpdateException(keys0, e2);
                }
                throw new IgniteCheckedException(e2);
            }
            finally {
                this.sessionEnd0(tx, threwEx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(S.toString("Removed values from cache store", "keys", keys0, true));
            }
            return true;
        }
        return false;
    }

    @Override
    public CacheStore<Object, Object> store() {
        return this.store;
    }

    @Override
    public void forceFlush() throws IgniteCheckedException {
        if (this.store instanceof GridCacheWriteBehindStore) {
            ((GridCacheWriteBehindStore)this.store).forceFlush();
        }
    }

    @Override
    public final void sessionEnd(IgniteInternalTx tx, boolean commit, boolean last) throws IgniteCheckedException {
        assert (this.store != null);
        this.sessionInit0(tx);
        try {
            if (this.sesLsnrs != null) {
                for (CacheStoreSessionListener lsnr : this.sesLsnrs) {
                    lsnr.onSessionEnd(this.locSes, commit);
                }
            }
            if (!this.sesHolder.get().ended(this.store)) {
                this.store.sessionEnd(commit);
            }
        }
        catch (Throwable e) {
            last = true;
            throw e;
        }
        finally {
            if (last && this.sesHolder != null) {
                this.sesHolder.set(null);
                tx.removeMeta(SES_ATTR);
            }
        }
    }

    private void handleClassCastException(ClassCastException e) throws IgniteCheckedException {
        assert (e != null);
        if (e.getMessage() != null) {
            throw new IgniteCheckedException("Cache store must work with binary objects if binary are enabled for cache [cacheName=" + this.cctx.namex() + ']', e);
        }
        throw e;
    }

    @Override
    public void writeBehindSessionInit() throws IgniteCheckedException {
        this.sessionInit0(null);
    }

    @Override
    public void writeBehindSessionEnd(boolean threwEx) throws IgniteCheckedException {
        this.sessionEnd0(null, threwEx);
    }

    private void sessionInit0(@Nullable IgniteInternalTx tx) throws IgniteCheckedException {
        SessionData ses;
        assert (this.sesHolder != null);
        if (tx != null) {
            ses = (SessionData)tx.meta(SES_ATTR);
            if (ses == null) {
                ses = new SessionData(tx, this.cctx.name());
                tx.addMeta(SES_ATTR, ses);
            } else {
                ses.cacheName(this.cctx.name());
            }
        } else {
            ses = new SessionData(null, this.cctx.name());
        }
        this.sesHolder.set(ses);
        try {
            if (this.sesLsnrs != null && !ses.started(this)) {
                for (CacheStoreSessionListener lsnr : this.sesLsnrs) {
                    lsnr.onSessionStart(this.locSes);
                }
            }
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to start store session: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sessionEnd0(@Nullable IgniteInternalTx tx, boolean threwEx) throws IgniteCheckedException {
        try {
            if (tx == null) {
                if (this.sesLsnrs != null) {
                    for (CacheStoreSessionListener lsnr : this.sesLsnrs) {
                        lsnr.onSessionEnd(this.locSes, !threwEx);
                    }
                }
                assert (!this.sesHolder.get().ended(this.store));
                this.store.sessionEnd(!threwEx);
            }
        }
        catch (Exception e) {
            if (!threwEx) {
                throw U.cast(e);
            }
        }
        finally {
            if (this.sesHolder != null) {
                this.sesHolder.set(null);
            }
        }
    }

    protected abstract GridKernalContext igniteContext();

    protected abstract CacheConfiguration cacheConfiguration();

    private class EntriesView
    extends AbstractCollection<Cache.Entry<?, ?>> {
        private final Map<?, IgniteBiTuple<?, GridCacheVersion>> map;
        private Set<Object> rmvd;
        private boolean cleared;

        private EntriesView(Map<?, IgniteBiTuple<?, GridCacheVersion>> map) {
            assert (map != null);
            this.map = map;
        }

        @Override
        public int size() {
            return this.cleared ? 0 : this.map.size() - (this.rmvd != null ? this.rmvd.size() : 0);
        }

        @Override
        public boolean isEmpty() {
            return this.cleared || !this.iterator().hasNext();
        }

        @Override
        public boolean contains(Object o) {
            if (this.cleared || !(o instanceof Cache.Entry)) {
                return false;
            }
            Cache.Entry e = (Cache.Entry)o;
            return this.map.containsKey(e.getKey());
        }

        @Override
        @NotNull
        public Iterator<Cache.Entry<?, ?>> iterator() {
            if (this.cleared) {
                return new GridEmptyIterator();
            }
            final Iterator<Map.Entry<?, IgniteBiTuple<?, GridCacheVersion>>> it0 = this.map.entrySet().iterator();
            return new Iterator<Cache.Entry<?, ?>>(){
                private Cache.Entry<?, ?> cur;
                private Cache.Entry<?, ?> next;
                {
                    this.checkNext();
                }

                private void checkNext() {
                    while (it0.hasNext()) {
                        Map.Entry e = (Map.Entry)it0.next();
                        Object k = e.getKey();
                        Object v = GridCacheStoreManagerAdapter.this.locStore ? e.getValue() : ((IgniteBiTuple)e.getValue()).get1();
                        k = GridCacheStoreManagerAdapter.this.cctx.unwrapBinaryIfNeeded(k, !GridCacheStoreManagerAdapter.this.convertBinary());
                        v = GridCacheStoreManagerAdapter.this.cctx.unwrapBinaryIfNeeded(v, !GridCacheStoreManagerAdapter.this.convertBinary());
                        if (EntriesView.this.rmvd != null && EntriesView.this.rmvd.contains(k)) continue;
                        this.next = new CacheEntryImpl(k, v);
                        break;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public Cache.Entry<?, ?> next() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    this.cur = this.next;
                    this.next = null;
                    this.checkNext();
                    return this.cur;
                }

                @Override
                public void remove() {
                    if (this.cur == null) {
                        throw new IllegalStateException();
                    }
                    EntriesView.this.addRemoved(this.cur);
                    this.cur = null;
                }
            };
        }

        @Override
        public boolean add(Cache.Entry<?, ?> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Cache.Entry<?, ?>> col) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            if (this.cleared || !(o instanceof Cache.Entry)) {
                return false;
            }
            Cache.Entry e = (Cache.Entry)o;
            if (this.rmvd != null && this.rmvd.contains(e.getKey())) {
                return false;
            }
            if (this.mapContains(e)) {
                this.addRemoved(e);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> col) {
            if (this.cleared) {
                return false;
            }
            for (Object o : col) {
                if (!this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> col) {
            if (this.cleared) {
                return false;
            }
            boolean modified = false;
            for (Object o : col) {
                if (!this.remove(o)) continue;
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(Collection<?> col) {
            if (this.cleared) {
                return false;
            }
            boolean modified = false;
            for (Cache.Entry<?, ?> e : this) {
                if (col.contains(e)) continue;
                this.addRemoved(e);
                modified = true;
            }
            return modified;
        }

        @Override
        public void clear() {
            this.cleared = true;
        }

        private void addRemoved(Cache.Entry<?, ?> e) {
            if (this.rmvd == null) {
                this.rmvd = new HashSet<Object>();
            }
            this.rmvd.add(e.getKey());
        }

        private boolean mapContains(Cache.Entry<?, ?> e) {
            return this.map.containsKey(e.getKey());
        }

        @Override
        public String toString() {
            if (!S.INCLUDE_SENSITIVE) {
                return "[size=" + this.size() + "]";
            }
            Iterator<Cache.Entry<?, ?>> it = this.iterator();
            if (!it.hasNext()) {
                return "[]";
            }
            SB sb = new SB("[");
            while (true) {
                Cache.Entry<?, ?> e = it.next();
                sb.a(e.toString());
                if (!it.hasNext()) {
                    return sb.a(']').toString();
                }
                sb.a(", ");
            }
        }
    }

    private static class ThreadLocalSession
    implements CacheStoreSession {
        private final ThreadLocal<SessionData> sesHolder;

        private ThreadLocalSession(ThreadLocal<SessionData> sesHolder) {
            this.sesHolder = sesHolder;
        }

        @Override
        @Nullable
        public Transaction transaction() {
            SessionData ses0 = this.sesHolder.get();
            return ses0 != null ? ses0.transaction() : null;
        }

        @Override
        public boolean isWithinTransaction() {
            return this.transaction() != null;
        }

        public Object attach(@Nullable Object attachment) {
            SessionData ses0 = this.sesHolder.get();
            return ses0 != null ? ses0.attach(attachment) : null;
        }

        @Override
        @Nullable
        public <T> T attachment() {
            SessionData ses0 = this.sesHolder.get();
            return (T)(ses0 != null ? ses0.attachment() : null);
        }

        public <K1, V1> Map<K1, V1> properties() {
            SessionData ses0 = this.sesHolder.get();
            return ses0 != null ? ses0.properties() : null;
        }

        @Override
        @Nullable
        public String cacheName() {
            SessionData ses0 = this.sesHolder.get();
            return ses0 != null ? ses0.cacheName() : null;
        }

        public String toString() {
            return S.toString(ThreadLocalSession.class, this);
        }
    }

    private static class SessionData {
        @GridToStringExclude
        private final IgniteInternalTx tx;
        private String cacheName;
        @GridToStringInclude
        private Map<Object, Object> props;
        private Object attachment;
        private final Set<CacheStoreManager> started = new GridSetWrapper(new IdentityHashMap());
        private final Set<CacheStore> ended = new GridSetWrapper(new IdentityHashMap());

        private SessionData(@Nullable IgniteInternalTx tx, @Nullable String cacheName) {
            this.tx = tx;
            this.cacheName = cacheName;
        }

        @Nullable
        private Transaction transaction() {
            return this.tx != null ? this.tx.proxy() : null;
        }

        private Map<Object, Object> properties() {
            if (this.props == null) {
                this.props = new GridLeanMap<Object, Object>();
            }
            return this.props;
        }

        private Object attach(Object attachment) {
            Object prev = this.attachment;
            this.attachment = attachment;
            return prev;
        }

        private Object attachment() {
            return this.attachment;
        }

        private String cacheName() {
            return this.cacheName;
        }

        private void cacheName(String cacheName) {
            this.cacheName = cacheName;
        }

        private boolean started(CacheStoreManager mgr) {
            return !this.started.add(mgr);
        }

        private boolean ended(CacheStore store) {
            return !this.ended.add(store);
        }

        public String toString() {
            return S.toString(SessionData.class, this, "tx", CU.txString(this.tx));
        }
    }
}

