/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.IgniteTransactionsEx;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionMetrics;
import org.jetbrains.annotations.Nullable;

public class IgniteTransactionsImpl<K, V>
implements IgniteTransactionsEx {
    private GridCacheSharedContext<K, V> cctx;

    public IgniteTransactionsImpl(GridCacheSharedContext<K, V> cctx) {
        this.cctx = cctx;
    }

    @Override
    public Transaction txStart() throws IllegalStateException {
        TransactionConfiguration cfg = CU.transactionConfiguration(null, this.cctx.kernalContext().config());
        return this.txStart0(cfg.getDefaultTxConcurrency(), cfg.getDefaultTxIsolation(), cfg.getDefaultTxTimeout(), 0, null).proxy();
    }

    @Override
    public Transaction txStart(TransactionConcurrency concurrency, TransactionIsolation isolation) {
        A.notNull((Object)concurrency, "concurrency");
        A.notNull((Object)isolation, "isolation");
        TransactionConfiguration cfg = CU.transactionConfiguration(null, this.cctx.kernalContext().config());
        return this.txStart0(concurrency, isolation, cfg.getDefaultTxTimeout(), 0, null).proxy();
    }

    @Override
    public Transaction txStart(TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout, int txSize) {
        A.notNull((Object)concurrency, "concurrency");
        A.notNull((Object)isolation, "isolation");
        A.ensure(timeout >= 0L, "timeout cannot be negative");
        A.ensure(txSize >= 0, "transaction size cannot be negative");
        return this.txStart0(concurrency, isolation, timeout, txSize, null).proxy();
    }

    @Override
    public IgniteInternalTx txStartEx(GridCacheContext ctx, TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout, int txSize) {
        A.notNull((Object)concurrency, "concurrency");
        A.notNull((Object)isolation, "isolation");
        A.ensure(timeout >= 0L, "timeout cannot be negative");
        A.ensure(txSize >= 0, "transaction size cannot be negative");
        this.checkTransactional(ctx);
        return this.txStart0(concurrency, isolation, timeout, txSize, ctx.systemTx() ? ctx : null);
    }

    @Override
    public IgniteInternalTx txStartEx(GridCacheContext ctx, TransactionConcurrency concurrency, TransactionIsolation isolation) {
        A.notNull((Object)concurrency, "concurrency");
        A.notNull((Object)isolation, "isolation");
        this.checkTransactional(ctx);
        TransactionConfiguration cfg = CU.transactionConfiguration(ctx, this.cctx.kernalContext().config());
        return this.txStart0(concurrency, isolation, cfg.getDefaultTxTimeout(), 0, ctx.systemTx() ? ctx : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalTx txStart0(TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout, int txSize, @Nullable GridCacheContext sysCacheCtx) {
        this.cctx.kernalContext().gateway().readLock();
        try {
            IgniteInternalTx tx = this.cctx.tm().userTx(sysCacheCtx);
            if (tx != null) {
                throw new IllegalStateException("Failed to start new transaction (current thread already has a transaction): " + tx);
            }
            tx = this.cctx.tm().newTx(false, false, sysCacheCtx, concurrency, isolation, timeout, true, txSize);
            assert (tx != null);
            IgniteInternalTx igniteInternalTx = tx;
            return igniteInternalTx;
        }
        finally {
            this.cctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    @Nullable
    public Transaction tx() {
        IgniteInternalTx tx = this.cctx.tm().userTx();
        return tx != null ? tx.proxy() : null;
    }

    @Override
    public TransactionMetrics metrics() {
        return this.cctx.txMetrics();
    }

    @Override
    public void resetMetrics() {
        this.cctx.resetTxMetrics();
    }

    private void checkTransactional(GridCacheContext ctx) {
        if (!ctx.transactional()) {
            throw new IgniteException("Failed to start transaction on non-transactional cache: " + ctx.name());
        }
    }
}

