/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturnCompletableWrapper;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridCacheTxRecoveryFuture;
import org.apache.ignite.internal.processors.cache.distributed.GridCacheTxRecoveryRequest;
import org.apache.ignite.internal.processors.cache.distributed.GridCacheTxRecoveryResponse;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxRemoteAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxOnePhaseCommitAckRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxRemote;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxRemote;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxRemoteEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.transactions.IgniteTxHeuristicCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxOptimisticCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteFutureCancelledException;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class IgniteTxHandler {
    private IgniteLogger log;
    private final IgniteLogger txPrepareMsgLog;
    private final IgniteLogger txFinishMsgLog;
    private final IgniteLogger txRecoveryMsgLog;
    private GridCacheSharedContext<?, ?> ctx;

    public IgniteInternalFuture<?> processNearTxPrepareRequest(UUID nearNodeId, GridNearTxPrepareRequest req) {
        if (this.txPrepareMsgLog.isDebugEnabled()) {
            this.txPrepareMsgLog.debug("Received near prepare request [txId=" + req.version() + ", node=" + nearNodeId + ']');
        }
        IgniteInternalFuture<GridNearTxPrepareResponse> fut = this.prepareTx(nearNodeId, null, req);
        assert (req.txState() != null || fut.error() != null || this.ctx.tm().tx(req.version()) == null && this.ctx.tm().nearTx(req.version()) == null);
        return fut;
    }

    public IgniteTxHandler(GridCacheSharedContext ctx) {
        this.ctx = ctx;
        this.log = ctx.logger(IgniteTxHandler.class);
        this.txRecoveryMsgLog = ctx.logger("org.apache.ignite.cache.msg.tx.recovery");
        this.txPrepareMsgLog = ctx.logger("org.apache.ignite.cache.msg.tx.prepare");
        this.txFinishMsgLog = ctx.logger("org.apache.ignite.cache.msg.tx.finish");
        ctx.io().addHandler(0, GridNearTxPrepareRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processNearTxPrepareRequest(nodeId, (GridNearTxPrepareRequest)msg);
            }
        });
        ctx.io().addHandler(0, GridNearTxPrepareResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processNearTxPrepareResponse(nodeId, (GridNearTxPrepareResponse)msg);
            }
        });
        ctx.io().addHandler(0, GridNearTxFinishRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processNearTxFinishRequest(nodeId, (GridNearTxFinishRequest)msg);
            }
        });
        ctx.io().addHandler(0, GridNearTxFinishResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processNearTxFinishResponse(nodeId, (GridNearTxFinishResponse)msg);
            }
        });
        ctx.io().addHandler(0, GridDhtTxPrepareRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processDhtTxPrepareRequest(nodeId, (GridDhtTxPrepareRequest)msg);
            }
        });
        ctx.io().addHandler(0, GridDhtTxPrepareResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processDhtTxPrepareResponse(nodeId, (GridDhtTxPrepareResponse)msg);
            }
        });
        ctx.io().addHandler(0, GridDhtTxFinishRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processDhtTxFinishRequest(nodeId, (GridDhtTxFinishRequest)msg);
            }
        });
        ctx.io().addHandler(0, GridDhtTxOnePhaseCommitAckRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processDhtTxOnePhaseCommitAckRequest(nodeId, (GridDhtTxOnePhaseCommitAckRequest)msg);
            }
        });
        ctx.io().addHandler(0, GridDhtTxFinishResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processDhtTxFinishResponse(nodeId, (GridDhtTxFinishResponse)msg);
            }
        });
        ctx.io().addHandler(0, GridCacheTxRecoveryRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheTxRecoveryRequest>(){

            @Override
            public void apply(UUID nodeId, GridCacheTxRecoveryRequest req) {
                IgniteTxHandler.this.processCheckPreparedTxRequest(nodeId, req);
            }
        });
        ctx.io().addHandler(0, GridCacheTxRecoveryResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheTxRecoveryResponse>(){

            @Override
            public void apply(UUID nodeId, GridCacheTxRecoveryResponse res) {
                IgniteTxHandler.this.processCheckPreparedTxResponse(nodeId, res);
            }
        });
    }

    public IgniteInternalFuture<GridNearTxPrepareResponse> prepareTx(UUID nearNodeId, @Nullable GridNearTxLocal locTx, GridNearTxPrepareRequest req) {
        assert (nearNodeId != null);
        assert (req != null);
        if (locTx != null) {
            if (req.near()) {
                req.cloneEntries();
                return this.prepareNearTx(nearNodeId, req);
            }
            return this.prepareColocatedTx(locTx, req);
        }
        return this.prepareNearTx(nearNodeId, req);
    }

    private IgniteInternalFuture<GridNearTxPrepareResponse> prepareColocatedTx(final GridNearTxLocal locTx, final GridNearTxPrepareRequest req) {
        req.txState(locTx.txState());
        IgniteInternalFuture<GridNearTxPrepareResponse> fut = locTx.prepareAsyncLocal(req.reads(), req.writes(), req.transactionNodes(), req.last());
        if (locTx.isRollbackOnly()) {
            locTx.rollbackAsync();
        }
        return fut.chain(new C1<IgniteInternalFuture<GridNearTxPrepareResponse>, GridNearTxPrepareResponse>(){

            @Override
            public GridNearTxPrepareResponse apply(IgniteInternalFuture<GridNearTxPrepareResponse> f) {
                try {
                    return f.get();
                }
                catch (Exception e) {
                    locTx.setRollbackOnly();
                    if (!X.hasCause(e, IgniteTxOptimisticCheckedException.class) && !X.hasCause(e, IgniteFutureCancelledException.class)) {
                        U.error(IgniteTxHandler.this.log, "Failed to prepare DHT transaction: " + locTx, e);
                    }
                    return new GridNearTxPrepareResponse(req.version(), req.futureId(), req.miniId(), req.version(), req.version(), null, e, null, req.deployInfo() != null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalFuture<GridNearTxPrepareResponse> prepareNearTx(UUID nearNodeId, GridNearTxPrepareRequest req) {
        ClusterNode nearNode = this.ctx.node(nearNodeId);
        if (nearNode == null) {
            if (this.txPrepareMsgLog.isDebugEnabled()) {
                this.txPrepareMsgLog.debug("Received near prepare from node that left grid (will ignore) [txId=" + req.version() + ", node=" + nearNodeId + ']');
            }
            return null;
        }
        IgniteTxEntry firstEntry = null;
        try {
            for (IgniteTxEntry e : F.concat(false, req.reads(), req.writes())) {
                e.unmarshal(this.ctx, false, this.ctx.deploy().globalLoader());
                if (firstEntry != null) continue;
                firstEntry = e;
            }
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<GridNearTxPrepareResponse>(e);
        }
        assert (firstEntry != null) : req;
        GridDhtTxLocal tx = null;
        GridCacheVersion mappedVer = this.ctx.tm().mappedVersion(req.version());
        if (mappedVer != null) {
            tx = (GridDhtTxLocal)this.ctx.tm().tx(mappedVer);
            if (tx == null) {
                U.warn(this.log, "Missing local transaction for mapped near version [nearVer=" + req.version() + ", mappedVer=" + mappedVer + ']');
            } else if (req.concurrency() == TransactionConcurrency.PESSIMISTIC) {
                tx.nearFutureId(req.futureId());
            }
        } else {
            GridDhtPartitionTopology top = null;
            if (req.firstClientRequest()) {
                assert (req.concurrency() == TransactionConcurrency.OPTIMISTIC) : req;
                assert (CU.clientNode(nearNode)) : nearNode;
                top = firstEntry.context().topology();
                top.readLock();
            }
            try {
                if (top != null && this.needRemap(req.topologyVersion(), top.topologyVersion(), req)) {
                    if (this.txPrepareMsgLog.isDebugEnabled()) {
                        this.txPrepareMsgLog.debug("Topology version mismatch for near prepare, need remap transaction [txId=" + req.version() + ", node=" + nearNodeId + ", reqTopVer=" + req.topologyVersion() + ", locTopVer=" + top.topologyVersion() + ", req=" + req + ']');
                    }
                    GridNearTxPrepareResponse res = new GridNearTxPrepareResponse(req.version(), req.futureId(), req.miniId(), req.version(), req.version(), null, null, top.topologyVersion(), req.deployInfo() != null);
                    try {
                        this.ctx.io().send(nearNodeId, (GridCacheMessage)res, req.policy());
                        if (this.txPrepareMsgLog.isDebugEnabled()) {
                            this.txPrepareMsgLog.debug("Sent remap response for near prepare [txId=" + req.version() + ", node=" + nearNodeId + ']');
                        }
                    }
                    catch (ClusterTopologyCheckedException ignored) {
                        if (this.txPrepareMsgLog.isDebugEnabled()) {
                            this.txPrepareMsgLog.debug("Failed to send remap response for near prepare, node failed [txId=" + req.version() + ", node=" + nearNodeId + ']');
                        }
                    }
                    catch (IgniteCheckedException e) {
                        U.error(this.txPrepareMsgLog, "Failed to send remap response for near prepare [txId=" + req.version() + ", node=" + nearNodeId + ", req=" + req + ']', e);
                    }
                    GridFinishedFuture<GridNearTxPrepareResponse> gridFinishedFuture = new GridFinishedFuture<GridNearTxPrepareResponse>(res);
                    return gridFinishedFuture;
                }
                tx = new GridDhtTxLocal(this.ctx, req.topologyVersion(), nearNode.id(), req.version(), req.futureId(), req.miniId(), req.threadId(), req.implicitSingle(), req.implicitSingle(), req.system(), req.explicitLock(), req.policy(), req.concurrency(), req.isolation(), req.timeout(), req.isInvalidate(), true, req.onePhaseCommit(), req.txSize(), req.transactionNodes(), req.subjectId(), req.taskNameHash());
                tx = this.ctx.tm().onCreated(null, tx);
                if (tx != null) {
                    tx.topologyVersion(req.topologyVersion());
                } else {
                    U.warn(this.log, "Failed to create local transaction (was transaction rolled back?) [xid=" + req.version() + ", req=" + req + ']');
                }
            }
            finally {
                if (tx != null) {
                    req.txState(tx.txState());
                }
                if (top != null) {
                    top.readUnlock();
                }
            }
        }
        if (tx != null) {
            req.txState(tx.txState());
            if (req.explicitLock()) {
                tx.explicitLock(true);
            }
            tx.transactionNodes(req.transactionNodes());
            if (req.near() && GridNearTxFinishFuture.FINISH_NEAR_ONE_PHASE_SINCE.compareTo(nearNode.version()) <= 0) {
                tx.nearOnOriginatingNode(true);
            }
            if (req.onePhaseCommit()) {
                assert (req.last());
                tx.onePhaseCommit(true);
            }
            if (req.returnValue()) {
                tx.needReturnValue(true);
            }
            IgniteInternalFuture<GridNearTxPrepareResponse> fut = tx.prepareAsync(req.reads(), req.writes(), req.dhtVersions(), req.messageId(), req.miniId(), req.transactionNodes(), req.last());
            if (tx.isRollbackOnly() && !tx.commitOnPrepare() && tx.state() != TransactionState.ROLLED_BACK && tx.state() != TransactionState.ROLLING_BACK) {
                tx.rollbackAsync();
            }
            final GridDhtTxLocal tx0 = tx;
            fut.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> txFut) {
                    block2: {
                        try {
                            txFut.get();
                        }
                        catch (IgniteCheckedException e) {
                            tx0.setRollbackOnly();
                            if (X.hasCause(e, IgniteTxOptimisticCheckedException.class) || X.hasCause(e, IgniteFutureCancelledException.class) || IgniteTxHandler.this.ctx.kernalContext().isStopping()) break block2;
                            U.error(IgniteTxHandler.this.log, "Failed to prepare DHT transaction: " + tx0, e);
                        }
                    }
                }
            });
            return fut;
        }
        return new GridFinishedFuture<GridNearTxPrepareResponse>((GridNearTxPrepareResponse)null);
    }

    private boolean needRemap(AffinityTopologyVersion expVer, AffinityTopologyVersion curVer, GridNearTxPrepareRequest req) {
        if (expVer.equals(curVer)) {
            return false;
        }
        for (IgniteTxEntry e : F.concat(false, req.reads(), req.writes())) {
            Collection<ClusterNode> cacheNodes1;
            GridCacheContext<?, ?> ctx = e.context();
            Collection<ClusterNode> cacheNodes0 = ctx.discovery().cacheAffinityNodes(ctx.name(), expVer);
            if (!cacheNodes0.equals(cacheNodes1 = ctx.discovery().cacheAffinityNodes(ctx.name(), curVer)) || ctx.affinity().affinityTopologyVersion().compareTo(curVer) < 0) {
                return true;
            }
            try {
                List<List<ClusterNode>> aff2;
                List<List<ClusterNode>> aff1 = ctx.affinity().assignments(expVer);
                if (aff1.equals(aff2 = ctx.affinity().assignments(curVer))) continue;
                return true;
            }
            catch (IllegalStateException ignored) {
                return true;
            }
        }
        return false;
    }

    private void processNearTxPrepareResponse(UUID nodeId, GridNearTxPrepareResponse res) {
        GridNearTxPrepareFutureAdapter fut;
        if (this.txPrepareMsgLog.isDebugEnabled()) {
            this.txPrepareMsgLog.debug("Received near prepare response [txId=" + res.version() + ", node=" + nodeId + ']');
        }
        if ((fut = (GridNearTxPrepareFutureAdapter)this.ctx.mvcc().mvccFuture(res.version(), res.futureId())) == null) {
            U.warn(this.log, "Failed to find future for near prepare response [txId=" + res.version() + ", node=" + nodeId + ", res=" + res + ']');
            return;
        }
        IgniteInternalTx tx = fut.tx();
        assert (tx != null);
        res.txState(tx.txState());
        fut.onResult(nodeId, res);
    }

    private void processNearTxFinishResponse(UUID nodeId, GridNearTxFinishResponse res) {
        if (this.txFinishMsgLog.isDebugEnabled()) {
            this.txFinishMsgLog.debug("Received near finish response [txId=" + res.xid() + ", node=" + nodeId + ']');
        }
        this.ctx.tm().onFinishedRemote(nodeId, res.threadId());
        GridNearTxFinishFuture fut = (GridNearTxFinishFuture)this.ctx.mvcc().future(res.futureId());
        if (fut == null) {
            if (this.txFinishMsgLog.isDebugEnabled()) {
                this.txFinishMsgLog.debug("Failed to find future for near finish response [txId=" + res.xid() + ", node=" + nodeId + ", res=" + res + ']');
            }
            return;
        }
        fut.onResult(nodeId, res);
    }

    private void processDhtTxPrepareResponse(UUID nodeId, GridDhtTxPrepareResponse res) {
        GridDhtTxPrepareFuture fut = (GridDhtTxPrepareFuture)this.ctx.mvcc().mvccFuture(res.version(), res.futureId());
        if (fut == null) {
            if (this.txPrepareMsgLog.isDebugEnabled()) {
                this.txPrepareMsgLog.debug("Failed to find future for dht prepare response [txId=null, dhtTxId=" + res.version() + ", node=" + nodeId + ", res=" + res + ']');
            }
            return;
        }
        if (this.txPrepareMsgLog.isDebugEnabled()) {
            this.txPrepareMsgLog.debug("Received dht prepare response [txId=" + fut.tx().nearXidVersion() + ", node=" + nodeId + ']');
        }
        GridDhtTxLocalAdapter tx = fut.tx();
        assert (tx != null);
        res.txState(tx.txState());
        fut.onResult(nodeId, res);
    }

    private void processDhtTxFinishResponse(UUID nodeId, GridDhtTxFinishResponse res) {
        assert (nodeId != null);
        assert (res != null);
        if (res.checkCommitted()) {
            GridNearTxFinishFuture fut = (GridNearTxFinishFuture)this.ctx.mvcc().future(res.futureId());
            if (fut == null) {
                if (this.txFinishMsgLog.isDebugEnabled()) {
                    this.txFinishMsgLog.debug("Failed to find future for dht finish check committed response [txId=null, dhtTxId=" + res.xid() + ", node=" + nodeId + ", res=" + res + ']');
                }
                return;
            }
            if (this.txFinishMsgLog.isDebugEnabled()) {
                this.txFinishMsgLog.debug("Received dht finish check committed response [txId=" + fut.tx().nearXidVersion() + ", dhtTxId=" + res.xid() + ", node=" + nodeId + ']');
            }
            fut.onResult(nodeId, res);
        } else {
            GridDhtTxFinishFuture fut = (GridDhtTxFinishFuture)this.ctx.mvcc().future(res.futureId());
            if (fut == null) {
                if (this.txFinishMsgLog.isDebugEnabled()) {
                    this.txFinishMsgLog.debug("Failed to find future for dht finish response [txId=null, dhtTxId=" + res.xid() + ", node=" + nodeId + ", res=" + res);
                }
                return;
            }
            if (this.txFinishMsgLog.isDebugEnabled()) {
                this.txFinishMsgLog.debug("Received dht finish response [txId=" + fut.tx().nearXidVersion() + ", dhtTxId=" + res.xid() + ", node=" + nodeId + ']');
            }
            fut.onResult(nodeId, res);
        }
    }

    @Nullable
    private IgniteInternalFuture<IgniteInternalTx> processNearTxFinishRequest(UUID nodeId, GridNearTxFinishRequest req) {
        if (this.txFinishMsgLog.isDebugEnabled()) {
            this.txFinishMsgLog.debug("Received near finish request [txId=" + req.version() + ", node=" + nodeId + ']');
        }
        IgniteInternalFuture<IgniteInternalTx> fut = this.finish(nodeId, null, req);
        assert (req.txState() != null || fut != null && fut.error() != null || this.ctx.tm().tx(req.version()) == null && this.ctx.tm().nearTx(req.version()) == null);
        return fut;
    }

    @Nullable
    public IgniteInternalFuture<IgniteInternalTx> finish(UUID nodeId, @Nullable GridNearTxLocal locTx, GridNearTxFinishRequest req) {
        assert (nodeId != null);
        assert (req != null);
        if (locTx != null) {
            req.txState(locTx.txState());
        }
        if (!req.commit() && req.baseVersion() != null) {
            this.ctx.tm().addRolledbackTx(null, req.baseVersion());
        }
        if (locTx != null && !locTx.nearLocallyMapped() && !locTx.colocatedLocallyMapped()) {
            return new GridFinishedFuture<IgniteInternalTx>(locTx);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing near tx finish request [nodeId=" + nodeId + ", req=" + req + "]");
        }
        IgniteInternalFuture<IgniteInternalTx> colocatedFinishFut = null;
        if (locTx != null && locTx.colocatedLocallyMapped()) {
            colocatedFinishFut = this.finishColocatedLocal(req.commit(), locTx);
        }
        IgniteInternalFuture<IgniteInternalTx> nearFinishFut = null;
        if (locTx == null || locTx.nearLocallyMapped()) {
            nearFinishFut = this.finishDhtLocal(nodeId, locTx, req);
        }
        if (colocatedFinishFut != null && nearFinishFut != null) {
            GridCompoundFuture res = new GridCompoundFuture();
            res.add(colocatedFinishFut);
            res.add(nearFinishFut);
            res.markInitialized();
            return res;
        }
        if (colocatedFinishFut != null) {
            return colocatedFinishFut;
        }
        return nearFinishFut;
    }

    private IgniteInternalFuture<IgniteInternalTx> finishDhtLocal(UUID nodeId, @Nullable GridNearTxLocal locTx, GridNearTxFinishRequest req) {
        GridCacheVersion dhtVer = this.ctx.tm().mappedVersion(req.version());
        GridDhtTxLocal tx = null;
        if (dhtVer == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received transaction finish request for unknown near version (was lock explicit?): " + req);
            }
        } else {
            tx = (GridDhtTxLocal)this.ctx.tm().tx(dhtVer);
        }
        if (tx != null) {
            req.txState(tx.txState());
        }
        if (tx == null && locTx != null && !req.commit()) {
            U.warn(this.log, "DHT local tx not found for near local tx rollback [req=" + req + ", dhtVer=" + dhtVer + ", tx=" + locTx + ']');
            return null;
        }
        if (tx == null && !req.explicitLock()) {
            block22: {
                assert (locTx == null) : "DHT local tx should never be lost for near local tx: " + locTx;
                U.warn(this.txFinishMsgLog, "Received finish request for completed transaction (the message may be too late) [txId=" + req.version() + ", dhtTxId=" + dhtVer + ", node=" + nodeId + ", commit=" + req.commit() + ']');
                GridNearTxFinishResponse res = new GridNearTxFinishResponse(req.version(), req.threadId(), req.futureId(), req.miniId(), new IgniteCheckedException("Transaction has been already completed."));
                try {
                    this.ctx.io().send(nodeId, (GridCacheMessage)res, req.policy());
                    if (this.txFinishMsgLog.isDebugEnabled()) {
                        this.txFinishMsgLog.debug("Sent near finish response for completed tx [txId=" + req.version() + ", dhtTxId=" + dhtVer + ", node=" + nodeId + ']');
                    }
                }
                catch (Throwable e) {
                    if (this.ctx.discovery().node(nodeId) == null) {
                        if (this.txFinishMsgLog.isDebugEnabled()) {
                            this.txFinishMsgLog.debug("Failed to send near finish response for completed tx, node failed [txId=" + req.version() + ", dhtTxId=" + dhtVer + ", node=" + nodeId + ']');
                        }
                    } else {
                        U.error(this.txFinishMsgLog, "Failed to send near finish response for completed tx, node failed [txId=" + req.version() + ", dhtTxId=" + dhtVer + ", node=" + nodeId + ", req=" + req + ", res=" + res + ']', e);
                    }
                    if (!(e instanceof Error)) break block22;
                    throw (Error)e;
                }
            }
            return null;
        }
        try {
            assert (tx != null) : "Transaction is null for near finish request [nodeId=" + nodeId + ", req=" + req + "]";
            if (req.syncMode() == null) {
                boolean sync = req.commit() ? req.syncCommit() : req.syncRollback();
                tx.syncMode(sync ? CacheWriteSynchronizationMode.FULL_SYNC : CacheWriteSynchronizationMode.FULL_ASYNC);
            } else {
                tx.syncMode(req.syncMode());
            }
            if (req.commit()) {
                tx.storeEnabled(req.storeEnabled());
                if (!tx.markFinalizing(IgniteInternalTx.FinalizationStatus.USER_FINISH)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Will not finish transaction (it is handled by another thread): " + tx);
                    }
                    return null;
                }
                tx.nearFinishFutureId(req.futureId());
                tx.nearFinishMiniId(req.miniId());
                IgniteInternalFuture<IgniteInternalTx> commitFut = tx.commitAsync();
                commitFut.listen(CU.errorLogger(this.log, new Class[0]));
                return commitFut;
            }
            tx.nearFinishFutureId(req.futureId());
            tx.nearFinishMiniId(req.miniId());
            IgniteInternalFuture<IgniteInternalTx> rollbackFut = tx.rollbackAsync();
            rollbackFut.listen(CU.errorLogger(this.log, new Class[0]));
            return rollbackFut;
        }
        catch (Throwable e) {
            tx.commitError(e);
            tx.systemInvalidate(true);
            U.error(this.log, "Failed completing transaction [commit=" + req.commit() + ", tx=" + tx + ']', e);
            IgniteInternalFuture<IgniteInternalTx> rollbackFut = tx.rollbackAsync();
            rollbackFut.listen(CU.errorLogger(this.log, new Class[0]));
            IgniteInternalFuture<IgniteInternalTx> res = rollbackFut;
            if (e instanceof Error) {
                throw (Error)e;
            }
            return res;
        }
    }

    public IgniteInternalFuture<IgniteInternalTx> finishColocatedLocal(boolean commit, GridNearTxLocal tx) {
        try {
            if (commit) {
                if (!tx.markFinalizing(IgniteInternalTx.FinalizationStatus.USER_FINISH)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Will not finish transaction (it is handled by another thread): " + tx);
                    }
                    return null;
                }
                return tx.commitAsyncLocal();
            }
            return tx.rollbackAsyncLocal();
        }
        catch (Throwable e) {
            U.error(this.log, "Failed completing transaction [commit=" + commit + ", tx=" + tx + ']', e);
            if (e instanceof Error) {
                throw e;
            }
            if (tx != null) {
                return tx.rollbackAsync();
            }
            return new GridFinishedFuture<IgniteInternalTx>(e);
        }
    }

    protected final void processDhtTxPrepareRequest(final UUID nodeId, final GridDhtTxPrepareRequest req) {
        GridDhtTxPrepareResponse res;
        if (this.txPrepareMsgLog.isDebugEnabled()) {
            this.txPrepareMsgLog.debug("Received dht prepare request [txId=" + req.nearXidVersion() + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
        }
        assert (nodeId != null);
        assert (req != null);
        assert (req.transactionNodes() != null);
        GridDhtTxRemote dhtTx = null;
        GridDistributedTxRemoteAdapter nearTx = null;
        try {
            res = new GridDhtTxPrepareResponse(req.version(), req.futureId(), req.miniId(), req.deployInfo() != null);
            nearTx = !F.isEmpty(req.nearWrites()) ? this.startNearRemoteTx(this.ctx.deploy().globalLoader(), nodeId, req) : null;
            dhtTx = this.startRemoteTx(nodeId, req, res);
            if (nearTx != null) {
                res.nearEvicted(((GridNearTxRemote)nearTx).evicted());
            }
            if (dhtTx != null) {
                req.txState(dhtTx.txState());
            } else if (nearTx != null) {
                req.txState(nearTx.txState());
            }
            if (dhtTx != null && !F.isEmpty(dhtTx.invalidPartitions())) {
                res.invalidPartitionsByCacheId(dhtTx.invalidPartitions());
            }
            if (req.onePhaseCommit()) {
                assert (req.last());
                if (dhtTx != null) {
                    dhtTx.onePhaseCommit(true);
                    dhtTx.needReturnValue(req.needReturnValue());
                    this.finish(dhtTx, req);
                }
                if (nearTx != null) {
                    nearTx.onePhaseCommit(true);
                    this.finish(nearTx, req);
                }
            }
        }
        catch (IgniteCheckedException e) {
            if (e instanceof IgniteTxRollbackCheckedException) {
                U.error(this.log, "Transaction was rolled back before prepare completed: " + req, e);
            } else if (e instanceof IgniteTxOptimisticCheckedException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Optimistic failure for remote transaction (will rollback): " + req);
                }
            } else if (e instanceof IgniteTxHeuristicCheckedException) {
                U.warn(this.log, "Failed to commit transaction (all transaction entries were invalidated): " + CU.txString(dhtTx));
            } else {
                U.error(this.log, "Failed to process prepare request: " + req, e);
            }
            if (nearTx != null) {
                nearTx.rollback();
            }
            res = new GridDhtTxPrepareResponse(req.version(), req.futureId(), req.miniId(), e, req.deployInfo() != null);
        }
        if (req.onePhaseCommit()) {
            IgniteInternalFuture<IgniteInternalTx> completeFut;
            IgniteInternalFuture<IgniteInternalTx> nearFin;
            IgniteInternalFuture<IgniteInternalTx> dhtFin;
            IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture = dhtTx == null ? null : (dhtFin = dhtTx.done() ? null : dhtTx.finishFuture());
            IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture2 = nearTx == null ? null : (nearFin = nearTx.done() ? null : nearTx.finishFuture());
            if (dhtFin != null && nearFin != null) {
                GridCompoundFuture<IgniteInternalTx, IgniteInternalTx> fut = new GridCompoundFuture<IgniteInternalTx, IgniteInternalTx>();
                fut.add(dhtFin);
                fut.add(nearFin);
                fut.markInitialized();
                completeFut = fut;
            } else {
                IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture3 = completeFut = dhtFin != null ? dhtFin : nearFin;
            }
            if (completeFut != null) {
                final GridDhtTxPrepareResponse res0 = res;
                final GridDhtTxRemote dhtTx0 = dhtTx;
                GridDistributedTxRemoteAdapter nearTx0 = nearTx;
                completeFut.listen((IgniteInClosure<IgniteInternalFuture<IgniteInternalTx>>)new CI1<IgniteInternalFuture<IgniteInternalTx>>((GridNearTxRemote)nearTx0){
                    final /* synthetic */ GridNearTxRemote val$nearTx0;
                    {
                        this.val$nearTx0 = gridNearTxRemote;
                    }

                    @Override
                    public void apply(IgniteInternalFuture<IgniteInternalTx> fut) {
                        IgniteTxHandler.this.sendReply(nodeId, req, res0, dhtTx0, this.val$nearTx0);
                    }
                });
            } else {
                this.sendReply(nodeId, req, res, dhtTx, (GridNearTxRemote)nearTx);
            }
        } else {
            this.sendReply(nodeId, req, res, dhtTx, (GridNearTxRemote)nearTx);
        }
        assert (req.txState() != null || res.error() != null || this.ctx.tm().tx(req.version()) == null && this.ctx.tm().nearTx(req.version()) == null);
    }

    protected final void processDhtTxOnePhaseCommitAckRequest(UUID nodeId, GridDhtTxOnePhaseCommitAckRequest req) {
        assert (nodeId != null);
        assert (req != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing dht tx one phase commit ack request [nodeId=" + nodeId + ", req=" + req + ']');
        }
        for (GridCacheVersion ver : req.versions()) {
            this.ctx.tm().removeTxReturn(ver);
        }
    }

    protected final void processDhtTxFinishRequest(final UUID nodeId, final GridDhtTxFinishRequest req) {
        GridCacheVersion nearTxId;
        assert (nodeId != null);
        assert (req != null);
        if (req.checkCommitted()) {
            boolean committed;
            boolean bl = committed = req.waitRemoteTransactions() || !this.ctx.tm().addRolledbackTx(null, req.version());
            if (!committed || !req.syncCommit()) {
                this.sendReply(nodeId, req, committed, null);
            } else {
                IgniteInternalFuture<?> fut = this.ctx.tm().remoteTxFinishFuture(req.version());
                fut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> fut) {
                        IgniteTxHandler.this.sendReply(nodeId, req, true, null);
                    }
                });
            }
            return;
        }
        GridDhtTxRemote dhtTx = (GridDhtTxRemote)this.ctx.tm().tx(req.version());
        GridNearTxRemote nearTx = (GridNearTxRemote)this.ctx.tm().nearTx(req.version());
        GridCacheVersion gridCacheVersion = dhtTx != null ? dhtTx.nearXidVersion() : (nearTxId = nearTx != null ? nearTx.nearXidVersion() : null);
        if (this.txFinishMsgLog.isDebugEnabled()) {
            this.txFinishMsgLog.debug("Received dht finish request [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
        }
        if (nearTx != null && nearTx.local()) {
            nearTx = null;
        }
        this.finish(nodeId, dhtTx, req);
        if (nearTx != null) {
            this.finish(nodeId, nearTx, req);
        }
        if (req.replyRequired()) {
            IgniteInternalFuture<IgniteInternalTx> completeFut;
            IgniteInternalFuture<IgniteInternalTx> nearFin;
            IgniteInternalFuture<IgniteInternalTx> dhtFin;
            IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture = dhtTx == null ? null : (dhtFin = dhtTx.done() ? null : dhtTx.finishFuture());
            IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture2 = nearTx == null ? null : (nearFin = nearTx.done() ? null : nearTx.finishFuture());
            if (dhtFin != null && nearFin != null) {
                GridCompoundFuture<IgniteInternalTx, IgniteInternalTx> fut = new GridCompoundFuture<IgniteInternalTx, IgniteInternalTx>();
                fut.add(dhtFin);
                fut.add(nearFin);
                fut.markInitialized();
                completeFut = fut;
            } else {
                IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture3 = completeFut = dhtFin != null ? dhtFin : nearFin;
            }
            if (completeFut != null) {
                completeFut.listen((IgniteInClosure<IgniteInternalFuture<IgniteInternalTx>>)new CI1<IgniteInternalFuture<IgniteInternalTx>>(){

                    @Override
                    public void apply(IgniteInternalFuture<IgniteInternalTx> igniteTxIgniteFuture) {
                        IgniteTxHandler.this.sendReply(nodeId, req, true, nearTxId);
                    }
                });
            } else {
                this.sendReply(nodeId, req, true, nearTxId);
            }
        } else {
            this.sendReply(nodeId, req, true, null);
        }
        assert (req.txState() != null || this.ctx.tm().tx(req.version()) == null && this.ctx.tm().nearTx(req.version()) == null) : req;
    }

    protected void finish(UUID nodeId, IgniteTxRemoteEx tx, GridDhtTxFinishRequest req) {
        block11: {
            if (tx == null) {
                if (req.commit()) {
                    this.ctx.tm().addCommittedTx(tx, req.version(), null);
                } else {
                    this.ctx.tm().addRolledbackTx(tx, req.version());
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received finish request for non-existing transaction (added to completed set) [senderNodeId=" + nodeId + ", res=" + req + ']');
                }
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received finish request for transaction [senderNodeId=" + nodeId + ", req=" + req + ", tx=" + tx + ']');
            }
            req.txState(tx.txState());
            try {
                if (req.commit() || req.isSystemInvalidate()) {
                    tx.commitVersion(req.commitVersion());
                    tx.invalidate(req.isInvalidate());
                    tx.systemInvalidate(req.isSystemInvalidate());
                    tx.doneRemote(req.baseVersion(), null, null, null);
                    tx.setPartitionUpdateCounters(req.partUpdateCounters() != null ? req.partUpdateCounters().array() : null);
                    tx.commit();
                } else {
                    tx.doneRemote(req.baseVersion(), null, null, null);
                    tx.rollback();
                }
            }
            catch (Throwable e) {
                U.error(this.log, "Failed completing transaction [commit=" + req.commit() + ", tx=" + tx + ']', e);
                tx.invalidate(true);
                tx.systemInvalidate(true);
                try {
                    tx.commit();
                }
                catch (IgniteCheckedException ex) {
                    U.error(this.log, "Failed to invalidate transaction: " + tx, ex);
                }
                if (!(e instanceof Error)) break block11;
                throw (Error)e;
            }
        }
    }

    protected void finish(GridDistributedTxRemoteAdapter tx, GridDhtTxPrepareRequest req) throws IgniteTxHeuristicCheckedException {
        block4: {
            assert (tx != null) : "No transaction for one-phase commit prepare request: " + req;
            try {
                tx.commitVersion(req.writeVersion());
                tx.invalidate(req.isInvalidate());
                tx.doneRemote(req.version(), null, null, null);
                tx.commit();
            }
            catch (IgniteTxHeuristicCheckedException e) {
                throw e;
            }
            catch (Throwable e) {
                U.error(this.log, "Failed committing transaction [tx=" + tx + ']', e);
                tx.invalidate(true);
                tx.systemInvalidate(true);
                tx.rollback();
                if (!(e instanceof Error)) break block4;
                throw (Error)e;
            }
        }
    }

    protected void sendReply(UUID nodeId, GridDhtTxPrepareRequest req, GridDhtTxPrepareResponse res, GridDhtTxRemote dhtTx, GridNearTxRemote nearTx) {
        block7: {
            try {
                this.ctx.io().send(nodeId, (GridCacheMessage)res, req.policy());
                if (this.txPrepareMsgLog.isDebugEnabled()) {
                    this.txPrepareMsgLog.debug("Sent dht prepare response [txId=" + req.nearXidVersion() + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
                }
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    if (this.txPrepareMsgLog.isDebugEnabled()) {
                        this.txPrepareMsgLog.debug("Failed to send dht prepare response, node left [txId=" + req.nearXidVersion() + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
                    }
                } else {
                    U.warn(this.log, "Failed to send tx response to remote node (will rollback transaction) [txId=" + req.nearXidVersion() + ", dhtTxId=" + req.version() + ", node=" + nodeId + ", err=" + e.getMessage() + ']');
                }
                if (nearTx != null) {
                    nearTx.rollback();
                }
                if (dhtTx == null) break block7;
                dhtTx.rollback();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendReply(UUID nodeId, GridDhtTxFinishRequest req, boolean committed, GridCacheVersion nearTxId) {
        if (req.replyRequired() || req.checkCommitted()) {
            GridDhtTxFinishResponse res = new GridDhtTxFinishResponse(req.version(), req.futureId(), req.miniId());
            if (req.checkCommitted()) {
                res.checkCommitted(true);
                if (committed) {
                    if (req.needReturnValue()) {
                        try {
                            GridCacheReturnCompletableWrapper wrapper = this.ctx.tm().getCommittedTxReturn(req.version());
                            if (wrapper != null) {
                                res.returnValue(wrapper.fut().get());
                            } else assert (!this.ctx.discovery().alive(nodeId)) : nodeId;
                        }
                        catch (IgniteCheckedException ignored) {
                            if (this.txFinishMsgLog.isDebugEnabled()) {
                                this.txFinishMsgLog.debug("Failed to gain entry processor return value. [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
                            }
                        }
                    }
                } else {
                    ClusterTopologyCheckedException cause = new ClusterTopologyCheckedException("Primary node left grid.");
                    res.checkCommittedError(new IgniteTxRollbackCheckedException("Failed to commit transaction (transaction has been rolled back on backup node): " + req.version(), cause));
                }
            }
            try {
                this.ctx.io().send(nodeId, (GridCacheMessage)res, req.policy());
                if (!this.txFinishMsgLog.isDebugEnabled()) return;
                this.txFinishMsgLog.debug("Sent dht tx finish response [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", node=" + nodeId + ", checkCommitted=" + req.checkCommitted() + ']');
                return;
            }
            catch (Throwable e) {
                if (this.ctx.discovery().node(nodeId) == null) {
                    if (this.txFinishMsgLog.isDebugEnabled()) {
                        this.txFinishMsgLog.debug("Node left while send dht tx finish response [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
                    }
                } else {
                    U.error(this.log, "Failed to send finish response to node [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", nodeId=" + nodeId + ", res=" + res + ']', e);
                }
                if (!(e instanceof Error)) return;
                throw (Error)e;
            }
        }
        if (!this.txFinishMsgLog.isDebugEnabled()) return;
        this.txFinishMsgLog.debug("Skip send dht tx finish response [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
    }

    @Nullable
    GridDhtTxRemote startRemoteTx(UUID nodeId, GridDhtTxPrepareRequest req, GridDhtTxPrepareResponse res) throws IgniteCheckedException {
        if (!F.isEmpty(req.writes())) {
            GridDhtTxRemote tx = (GridDhtTxRemote)this.ctx.tm().tx(req.version());
            if (tx == null) {
                boolean single = req.last() && req.writes().size() == 1;
                tx = new GridDhtTxRemote(this.ctx, req.nearNodeId(), req.futureId(), nodeId, req.topologyVersion(), req.version(), null, req.system(), req.policy(), req.concurrency(), req.isolation(), req.isInvalidate(), req.timeout(), req.writes() != null ? Math.max(req.writes().size(), req.txSize()) : req.txSize(), req.nearXidVersion(), req.transactionNodes(), req.subjectId(), req.taskNameHash(), single);
                tx.writeVersion(req.writeVersion());
                tx = this.ctx.tm().onCreated(null, tx);
                if (tx == null || !this.ctx.tm().onStarted(tx)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Attempt to start a completed transaction (will ignore): " + tx);
                    }
                    return null;
                }
                if (this.ctx.discovery().node(nodeId) == null) {
                    tx.state(TransactionState.ROLLING_BACK);
                    tx.state(TransactionState.ROLLED_BACK);
                    this.ctx.tm().uncommitTx(tx);
                    return null;
                }
            } else {
                tx.writeVersion(req.writeVersion());
                tx.transactionNodes(req.transactionNodes());
            }
            if (!tx.isSystemInvalidate()) {
                int idx = 0;
                for (IgniteTxEntry entry : req.writes()) {
                    block24: {
                        GridCacheContext<?, ?> cacheCtx = entry.context();
                        tx.addWrite(entry, this.ctx.deploy().globalLoader());
                        if (GridCacheUtils.isNearEnabled(cacheCtx) && req.invalidateNearEntry(idx)) {
                            this.invalidateNearEntry(cacheCtx, entry.key(), req.version());
                        }
                        try {
                            GridCacheEntryEx cached;
                            if (req.needPreloadKey(idx)) {
                                GridCacheEntryInfo info;
                                cached = entry.cached();
                                if (cached == null) {
                                    cached = cacheCtx.cache().entryEx(entry.key(), req.topologyVersion());
                                }
                                if ((info = cached.info()) != null && !info.isNew() && !info.isDeleted()) {
                                    res.addPreloadEntry(info);
                                }
                            }
                            if (!cacheCtx.readThroughConfigured() || entry.skipStore() || entry.op() != GridCacheOperation.TRANSFORM || !entry.oldValueOnPrimary() || entry.hasValue()) break block24;
                            while (true) {
                                try {
                                    CacheObject val;
                                    cached = entry.cached();
                                    if (cached == null) {
                                        cached = cacheCtx.cache().entryEx(entry.key(), req.topologyVersion());
                                    }
                                    if ((val = cached.innerGet(null, tx, true, false, false, false, false, tx.subjectId(), null, tx.resolveTaskName(), null, true)) == null) {
                                        val = cacheCtx.toCacheObject(cacheCtx.store().load(null, entry.key()));
                                    }
                                    if (val != null) {
                                        entry.readValue(val);
                                    }
                                }
                                catch (GridCacheEntryRemovedException ignored) {
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug("Got entry removed exception, will retry: " + entry.txKey());
                                    }
                                    entry.cached(cacheCtx.cache().entryEx(entry.key(), req.topologyVersion()));
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (GridDhtInvalidPartitionException e) {
                            tx.addInvalidPartition((GridCacheContext)cacheCtx, e.partition());
                            tx.clearEntry(entry.txKey());
                        }
                    }
                    ++idx;
                }
            }
            tx.prepare();
            if (req.last()) {
                assert (!F.isEmpty(req.transactionNodes())) : "Received last prepare request with empty transaction nodes: " + req;
                tx.transactionNodes(req.transactionNodes());
                tx.state(TransactionState.PREPARED);
            }
            res.invalidPartitionsByCacheId(tx.invalidPartitions());
            if (tx.empty() && req.last()) {
                tx.rollback();
                return null;
            }
            return tx;
        }
        return null;
    }

    private void invalidateNearEntry(GridCacheContext cacheCtx, KeyCacheObject key, GridCacheVersion ver) throws IgniteCheckedException {
        GridNearCacheAdapter near = cacheCtx.isNear() ? cacheCtx.near() : cacheCtx.dht().near();
        GridCacheEntryEx nearEntry = near.peekEx(key);
        if (nearEntry != null) {
            nearEntry.invalidate(null, ver);
        }
    }

    @Nullable
    public GridNearTxRemote startNearRemoteTx(ClassLoader ldr, UUID nodeId, GridDhtTxPrepareRequest req) throws IgniteCheckedException {
        if (!F.isEmpty(req.nearWrites())) {
            GridNearTxRemote tx = (GridNearTxRemote)this.ctx.tm().nearTx(req.version());
            if (tx == null) {
                tx = new GridNearTxRemote(this.ctx, req.topologyVersion(), ldr, nodeId, req.nearNodeId(), req.version(), null, req.system(), req.policy(), req.concurrency(), req.isolation(), req.isInvalidate(), req.timeout(), req.nearWrites(), req.txSize(), req.subjectId(), req.taskNameHash());
                tx.writeVersion(req.writeVersion());
                if (!(tx.empty() || (tx = this.ctx.tm().onCreated(null, tx)) != null && this.ctx.tm().onStarted(tx))) {
                    throw new IgniteTxRollbackCheckedException("Attempt to start a completed transaction: " + tx);
                }
            } else {
                tx.addEntries(ldr, req.nearWrites());
            }
            tx.ownedVersions(req.owned());
            tx.prepare();
            if (req.last()) {
                tx.state(TransactionState.PREPARED);
            }
            return tx;
        }
        return null;
    }

    protected void processCheckPreparedTxRequest(final UUID nodeId, final GridCacheTxRecoveryRequest req) {
        IgniteInternalFuture<Boolean> fut;
        if (this.txRecoveryMsgLog.isDebugEnabled()) {
            this.txRecoveryMsgLog.debug("Received tx recovery request [txId=" + req.nearXidVersion() + ", node=" + nodeId + ']');
        }
        IgniteInternalFuture<Boolean> igniteInternalFuture = fut = req.nearTxCheck() ? this.ctx.tm().txCommitted(req.nearXidVersion()) : this.ctx.tm().txsPreparedOrCommitted(req.nearXidVersion(), req.transactions());
        if (fut == null || fut.isDone()) {
            boolean prepared;
            try {
                prepared = fut == null ? true : fut.get();
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Check prepared transaction future failed [req=" + req + ']', e);
                prepared = false;
            }
            this.sendCheckPreparedResponse(nodeId, req, prepared);
        } else {
            fut.listen((IgniteInClosure<IgniteInternalFuture<Boolean>>)new CI1<IgniteInternalFuture<Boolean>>(){

                @Override
                public void apply(IgniteInternalFuture<Boolean> fut) {
                    boolean prepared;
                    try {
                        prepared = fut.get();
                    }
                    catch (IgniteCheckedException e) {
                        U.error(IgniteTxHandler.this.log, "Check prepared transaction future failed [req=" + req + ']', e);
                        prepared = false;
                    }
                    IgniteTxHandler.this.sendCheckPreparedResponse(nodeId, req, prepared);
                }
            });
        }
    }

    private void sendCheckPreparedResponse(UUID nodeId, GridCacheTxRecoveryRequest req, boolean prepared) {
        GridCacheTxRecoveryResponse res = new GridCacheTxRecoveryResponse(req.version(), req.futureId(), req.miniId(), prepared, req.deployInfo() != null);
        try {
            this.ctx.io().send(nodeId, (GridCacheMessage)res, req.system() ? (byte)5 : 2);
            if (this.txRecoveryMsgLog.isDebugEnabled()) {
                this.txRecoveryMsgLog.debug("Sent tx recovery response [txId=" + req.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ']');
            }
        }
        catch (ClusterTopologyCheckedException ignored) {
            if (this.txRecoveryMsgLog.isDebugEnabled()) {
                this.txRecoveryMsgLog.debug("Failed to send tx recovery response, node failed [, txId=" + req.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.txRecoveryMsgLog, "Failed to send tx recovery response [txId=" + req.nearXidVersion() + ", node=" + nodeId + ", req=" + req + ", res=" + res + ']', e);
        }
    }

    protected void processCheckPreparedTxResponse(UUID nodeId, GridCacheTxRecoveryResponse res) {
        GridCacheTxRecoveryFuture fut;
        if (this.txRecoveryMsgLog.isDebugEnabled()) {
            this.txRecoveryMsgLog.debug("Received tx recovery response [txId=" + res.version() + ", node=" + nodeId + ", res=" + res + ']');
        }
        if ((fut = (GridCacheTxRecoveryFuture)this.ctx.mvcc().future(res.futureId())) == null) {
            if (this.txRecoveryMsgLog.isDebugEnabled()) {
                this.txRecoveryMsgLog.debug("Failed to find future for tx recovery response [txId=" + res.version() + ", node=" + nodeId + ", res=" + res + ']');
            }
            return;
        }
        res.txState(fut.tx().txState());
        fut.onResult(nodeId, res);
    }
}

