/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class IgniteTxKey
implements Message {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private KeyCacheObject key;
    private int cacheId;

    public IgniteTxKey() {
    }

    public IgniteTxKey(KeyCacheObject key, int cacheId) {
        this.key = key;
        this.cacheId = cacheId;
    }

    public KeyCacheObject key() {
        return this.key;
    }

    public int cacheId() {
        return this.cacheId;
    }

    public void prepareMarshal(GridCacheContext ctx) throws IgniteCheckedException {
        this.key.prepareMarshal(ctx.cacheObjectContext());
    }

    public void finishUnmarshal(GridCacheContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        assert (this.key != null);
        this.key.finishUnmarshal(ctx.cacheObjectContext(), ldr);
    }

    @Override
    public void onAckReceived() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IgniteTxKey)) {
            return false;
        }
        IgniteTxKey that = (IgniteTxKey)o;
        return this.cacheId == that.cacheId && this.key.equals(that.key);
    }

    public int hashCode() {
        int res = this.key.hashCode();
        res = 31 * res + this.cacheId;
        return res;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeInt("cacheId", this.cacheId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeMessage("key", this.key)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.cacheId = reader.readInt("cacheId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.key = (KeyCacheObject)reader.readMessage("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(IgniteTxKey.class);
    }

    @Override
    public byte directType() {
        return 94;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    public String toString() {
        return S.toString(IgniteTxKey.class, this);
    }
}

