/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.cache.CacheException;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.EntryProcessorResourceInjectorProxy;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheFilterFailedException;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.colocated.GridDhtDetachedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrInfo;
import org.apache.ignite.internal.processors.cache.store.CacheStoreManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxImplicitSingleStateImpl;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalState;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxState;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxStateImpl;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.transactions.IgniteTxHeuristicCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.future.GridEmbeddedFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.GridInClosure3;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.C2;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionDeadlockException;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public abstract class IgniteTxLocalAdapter
extends IgniteTxAdapter
implements IgniteTxLocalEx {
    private static final long serialVersionUID = 0L;
    protected static final AtomicReferenceFieldUpdater<IgniteTxLocalAdapter, Throwable> COMMIT_ERR_UPD = AtomicReferenceFieldUpdater.newUpdater(IgniteTxLocalAdapter.class, Throwable.class, "commitErr");
    protected static final AtomicIntegerFieldUpdater<IgniteTxLocalAdapter> DONE_FLAG_UPD = AtomicIntegerFieldUpdater.newUpdater(IgniteTxLocalAdapter.class, "doneFlag");
    protected GridCacheVersion minVer;
    protected volatile int doneFlag;
    private Collection<GridCacheVersion> committedVers = Collections.emptyList();
    private Collection<GridCacheVersion> rolledbackVers = Collections.emptyList();
    private GridCacheVersion completedBase;
    private boolean sndTransformedVals;
    protected volatile Throwable commitErr;
    protected GridCacheReturn implicitRes;
    private boolean depEnabled;
    @GridToStringInclude
    protected IgniteTxLocalState txState;

    protected IgniteTxLocalAdapter() {
    }

    protected IgniteTxLocalAdapter(GridCacheSharedContext cctx, GridCacheVersion xidVer, boolean implicit, boolean implicitSingle, boolean sys, byte plc, TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout, boolean invalidate, boolean storeEnabled, boolean onePhaseCommit, int txSize, @Nullable UUID subjId, int taskNameHash) {
        super(cctx, xidVer, implicit, true, sys, plc, concurrency, isolation, timeout, invalidate, storeEnabled, onePhaseCommit, txSize, subjId, taskNameHash);
        this.minVer = xidVer;
        this.txState = implicitSingle ? new IgniteTxImplicitSingleStateImpl() : new IgniteTxStateImpl();
    }

    @Override
    public IgniteTxState txState() {
        return this.txState;
    }

    protected void initResult() {
        this.implicitRes = new GridCacheReturn(this.localResult(), false);
    }

    @Override
    public UUID eventNodeId() {
        return this.cctx.localNodeId();
    }

    @Override
    public UUID originatingNodeId() {
        return this.cctx.localNodeId();
    }

    @Override
    public boolean empty() {
        return this.txState.empty();
    }

    @Override
    public Collection<UUID> masterNodeIds() {
        return Collections.singleton(this.nodeId);
    }

    @Override
    public Throwable commitError() {
        return this.commitErr;
    }

    @Override
    public void commitError(Throwable e) {
        COMMIT_ERR_UPD.compareAndSet(this, null, e);
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        assert (false);
        return false;
    }

    @Override
    public boolean activeCachesDeploymentEnabled() {
        return this.depEnabled;
    }

    public void activeCachesDeploymentEnabled(boolean depEnabled) {
        this.depEnabled = depEnabled;
    }

    @Override
    public boolean isStarted() {
        return this.txState.initialized();
    }

    @Override
    public boolean hasWriteKey(IgniteTxKey key) {
        return this.txState.hasWriteKey(key);
    }

    @Override
    public Set<IgniteTxKey> readSet() {
        return this.txState.readSet();
    }

    @Override
    public Set<IgniteTxKey> writeSet() {
        return this.txState.writeSet();
    }

    @Override
    public Map<IgniteTxKey, IgniteTxEntry> readMap() {
        return this.txState.readMap();
    }

    @Override
    public Map<IgniteTxKey, IgniteTxEntry> writeMap() {
        return this.txState.writeMap();
    }

    @Override
    public Collection<IgniteTxEntry> allEntries() {
        return this.txState.allEntries();
    }

    @Override
    public Collection<IgniteTxEntry> readEntries() {
        return this.txState.readEntries();
    }

    @Override
    public Collection<IgniteTxEntry> writeEntries() {
        return this.txState.writeEntries();
    }

    @Override
    @Nullable
    public IgniteTxEntry entry(IgniteTxKey key) {
        return this.txState.entry(key);
    }

    @Override
    public void seal() {
        this.txState.seal();
    }

    public void implicitSingleResult(GridCacheReturn ret) {
        if (ret.invokeResult()) {
            this.implicitRes.mergeEntryProcessResults(ret);
        } else {
            this.implicitRes = ret;
        }
    }

    public boolean hasInterceptor() {
        return this.txState().hasInterceptor(this.cctx);
    }

    public void sendTransformedValues(boolean snd) {
        this.sndTransformedVals = snd;
    }

    protected boolean commitAfterLock() {
        return this.implicit() && (!this.dht() || this.colocated());
    }

    @Override
    @Nullable
    public GridTuple<CacheObject> peek(GridCacheContext cacheCtx, boolean failFast, KeyCacheObject key) throws GridCacheFilterFailedException {
        IgniteTxEntry e = this.entry(cacheCtx.txKey(key));
        if (e != null) {
            return e.hasPreviousValue() ? F.t(e.previousValue()) : null;
        }
        return null;
    }

    @Override
    public IgniteInternalFuture<Void> loadMissing(final GridCacheContext cacheCtx, final AffinityTopologyVersion topVer, boolean readThrough, boolean async, Collection<KeyCacheObject> keys, boolean skipVals, boolean needVer, boolean keepBinary, ExpiryPolicy expiryPlc, final GridInClosure3<KeyCacheObject, Object, GridCacheVersion> c) {
        assert (cacheCtx.isLocal()) : cacheCtx.name();
        if (!readThrough || !cacheCtx.readThrough()) {
            for (KeyCacheObject key : keys) {
                c.apply(key, null, IgniteTxEntry.SER_READ_EMPTY_ENTRY_VER);
            }
            return new GridFinishedFuture<Void>();
        }
        try {
            IgniteCacheExpiryPolicy expiryPlc0 = this.optimistic() ? this.accessPolicy(cacheCtx, keys) : cacheCtx.cache().expiryPolicy(expiryPlc);
            LinkedHashMap<KeyCacheObject, GridCacheVersion> misses = null;
            block5: for (KeyCacheObject key : keys) {
                while (true) {
                    IgniteTxEntry txEntry;
                    GridCacheEntryEx entry;
                    GridCacheEntryEx gridCacheEntryEx = entry = (txEntry = this.entry(cacheCtx.txKey(key))) == null ? cacheCtx.cache().entryEx(key) : txEntry.cached();
                    if (entry == null) continue;
                    try {
                        EntryGetResult res = entry.innerGetVersioned(null, this, true, true, !skipVals, !skipVals, CU.subjectId(this, this.cctx), null, this.resolveTaskName(), expiryPlc0, txEntry == null ? keepBinary : txEntry.keepBinary(), null);
                        if (res == null) {
                            if (misses == null) {
                                misses = new LinkedHashMap<KeyCacheObject, GridCacheVersion>();
                            }
                            misses.put(key, entry.version());
                            continue block5;
                        }
                        c.apply(key, skipVals ? Boolean.valueOf(true) : res.value(), res.version());
                        continue block5;
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        if (log.isDebugEnabled()) {
                            log.debug("Got removed entry, will retry: " + key);
                        }
                        if (txEntry == null) continue;
                        txEntry.cached(cacheCtx.cache().entryEx(key, this.topologyVersion()));
                        continue;
                    }
                    break;
                }
            }
            if (misses != null) {
                final LinkedHashMap<KeyCacheObject, GridCacheVersion> misses0 = misses;
                cacheCtx.store().loadAll(this, misses.keySet(), (IgniteBiInClosure<KeyCacheObject, Object>)new CI2<KeyCacheObject, Object>(){

                    @Override
                    public void apply(KeyCacheObject key, Object val) {
                        GridCacheVersion ver;
                        block7: {
                            ver = (GridCacheVersion)misses0.remove(key);
                            assert (ver != null) : key;
                            if (val != null) {
                                CacheObject cacheVal = cacheCtx.toCacheObject(val);
                                while (true) {
                                    GridCacheEntryEx entry = cacheCtx.cache().entryEx(key, topVer);
                                    try {
                                        EntryGetResult verVal = entry.versionedValue(cacheVal, ver, null, null, null);
                                        if (IgniteTxAdapter.log.isDebugEnabled()) {
                                            IgniteTxAdapter.log.debug("Set value loaded from store into entry [oldVer=" + ver + ", newVer=" + verVal.version() + ", entry=" + entry + ']');
                                        }
                                        ver = verVal.version();
                                        break block7;
                                    }
                                    catch (GridCacheEntryRemovedException ignore) {
                                        if (!IgniteTxAdapter.log.isDebugEnabled()) continue;
                                        IgniteTxAdapter.log.debug("Got removed entry, (will retry): " + entry);
                                        continue;
                                    }
                                    catch (IgniteCheckedException e) {
                                        throw new GridClosureException(e);
                                    }
                                    break;
                                }
                            }
                            ver = IgniteTxEntry.SER_READ_EMPTY_ENTRY_VER;
                        }
                        c.apply(key, val, ver);
                    }
                });
                for (KeyCacheObject key : misses0.keySet()) {
                    c.apply(key, null, IgniteTxEntry.SER_READ_EMPTY_ENTRY_VER);
                }
            }
            return new GridFinishedFuture<Void>();
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<Void>(e);
        }
    }

    @Override
    public GridCacheVersion minVersion() {
        return this.minVer;
    }

    public void userPrepare() throws IgniteCheckedException {
        if (this.state() != TransactionState.PREPARING) {
            if (this.remainingTime() == -1L) {
                throw new IgniteTxTimeoutCheckedException("Transaction timed out: " + this);
            }
            TransactionState state = this.state();
            this.setRollbackOnly();
            throw new IgniteCheckedException("Invalid transaction state for prepare [state=" + (Object)((Object)state) + ", tx=" + this + ']');
        }
        this.checkValid();
        try {
            this.cctx.tm().prepareTx(this);
        }
        catch (IgniteCheckedException e) {
            throw e;
        }
        catch (Throwable e) {
            this.setRollbackOnly();
            if (e instanceof Error) {
                throw e;
            }
            throw new IgniteCheckedException("Transaction validation produced a runtime exception: " + this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws IgniteCheckedException {
        try {
            this.commitAsync().get();
        }
        finally {
            this.cctx.tm().resetContext();
        }
    }

    @Override
    public void prepare() throws IgniteCheckedException {
        this.prepareAsync().get();
    }

    private void checkCommitLocks(GridCacheEntryEx entry) {
        assert (this.ownsLockUnsafe(entry)) : "Lock is not owned for commit [entry=" + entry + ", tx=" + this + ']';
    }

    protected GridCacheEntryEx entryEx(GridCacheContext cacheCtx, IgniteTxKey key) {
        return cacheCtx.cache().entryEx(key.key());
    }

    protected GridCacheEntryEx entryEx(GridCacheContext cacheCtx, IgniteTxKey key, AffinityTopologyVersion topVer) {
        return cacheCtx.cache().entryEx(key.key(), topVer);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void userCommit() throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void tmFinish(boolean commit) throws IgniteCheckedException {
        assert (this.onePhaseCommit());
        if (DONE_FLAG_UPD.compareAndSet(this, 0, 1)) {
            if (commit) {
                this.cctx.tm().commitTx(this);
            } else {
                this.cctx.tm().rollbackTx(this);
            }
            this.state(commit ? TransactionState.COMMITTED : TransactionState.ROLLED_BACK);
            if (commit) {
                boolean needsCompletedVersions = this.needsCompletedVersions();
                assert (!needsCompletedVersions || this.completedBase != null) : "Missing completed base for transaction: " + this;
                assert (!needsCompletedVersions || this.committedVers != null) : "Missing committed versions for transaction: " + this;
                assert (!needsCompletedVersions || this.rolledbackVers != null) : "Missing rolledback versions for transaction: " + this;
            }
        }
    }

    @Override
    public void completedVersions(GridCacheVersion completedBase, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers) {
        this.completedBase = completedBase;
        this.committedVers = committedVers;
        this.rolledbackVers = rolledbackVers;
    }

    public GridCacheVersion completedBase() {
        return this.completedBase;
    }

    public Collection<GridCacheVersion> committedVersions() {
        return this.committedVers;
    }

    public Collection<GridCacheVersion> rolledbackVersions() {
        return this.rolledbackVers;
    }

    @Override
    public void userRollback() throws IgniteCheckedException {
        TransactionState state = this.state();
        if (state != TransactionState.ROLLING_BACK && state != TransactionState.ROLLED_BACK) {
            this.setRollbackOnly();
            throw new IgniteCheckedException("Invalid transaction state for rollback [state=" + (Object)((Object)state) + ", tx=" + this + ']');
        }
        if (this.near()) {
            for (IgniteTxEntry e : this.allEntries()) {
                this.evictNearEntry(e, false);
            }
        }
        if (DONE_FLAG_UPD.compareAndSet(this, 0, 1)) {
            Collection<CacheStoreManager> stores;
            this.cctx.tm().rollbackTx(this);
            if (!this.internal() && (stores = this.txState.stores(this.cctx)) != null && !stores.isEmpty()) {
                assert (this.isWriteToStoreFromDhtValid(stores)) : "isWriteToStoreFromDht can't be different within one transaction";
                boolean isWriteToStoreFromDht = F.first(stores).isWriteToStoreFromDht();
                if (!stores.isEmpty() && (this.near() || isWriteToStoreFromDht)) {
                    this.sessionEnd(stores, false);
                }
            }
        }
    }

    private boolean primaryLocal(GridCacheEntryEx entry) {
        return entry.context().affinity().primaryByPartition(this.cctx.localNode(), entry.partition(), AffinityTopologyVersion.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> Collection<KeyCacheObject> enlistRead(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, Collection<KeyCacheObject> keys, @Nullable ExpiryPolicy expiryPlc, Map<K, V> map, Map<KeyCacheObject, GridCacheVersion> missed, int keysCnt, boolean deserializeBinary, boolean skipVals, boolean keepCacheObjects, boolean skipStore, boolean needVer) throws IgniteCheckedException {
        assert (!F.isEmpty(keys));
        assert (keysCnt == keys.size());
        cacheCtx.checkSecurity(SecurityPermission.CACHE_READ);
        boolean single = keysCnt == 1;
        Collection<KeyCacheObject> lockKeys = null;
        AffinityTopologyVersion topVer = entryTopVer != null ? entryTopVer : this.topologyVersion();
        boolean needReadVer = this.serializable() && this.optimistic() || needVer;
        block9: for (KeyCacheObject key : keys) {
            GridCacheVersion ver;
            IgniteTxKey txKey;
            IgniteTxEntry txEntry;
            if ((this.pessimistic() || needReadVer) && !this.readCommitted() && !skipVals) {
                this.addActiveCache(cacheCtx);
            }
            if ((txEntry = this.entry(txKey = cacheCtx.txKey(key))) != null) {
                CacheObject val = txEntry.value();
                if (txEntry.hasValue()) {
                    if (!F.isEmpty(txEntry.entryProcessors())) {
                        val = txEntry.applyEntryProcessors(val);
                    }
                    if (val == null) continue;
                    ver = null;
                    if (needVer) {
                        if (txEntry.op() != GridCacheOperation.READ) {
                            ver = IgniteTxEntry.GET_ENTRY_INVALID_VER_UPDATED;
                        } else {
                            ver = txEntry.entryReadVersion();
                            if (ver == null && this.pessimistic()) {
                                while (true) {
                                    try {
                                        GridCacheEntryEx cached = txEntry.cached();
                                        ver = cached.isNear() ? ((GridNearCacheEntry)cached).dhtVersion() : cached.version();
                                    }
                                    catch (GridCacheEntryRemovedException ignored) {
                                        txEntry.cached(this.entryEx(cacheCtx, txEntry.txKey(), topVer));
                                        continue;
                                    }
                                    break;
                                }
                            }
                            if (ver == null) {
                                assert (this.optimistic() && this.repeatableRead()) : this;
                                ver = IgniteTxEntry.GET_ENTRY_INVALID_VER_AFTER_GET;
                            }
                        }
                        assert (ver != null);
                    }
                    cacheCtx.addResult(map, key, val, skipVals, keepCacheObjects, deserializeBinary, false, ver, 0L, 0L);
                    continue;
                }
                assert (txEntry.op() == GridCacheOperation.TRANSFORM);
                while (true) {
                    try {
                        T2<EntryProcessor<Object, Object, Object>, Object[]> transformClo;
                        GridCacheVersion readVer = null;
                        EntryGetResult getRes = null;
                        T2<EntryProcessor<Object, Object, Object>, Object[]> t2 = transformClo = txEntry.op() == GridCacheOperation.TRANSFORM && this.cctx.gridEvents().isRecordable(64) ? F.first(txEntry.entryProcessors()) : null;
                        if (needVer) {
                            getRes = txEntry.cached().innerGetVersioned(null, this, true, true, true, !skipVals, CU.subjectId(this, this.cctx), transformClo, this.resolveTaskName(), null, txEntry.keepBinary(), null);
                            if (getRes != null) {
                                val = (CacheObject)getRes.value();
                                readVer = getRes.version();
                            }
                        } else {
                            val = txEntry.cached().innerGet(null, this, true, false, true, !skipVals, false, CU.subjectId(this, this.cctx), transformClo, this.resolveTaskName(), null, txEntry.keepBinary());
                        }
                        if (val != null) {
                            if (!this.readCommitted() && !skipVals) {
                                txEntry.readValue(val);
                            }
                            if (!F.isEmpty(txEntry.entryProcessors())) {
                                val = txEntry.applyEntryProcessors(val);
                            }
                            cacheCtx.addResult(map, key, val, skipVals, keepCacheObjects, deserializeBinary, false, getRes, readVer, 0L, 0L, needVer);
                            continue block9;
                        }
                        missed.put(key, txEntry.cached().version());
                        continue block9;
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        txEntry.cached(this.entryEx(cacheCtx, txEntry.txKey(), topVer));
                        continue;
                    }
                    break;
                }
            }
            if (lockKeys == null && !skipVals) {
                Collection<KeyCacheObject> collection = lockKeys = single ? Collections.singleton(key) : new ArrayList(keysCnt);
            }
            if (!single && !skipVals) {
                lockKeys.add(key);
            }
            while (true) {
                GridCacheEntryEx entry = this.entryEx(cacheCtx, txKey, topVer);
                try {
                    ver = entry.version();
                    CacheObject val = null;
                    GridCacheVersion readVer = null;
                    EntryGetResult getRes = null;
                    if (!this.pessimistic() || this.readCommitted() && !skipVals) {
                        IgniteCacheExpiryPolicy accessPlc;
                        IgniteCacheExpiryPolicy igniteCacheExpiryPolicy = accessPlc = this.optimistic() ? this.accessPolicy(cacheCtx, txKey, expiryPlc) : null;
                        if (needReadVer) {
                            EntryGetResult entryGetResult = this.primaryLocal(entry) ? entry.innerGetVersioned(null, this, true, true, true, true, CU.subjectId(this, this.cctx), null, this.resolveTaskName(), accessPlc, !deserializeBinary, null) : (getRes = null);
                            if (getRes != null) {
                                val = (CacheObject)getRes.value();
                                readVer = getRes.version();
                            }
                        } else {
                            val = entry.innerGet(null, this, true, false, true, true, false, CU.subjectId(this, this.cctx), null, this.resolveTaskName(), accessPlc, !deserializeBinary);
                        }
                        if (val != null) {
                            cacheCtx.addResult(map, key, val, skipVals, keepCacheObjects, deserializeBinary, false, getRes, readVer, 0L, 0L, needVer);
                        } else {
                            missed.put(key, ver);
                        }
                    } else {
                        missed.put(key, ver);
                    }
                    if (this.readCommitted() || skipVals) continue block9;
                    txEntry = this.addEntry(GridCacheOperation.READ, val, null, null, entry, expiryPlc, null, true, -1L, -1L, null, skipStore, !deserializeBinary);
                    if (val == null || this.pessimistic()) continue block9;
                    txEntry.markValid();
                    if (!needReadVer) continue block9;
                    assert (readVer != null);
                    txEntry.entryReadVersion(readVer);
                    continue block9;
                }
                catch (GridCacheEntryRemovedException ignored) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Got removed entry in transaction getAllAsync(..) (will retry): " + key);
                    continue;
                }
                finally {
                    if (entry == null || !this.readCommitted()) continue;
                    if (cacheCtx.isNear()) {
                        if (!cacheCtx.affinity().partitionBelongs(cacheCtx.localNode(), entry.partition(), topVer) || !entry.markObsolete(this.xidVer)) continue;
                        cacheCtx.cache().removeEntry(entry);
                        continue;
                    }
                    entry.context().evicts().touch(entry, topVer);
                    continue;
                }
                break;
            }
        }
        return lockKeys != null ? lockKeys : Collections.emptyList();
    }

    protected IgniteCacheExpiryPolicy accessPolicy(GridCacheContext ctx, IgniteTxKey key, @Nullable ExpiryPolicy expiryPlc) {
        return null;
    }

    protected IgniteCacheExpiryPolicy accessPolicy(GridCacheContext cacheCtx, Collection<KeyCacheObject> keys) {
        return null;
    }

    private <K, V> IgniteInternalFuture<Map<K, V>> checkMissed(final GridCacheContext cacheCtx, final AffinityTopologyVersion topVer, final Map<K, V> map, Map<KeyCacheObject, GridCacheVersion> missedMap, final boolean deserializeBinary, final boolean skipVals, final boolean keepCacheObjects, boolean skipStore, final boolean needVer, ExpiryPolicy expiryPlc) {
        if (log.isDebugEnabled()) {
            log.debug("Loading missed values for missed map: " + missedMap);
        }
        final boolean needReadVer = this.serializable() && this.optimistic() || needVer;
        return new GridEmbeddedFuture(new C2<Void, Exception, Map<K, V>>(){

            @Override
            public Map<K, V> apply(Void v, Exception e) {
                if (e != null) {
                    IgniteTxLocalAdapter.this.setRollbackOnly();
                    throw new GridClosureException(e);
                }
                return map;
            }
        }, this.loadMissing(cacheCtx, topVer, !skipStore, false, missedMap.keySet(), skipVals, needReadVer, !deserializeBinary, expiryPlc, new GridInClosure3<KeyCacheObject, Object, GridCacheVersion>(){

            @Override
            public void apply(KeyCacheObject key, Object val, GridCacheVersion loadVer) {
                GridCacheEntryEx e;
                CacheObject cacheVal;
                if (IgniteTxLocalAdapter.this.isRollbackOnly()) {
                    if (IgniteTxAdapter.log.isDebugEnabled()) {
                        IgniteTxAdapter.log.debug("Ignoring loaded value for read because transaction was rolled back: " + IgniteTxLocalAdapter.this);
                    }
                    return;
                }
                CacheObject visibleVal = cacheVal = cacheCtx.toCacheObject(val);
                IgniteTxKey txKey = cacheCtx.txKey(key);
                IgniteTxEntry txEntry = IgniteTxLocalAdapter.this.entry(txKey);
                if (txEntry != null) {
                    if (!IgniteTxLocalAdapter.this.readCommitted()) {
                        txEntry.readValue(cacheVal);
                    }
                    if (!F.isEmpty(txEntry.entryProcessors())) {
                        visibleVal = txEntry.applyEntryProcessors(visibleVal);
                    }
                }
                assert (txEntry != null || IgniteTxLocalAdapter.this.readCommitted() || skipVals);
                GridCacheEntryEx gridCacheEntryEx = e = txEntry == null ? IgniteTxLocalAdapter.this.entryEx(cacheCtx, txKey, topVer) : txEntry.cached();
                if (IgniteTxLocalAdapter.this.readCommitted() || skipVals) {
                    cacheCtx.evicts().touch(e, IgniteTxLocalAdapter.this.topologyVersion());
                    if (visibleVal != null) {
                        cacheCtx.addResult(map, key, visibleVal, skipVals, keepCacheObjects, deserializeBinary, false, needVer ? loadVer : null, 0L, 0L);
                    }
                } else {
                    assert (txEntry != null);
                    txEntry.setAndMarkValid(cacheVal);
                    if (needReadVer) {
                        assert (loadVer != null);
                        txEntry.entryReadVersion(loadVer);
                    }
                    if (visibleVal != null) {
                        cacheCtx.addResult(map, key, visibleVal, skipVals, keepCacheObjects, deserializeBinary, false, needVer ? loadVer : null, 0L, 0L);
                    }
                }
            }
        }));
    }

    @Override
    public <K, V> IgniteInternalFuture<Map<K, V>> getAllAsync(final GridCacheContext cacheCtx, final @Nullable AffinityTopologyVersion entryTopVer, Collection<KeyCacheObject> keys, final boolean deserializeBinary, final boolean skipVals, final boolean keepCacheObjects, final boolean skipStore, final boolean needVer) {
        if (F.isEmpty(keys)) {
            return new GridFinishedFuture(Collections.emptyMap());
        }
        this.init();
        int keysCnt = keys.size();
        boolean single = keysCnt == 1;
        try {
            this.checkValid();
            final GridLeanMap retMap = new GridLeanMap(keysCnt);
            final GridLeanMap<KeyCacheObject, GridCacheVersion> missed = new GridLeanMap<KeyCacheObject, GridCacheVersion>(this.pessimistic() ? keysCnt : 0);
            CacheOperationContext opCtx = cacheCtx.operationContextPerCall();
            ExpiryPolicy expiryPlc = opCtx != null ? opCtx.expiry() : null;
            final Collection<KeyCacheObject> lockKeys = this.enlistRead(cacheCtx, entryTopVer, keys, expiryPlc, retMap, missed, keysCnt, deserializeBinary, skipVals, keepCacheObjects, skipStore, needVer);
            if (single && missed.isEmpty()) {
                return new GridFinishedFuture<Map<K, V>>(retMap);
            }
            if (this.pessimistic() && !this.readCommitted() && !skipVals) {
                if (expiryPlc == null) {
                    expiryPlc = cacheCtx.expiry();
                }
                long accessTtl = expiryPlc != null ? CU.toTtl(expiryPlc.getExpiryForAccess()) : -1L;
                long createTtl = expiryPlc != null ? CU.toTtl(expiryPlc.getExpiryForCreation()) : -1L;
                long timeout = this.remainingTime();
                if (timeout == -1L) {
                    return new GridFinishedFuture<Map<K, V>>(this.timeoutException());
                }
                IgniteInternalFuture<Boolean> fut = cacheCtx.cache().txLockAsync(lockKeys, timeout, this, true, true, this.isolation, this.isInvalidate(), createTtl, accessTtl);
                final ExpiryPolicy expiryPlc0 = expiryPlc;
                PLC2 plc2 = new PLC2<Map<K, V>>(){

                    @Override
                    public IgniteInternalFuture<Map<K, V>> postLock() throws IgniteCheckedException {
                        if (IgniteTxAdapter.log.isDebugEnabled()) {
                            IgniteTxAdapter.log.debug("Acquired transaction lock for read on keys: " + lockKeys);
                        }
                        block2: for (KeyCacheObject cacheKey : lockKeys) {
                            KeyCacheObject keyVal;
                            KeyCacheObject keyCacheObject = keepCacheObjects ? cacheKey : (keyVal = cacheCtx.cacheObjectContext().unwrapBinaryIfNeeded(cacheKey, !deserializeBinary));
                            if (retMap.containsKey(keyVal)) continue;
                            IgniteTxKey txKey = cacheCtx.txKey(cacheKey);
                            IgniteTxEntry txEntry = IgniteTxLocalAdapter.this.entry(txKey);
                            assert (txEntry != null);
                            while (true) {
                                GridCacheEntryEx cached = txEntry.cached();
                                CacheObject val = null;
                                GridCacheVersion readVer = null;
                                EntryGetResult getRes = null;
                                try {
                                    T2<EntryProcessor<Object, Object, Object>, Object[]> transformClo;
                                    T2<EntryProcessor<Object, Object, Object>, Object[]> t2 = transformClo = !F.isEmpty(txEntry.entryProcessors()) && IgniteTxLocalAdapter.this.cctx.gridEvents().isRecordable(64) ? F.first(txEntry.entryProcessors()) : null;
                                    if (needVer) {
                                        getRes = cached.innerGetVersioned(null, IgniteTxLocalAdapter.this, cacheCtx.isSwapOrOffheapEnabled(), true, true, !skipVals, CU.subjectId(IgniteTxLocalAdapter.this, IgniteTxLocalAdapter.this.cctx), transformClo, IgniteTxLocalAdapter.this.resolveTaskName(), null, txEntry.keepBinary(), null);
                                        if (getRes != null) {
                                            val = (CacheObject)getRes.value();
                                            readVer = getRes.version();
                                        }
                                    } else {
                                        val = cached.innerGet(null, IgniteTxLocalAdapter.this, cacheCtx.isSwapOrOffheapEnabled(), false, true, !skipVals, false, CU.subjectId(IgniteTxLocalAdapter.this, IgniteTxLocalAdapter.this.cctx), transformClo, IgniteTxLocalAdapter.this.resolveTaskName(), null, txEntry.keepBinary());
                                    }
                                    if (val == null) continue block2;
                                    missed.remove(cacheKey);
                                    txEntry.setAndMarkValid(val);
                                    if (!F.isEmpty(txEntry.entryProcessors())) {
                                        val = txEntry.applyEntryProcessors(val);
                                    }
                                    cacheCtx.addResult(retMap, cacheKey, val, skipVals, keepCacheObjects, deserializeBinary, false, getRes, readVer, 0L, 0L, needVer);
                                    if (readVer == null) continue block2;
                                    txEntry.entryReadVersion(readVer);
                                    continue block2;
                                }
                                catch (GridCacheEntryRemovedException ignore) {
                                    if (IgniteTxAdapter.log.isDebugEnabled()) {
                                        IgniteTxAdapter.log.debug("Got removed exception in get postLock (will retry): " + cached);
                                    }
                                    txEntry.cached(IgniteTxLocalAdapter.this.entryEx(cacheCtx, txKey, IgniteTxLocalAdapter.this.topologyVersion()));
                                    continue;
                                }
                                break;
                            }
                        }
                        if (!missed.isEmpty() && cacheCtx.isLocal()) {
                            AffinityTopologyVersion topVer = IgniteTxLocalAdapter.this.topologyVersionSnapshot();
                            if (topVer == null) {
                                topVer = entryTopVer;
                            }
                            return IgniteTxLocalAdapter.this.checkMissed(cacheCtx, topVer != null ? topVer : IgniteTxLocalAdapter.this.topologyVersion(), retMap, missed, deserializeBinary, skipVals, keepCacheObjects, skipStore, needVer, expiryPlc0);
                        }
                        return new GridFinishedFuture(Collections.emptyMap());
                    }
                };
                FinishClosure finClos = new FinishClosure<Map<K, V>>(){

                    @Override
                    Map<K, V> finish(Map<K, V> loaded) {
                        retMap.putAll(loaded);
                        return retMap;
                    }
                };
                if (fut.isDone()) {
                    try {
                        IgniteInternalFuture fut1 = plc2.apply(fut.get(), null);
                        return fut1.isDone() ? new GridFinishedFuture(finClos.apply(fut1.get(), null)) : new GridEmbeddedFuture(finClos, fut1);
                    }
                    catch (GridClosureException e) {
                        return new GridFinishedFuture<Map<K, V>>(e.unwrap());
                    }
                    catch (IgniteCheckedException e) {
                        try {
                            return plc2.apply(false, e);
                        }
                        catch (Exception e1) {
                            return new GridFinishedFuture<Map<K, V>>(e1);
                        }
                    }
                }
                return new GridEmbeddedFuture(fut, plc2, finClos);
            }
            assert (this.optimistic() || this.readCommitted() || skipVals);
            if (!missed.isEmpty()) {
                if (!this.readCommitted()) {
                    Iterator it = missed.keySet().iterator();
                    while (it.hasNext()) {
                        KeyCacheObject cacheKey = (KeyCacheObject)it.next();
                        KeyCacheObject keyVal = keepCacheObjects ? cacheKey : cacheKey.value(cacheCtx.cacheObjectContext(), false);
                        if (!retMap.containsKey(keyVal)) continue;
                        it.remove();
                    }
                }
                if (missed.isEmpty()) {
                    return new GridFinishedFuture<Map<K, V>>(retMap);
                }
                AffinityTopologyVersion topVer = this.topologyVersionSnapshot();
                if (topVer == null) {
                    topVer = entryTopVer;
                }
                return this.checkMissed(cacheCtx, topVer != null ? topVer : this.topologyVersion(), retMap, missed, deserializeBinary, skipVals, keepCacheObjects, skipStore, needVer, expiryPlc);
            }
            return new GridFinishedFuture<Map<K, V>>(retMap);
        }
        catch (IgniteCheckedException e) {
            this.setRollbackOnly();
            return new GridFinishedFuture<Map<K, V>>(e);
        }
    }

    @Override
    public <K, V> IgniteInternalFuture<GridCacheReturn> putAllAsync(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, Map<? extends K, ? extends V> map, boolean retval) {
        return this.putAllAsync0(cacheCtx, entryTopVer, map, null, null, null, retval);
    }

    @Override
    public <K, V> IgniteInternalFuture<GridCacheReturn> putAsync(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, K key, V val, boolean retval, CacheEntryPredicate filter) {
        return this.putAsync0(cacheCtx, entryTopVer, key, val, null, null, retval, filter);
    }

    @Override
    public <K, V> IgniteInternalFuture<GridCacheReturn> invokeAsync(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, K key, EntryProcessor<K, V, Object> entryProcessor, Object ... invokeArgs) {
        return this.putAsync0(cacheCtx, entryTopVer, key, null, entryProcessor, invokeArgs, true, null);
    }

    @Override
    public IgniteInternalFuture<?> putAllDrAsync(GridCacheContext cacheCtx, Map<KeyCacheObject, GridCacheDrInfo> drMap) {
        Map<KeyCacheObject, Object> map = F.viewReadOnly(drMap, new IgniteClosure<GridCacheDrInfo, Object>(){

            @Override
            public Object apply(GridCacheDrInfo val) {
                return val.value();
            }
        }, new IgnitePredicate[0]);
        return this.putAllAsync0(cacheCtx, null, map, null, null, drMap, false);
    }

    @Override
    public <K, V, T> IgniteInternalFuture<GridCacheReturn> invokeAsync(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, @Nullable Map<? extends K, ? extends EntryProcessor<K, V, Object>> map, Object ... invokeArgs) {
        return this.putAllAsync0(cacheCtx, entryTopVer, null, map, invokeArgs, null, true);
    }

    @Override
    public IgniteInternalFuture<?> removeAllDrAsync(GridCacheContext cacheCtx, Map<KeyCacheObject, GridCacheVersion> drMap) {
        return this.removeAllAsync0(cacheCtx, null, null, drMap, false, null, false);
    }

    private boolean filter(GridCacheContext cctx, KeyCacheObject key, CacheObject val, CacheEntryPredicate[] filter) {
        return this.pessimistic() || this.optimistic() && this.implicit() || this.isAll(cctx, key, val, filter);
    }

    private <K, V> IgniteInternalFuture<Void> enlistWrite(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, KeyCacheObject cacheKey, Object val, @Nullable ExpiryPolicy expiryPlc, @Nullable EntryProcessor<K, V, Object> entryProcessor, @Nullable Object[] invokeArgs, boolean retval, boolean lockOnly, CacheEntryPredicate[] filter, GridCacheReturn ret, boolean skipStore, boolean singleRmv, boolean keepBinary, Byte dataCenterId) {
        try {
            GridCacheVersion drVer;
            boolean loadMissed;
            boolean needReadVer;
            this.addActiveCache(cacheCtx);
            boolean hasFilters = !F.isEmptyOrNulls(filter) && !F.isAlwaysTrue(filter);
            boolean needVal = singleRmv || retval || hasFilters;
            boolean bl = needReadVer = needVal && this.serializable() && this.optimistic();
            if (entryProcessor != null) {
                this.transform = true;
            }
            if (loadMissed = this.enlistWriteEntry(cacheCtx, entryTopVer, cacheKey, val, entryProcessor, invokeArgs, expiryPlc, retval, lockOnly, filter, drVer = dataCenterId != null ? this.cctx.versions().next(dataCenterId) : null, -1L, -1L, ret, null, skipStore, singleRmv, hasFilters, needVal, needReadVer, keepBinary)) {
                AffinityTopologyVersion topVer = this.topologyVersionSnapshot();
                if (topVer == null) {
                    topVer = entryTopVer;
                }
                return this.loadMissing(cacheCtx, topVer != null ? topVer : this.topologyVersion(), Collections.singleton(cacheKey), filter, ret, needReadVer, singleRmv, hasFilters, (entryProcessor != null || cacheCtx.config().isLoadPreviousValue()) && !skipStore, retval, keepBinary, expiryPlc);
            }
            return new GridFinishedFuture<Void>();
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<Void>(e);
        }
    }

    private <K, V> IgniteInternalFuture<Void> enlistWrite(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, Collection<?> keys, @Nullable ExpiryPolicy expiryPlc, @Nullable Map<?, ?> lookup, @Nullable Map<?, EntryProcessor<K, V, Object>> invokeMap, @Nullable Object[] invokeArgs, boolean retval, boolean lockOnly, CacheEntryPredicate[] filter, GridCacheReturn ret, Collection<KeyCacheObject> enlisted, @Nullable Map<KeyCacheObject, GridCacheDrInfo> drPutMap, @Nullable Map<KeyCacheObject, GridCacheVersion> drRmvMap, boolean skipStore, boolean singleRmv, boolean keepBinary, Byte dataCenterId) {
        assert (retval || invokeMap == null);
        try {
            this.addActiveCache(cacheCtx);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<Void>(e);
        }
        boolean rmv = lookup == null && invokeMap == null;
        boolean hasFilters = !F.isEmptyOrNulls(filter) && !F.isAlwaysTrue(filter);
        boolean needVal = singleRmv || retval || hasFilters;
        boolean needReadVer = needVal && this.serializable() && this.optimistic();
        try {
            if (invokeMap != null) {
                this.transform = true;
            }
            HashSet<KeyCacheObject> missedForLoad = null;
            for (Object key : keys) {
                long drExpireTime;
                long drTtl;
                GridCacheVersion drVer;
                EntryProcessor<K, V, Object> entryProcessor;
                if (key == null) {
                    this.rollback();
                    throw new NullPointerException("Null key.");
                }
                Object val = rmv || lookup == null ? null : lookup.get(key);
                EntryProcessor<K, V, Object> entryProcessor2 = entryProcessor = invokeMap == null ? null : invokeMap.get(key);
                if (drPutMap != null) {
                    GridCacheDrInfo info = drPutMap.get(key);
                    assert (info != null);
                    drVer = info.version();
                    drTtl = info.ttl();
                    drExpireTime = info.expireTime();
                } else if (drRmvMap != null) {
                    assert (drRmvMap.get(key) != null);
                    drVer = drRmvMap.get(key);
                    drTtl = -1L;
                    drExpireTime = -1L;
                } else if (dataCenterId != null) {
                    drVer = this.cctx.versions().next(dataCenterId);
                    drTtl = -1L;
                    drExpireTime = -1L;
                } else {
                    drVer = null;
                    drTtl = -1L;
                    drExpireTime = -1L;
                }
                if (!rmv && val == null && entryProcessor == null) {
                    this.setRollbackOnly();
                    throw new NullPointerException("Null value.");
                }
                KeyCacheObject cacheKey = cacheCtx.toCacheKeyObject(key);
                boolean loadMissed = this.enlistWriteEntry(cacheCtx, entryTopVer, cacheKey, val, entryProcessor, invokeArgs, expiryPlc, retval, lockOnly, filter, drVer, drTtl, drExpireTime, ret, enlisted, skipStore, singleRmv, hasFilters, needVal, needReadVer, keepBinary);
                if (!loadMissed) continue;
                if (missedForLoad == null) {
                    missedForLoad = new HashSet<KeyCacheObject>();
                }
                missedForLoad.add(cacheKey);
            }
            if (missedForLoad != null) {
                AffinityTopologyVersion topVer = this.topologyVersionSnapshot();
                if (topVer == null) {
                    topVer = entryTopVer;
                }
                return this.loadMissing(cacheCtx, topVer != null ? topVer : this.topologyVersion(), missedForLoad, filter, ret, needReadVer, singleRmv, hasFilters, (invokeMap != null || cacheCtx.config().isLoadPreviousValue()) && !skipStore, retval, keepBinary, expiryPlc);
            }
            return new GridFinishedFuture<Void>();
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<Void>(e);
        }
    }

    private IgniteInternalFuture<Void> loadMissing(final GridCacheContext cacheCtx, AffinityTopologyVersion topVer, Set<KeyCacheObject> keys, final CacheEntryPredicate[] filter, final GridCacheReturn ret, final boolean needReadVer, final boolean singleRmv, final boolean hasFilters, boolean readThrough, final boolean retval, final boolean keepBinary, ExpiryPolicy expiryPlc) {
        GridInClosure3<KeyCacheObject, Object, GridCacheVersion> c = new GridInClosure3<KeyCacheObject, Object, GridCacheVersion>(){

            @Override
            public void apply(KeyCacheObject key, @Nullable Object val, @Nullable GridCacheVersion loadVer) {
                if (IgniteTxAdapter.log.isDebugEnabled()) {
                    IgniteTxAdapter.log.debug("Loaded value from remote node [key=" + key + ", val=" + val + ']');
                }
                IgniteTxEntry e = IgniteTxLocalAdapter.this.entry(new IgniteTxKey(key, cacheCtx.cacheId()));
                assert (e != null);
                if (needReadVer) {
                    assert (loadVer != null);
                    e.entryReadVersion(singleRmv && val != null ? IgniteTxEntry.SER_READ_NOT_EMPTY_VER : loadVer);
                }
                if (singleRmv) {
                    assert (!hasFilters && !retval);
                    assert (val == null || Boolean.TRUE.equals(val)) : val;
                    ret.set(cacheCtx, null, val != null, keepBinary);
                } else {
                    CacheObject cacheVal = cacheCtx.toCacheObject(val);
                    if (e.op() == GridCacheOperation.TRANSFORM) {
                        GridCacheVersion ver;
                        e.readValue(cacheVal);
                        try {
                            ver = e.cached().version();
                        }
                        catch (GridCacheEntryRemovedException ex) {
                            assert (IgniteTxLocalAdapter.this.optimistic()) : e;
                            if (IgniteTxAdapter.log.isDebugEnabled()) {
                                IgniteTxAdapter.log.debug("Failed to get entry version: [msg=" + ex.getMessage() + ']');
                            }
                            ver = null;
                        }
                        IgniteTxLocalAdapter.this.addInvokeResult(e, cacheVal, ret, ver);
                    } else {
                        boolean success;
                        if (hasFilters) {
                            success = IgniteTxLocalAdapter.this.isAll(e.context(), key, cacheVal, filter);
                            if (!success) {
                                e.value(cacheVal, false, false);
                            }
                        } else {
                            success = true;
                        }
                        ret.set(cacheCtx, cacheVal, success, keepBinary);
                    }
                }
            }
        };
        return this.loadMissing(cacheCtx, topVer, readThrough, true, keys, singleRmv, needReadVer, keepBinary, expiryPlc, c);
    }

    /*
     * Unable to fully structure code
     */
    private boolean enlistWriteEntry(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, KeyCacheObject cacheKey, @Nullable Object val, @Nullable EntryProcessor<?, ?, ?> entryProcessor, @Nullable Object[] invokeArgs, @Nullable ExpiryPolicy expiryPlc, boolean retval, boolean lockOnly, CacheEntryPredicate[] filter, GridCacheVersion drVer, long drTtl, long drExpireTime, GridCacheReturn ret, @Nullable Collection<KeyCacheObject> enlisted, boolean skipStore, boolean singleRmv, boolean hasFilters, boolean needVal, boolean needReadVer, boolean keepBinary) throws IgniteCheckedException {
        block47: {
            loadMissed = false;
            rmv = val == null && entryProcessor == null;
            txKey = cacheCtx.txKey(cacheKey);
            txEntry = this.entry(txKey);
            if (txEntry == null) {
                while (true) {
                    entry = this.entryEx(cacheCtx, txKey, entryTopVer != null ? entryTopVer : this.topologyVersion());
                    try {
                        entry.unswap(false);
                        if (!this.implicit && this.cctx.kernalContext().config().isCacheSanityCheckEnabled() && entry.lockedByThread(this.threadId, this.xidVer)) {
                            throw new IgniteCheckedException("Cannot access key within transaction if lock is externally held [key=" + CU.value(cacheKey, cacheCtx, false) + ", entry=" + entry + ", xidVer=" + this.xidVer + ", threadId=" + this.threadId + ", locNodeId=" + this.cctx.localNodeId() + ']');
                        }
                        old = null;
                        readVer = null;
                        if (this.optimistic() && !this.implicit()) {
                            try {
                                if (needReadVer) {
                                    v0 = this.primaryLocal(entry) != false ? entry.innerGetVersioned(null, this, false, retval != false || needVal != false, retval, retval, CU.subjectId(this, this.cctx), entryProcessor, this.resolveTaskName(), null, keepBinary, null) : (res = null);
                                    if (res == null) ** GOTO lbl29
                                    old = (CacheObject)res.value();
                                    readVer = res.version();
                                }
                                old = entry.innerGet(null, this, false, false, retval, retval, false, CU.subjectId(this, this.cctx), entryProcessor, this.resolveTaskName(), null, keepBinary);
                            }
                            catch (ClusterTopologyCheckedException e) {
                                entry.context().evicts().touch(entry, this.topologyVersion());
                                throw e;
                            }
                        } else {
                            v1 = old = retval != false ? entry.rawGetOrUnmarshal(false) : entry.rawGet();
                        }
lbl29:
                        // 4 sources

                        v2 = lockOnly != false ? GridCacheOperation.NOOP : (rmv != false ? GridCacheOperation.DELETE : (entryProcessor != null ? GridCacheOperation.TRANSFORM : (op = old != null ? GridCacheOperation.UPDATE : GridCacheOperation.CREATE)));
                        if (old != null && hasFilters && !this.filter(entry.context(), cacheKey, old, filter)) {
                            ret.set(cacheCtx, old, false, keepBinary);
                            if (!this.readCommitted()) {
                                txEntry = this.optimistic() != false && this.serializable() != false ? this.addEntry(op, old, entryProcessor, invokeArgs, entry, expiryPlc, filter, true, drTtl, drExpireTime, drVer, skipStore, keepBinary) : this.addEntry(GridCacheOperation.READ, old, null, null, entry, null, CU.empty0(), false, -1L, -1L, null, skipStore, keepBinary);
                                txEntry.markValid();
                                if (needReadVer) {
                                    if (!IgniteTxLocalAdapter.$assertionsDisabled && readVer == null) {
                                        throw new AssertionError();
                                    }
                                    txEntry.entryReadVersion(singleRmv != false ? IgniteTxEntry.SER_READ_NOT_EMPTY_VER : readVer);
                                }
                            }
                            if (this.readCommitted()) {
                                cacheCtx.evicts().touch(entry, this.topologyVersion());
                            }
                            break block47;
                        }
                        txEntry = this.addEntry(op, cacheCtx.toCacheObject(val), entryProcessor, invokeArgs, entry, expiryPlc, filter, true, drTtl, drExpireTime, drVer, skipStore, keepBinary);
                        if (!this.implicit() && this.readCommitted() && !cacheCtx.offheapTiered()) {
                            cacheCtx.evicts().touch(entry, this.topologyVersion());
                        }
                        if (enlisted != null) {
                            enlisted.add(cacheKey);
                        }
                        if (!this.pessimistic() && !this.implicit()) {
                            txEntry.markValid();
                            if (old == null) {
                                if (needVal) {
                                    loadMissed = true;
                                } else {
                                    if (!IgniteTxLocalAdapter.$assertionsDisabled && this.implicit() && this.transform) {
                                        throw new AssertionError(this);
                                    }
                                    if (!IgniteTxLocalAdapter.$assertionsDisabled && txEntry.op() == GridCacheOperation.TRANSFORM) {
                                        throw new AssertionError(txEntry);
                                    }
                                    if (retval) {
                                        ret.set(cacheCtx, null, true, keepBinary);
                                    } else {
                                        ret.success(true);
                                    }
                                }
                                break block47;
                            }
                            if (needReadVer) {
                                if (!IgniteTxLocalAdapter.$assertionsDisabled && readVer == null) {
                                    throw new AssertionError();
                                }
                                txEntry.entryReadVersion(singleRmv != false ? IgniteTxEntry.SER_READ_NOT_EMPTY_VER : readVer);
                            }
                            if (retval && !this.transform) {
                                ret.set(cacheCtx, old, true, keepBinary);
                                break block47;
                            }
                            if (txEntry.op() == GridCacheOperation.TRANSFORM) {
                                try {
                                    ver = entry.version();
                                }
                                catch (GridCacheEntryRemovedException ex) {
                                    if (!IgniteTxLocalAdapter.$assertionsDisabled && !this.optimistic()) {
                                        throw new AssertionError(txEntry);
                                    }
                                    if (IgniteTxLocalAdapter.log.isDebugEnabled()) {
                                        IgniteTxLocalAdapter.log.debug("Failed to get entry version [err=" + ex.getMessage() + ']');
                                    }
                                    ver = null;
                                }
                                this.addInvokeResult(txEntry, old, ret, ver);
                                break block47;
                            }
                            ret.success(true);
                            break block47;
                        }
                        if (retval && !this.transform) {
                            ret.set(cacheCtx, old, true, keepBinary);
                        } else {
                            ret.success(true);
                        }
                        break block47;
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        if (!IgniteTxLocalAdapter.log.isDebugEnabled()) continue;
                        IgniteTxLocalAdapter.log.debug("Got removed entry in transaction putAll0 method: " + entry);
                        continue;
                    }
                    break;
                }
            }
            if (entryProcessor == null && txEntry.op() == GridCacheOperation.TRANSFORM) {
                throw new IgniteCheckedException("Failed to enlist write value for key (cannot have update value in transaction after EntryProcessor is applied): " + CU.value(cacheKey, cacheCtx, false));
            }
            entry = txEntry.cached();
            v = txEntry.value();
            v3 = del = txEntry.op() == GridCacheOperation.DELETE && rmv != false;
            if (!del) {
                if (hasFilters && !this.filter(entry.context(), cacheKey, v, filter)) {
                    ret.set(cacheCtx, v, false, keepBinary);
                    return loadMissed;
                }
                op = rmv != false ? GridCacheOperation.DELETE : (entryProcessor != null ? GridCacheOperation.TRANSFORM : (v != null ? GridCacheOperation.UPDATE : GridCacheOperation.CREATE));
                txEntry = this.addEntry(op, cacheCtx.toCacheObject(val), entryProcessor, invokeArgs, entry, expiryPlc, filter, true, drTtl, drExpireTime, drVer, skipStore, keepBinary);
                if (enlisted != null) {
                    enlisted.add(cacheKey);
                }
                if (txEntry.op() == GridCacheOperation.TRANSFORM) {
                    try {
                        ver = entry.version();
                    }
                    catch (GridCacheEntryRemovedException e) {
                        if (!IgniteTxLocalAdapter.$assertionsDisabled && !this.optimistic()) {
                            throw new AssertionError(txEntry);
                        }
                        if (IgniteTxLocalAdapter.log.isDebugEnabled()) {
                            IgniteTxLocalAdapter.log.debug("Failed to get entry version: [msg=" + e.getMessage() + ']');
                        }
                        ver = null;
                    }
                    this.addInvokeResult(txEntry, txEntry.value(), ret, ver);
                }
            }
            if (!this.pessimistic()) {
                txEntry.markValid();
                if (retval && !this.transform) {
                    ret.set(cacheCtx, v, true, keepBinary);
                } else {
                    ret.success(true);
                }
            }
        }
        return loadMissed;
    }

    private boolean isAll(GridCacheContext cctx, KeyCacheObject key, CacheObject val, CacheEntryPredicate[] filter) {
        GridDhtDetachedCacheEntry e = new GridDhtDetachedCacheEntry(cctx, key, 0, val, null, 0){

            @Override
            @Nullable
            public CacheObject peekVisibleValue() {
                return this.rawGet();
            }
        };
        for (CacheEntryPredicate p0 : filter) {
            if (p0 == null || p0.apply(e)) continue;
            return false;
        }
        return true;
    }

    protected final void postLockWrite(GridCacheContext cacheCtx, Iterable<KeyCacheObject> keys, GridCacheReturn ret, boolean rmv, boolean retval, boolean read, long accessTtl, CacheEntryPredicate[] filter, boolean computeInvoke) throws IgniteCheckedException {
        block4: for (KeyCacheObject k : keys) {
            IgniteTxEntry txEntry = this.entry(cacheCtx.txKey(k));
            if (txEntry == null) {
                throw new IgniteCheckedException("Transaction entry is null (most likely collection of keys passed into cache operation was changed before operation completed) [missingKey=" + k + ", tx=" + this + ']');
            }
            while (true) {
                GridCacheEntryEx cached = txEntry.cached();
                try {
                    boolean pass;
                    boolean invoke;
                    assert (cached.detached() || cached.lockedByThread(this.threadId) || this.isRollbackOnly()) : "Transaction lock is not acquired [entry=" + cached + ", tx=" + this + ", nodeId=" + this.cctx.localNodeId() + ", threadId=" + this.threadId + ']';
                    if (log.isDebugEnabled()) {
                        log.debug("Post lock write entry: " + cached);
                    }
                    CacheObject v = txEntry.previousValue();
                    boolean hasPrevVal = txEntry.hasPreviousValue();
                    if (this.onePhaseCommit()) {
                        filter = txEntry.filters();
                    }
                    if (!F.isEmptyOrNulls(filter) && !F.isAlwaysTrue(filter)) {
                        retval = true;
                    }
                    boolean bl = invoke = txEntry.op() == GridCacheOperation.TRANSFORM;
                    if (retval || invoke) {
                        if (!cacheCtx.isNear()) {
                            if (!hasPrevVal) {
                                boolean readThrough = cacheCtx.isLocal() && (invoke || cacheCtx.loadPreviousValue()) && !txEntry.skipStore();
                                v = cached.innerGet(null, this, true, readThrough, !invoke, !invoke && !this.dht(), false, CU.subjectId(this, this.cctx), null, this.resolveTaskName(), null, txEntry.keepBinary());
                            }
                        } else if (!hasPrevVal) {
                            v = cached.rawGetOrUnmarshal(false);
                        }
                        if (txEntry.op() == GridCacheOperation.TRANSFORM) {
                            if (computeInvoke) {
                                GridCacheVersion ver;
                                try {
                                    ver = cached.version();
                                }
                                catch (GridCacheEntryRemovedException e) {
                                    assert (this.optimistic()) : txEntry;
                                    if (log.isDebugEnabled()) {
                                        log.debug("Failed to get entry version: [msg=" + e.getMessage() + ']');
                                    }
                                    ver = null;
                                }
                                this.addInvokeResult(txEntry, v, ret, ver);
                            }
                        } else {
                            ret.value(cacheCtx, v, txEntry.keepBinary());
                        }
                    }
                    boolean bl2 = pass = F.isEmpty(filter) || cacheCtx.isAll(cached, filter);
                    ret.success(pass && (!retval ? !rmv || cached.hasValue() || v != null : !rmv || v != null));
                    if (this.onePhaseCommit()) {
                        txEntry.filtersPassed(pass);
                    }
                    boolean updateTtl = read;
                    if (pass) {
                        txEntry.markValid();
                        if (log.isDebugEnabled()) {
                            log.debug("Filter passed in post lock for key: " + k);
                        }
                    } else {
                        txEntry.setAndMarkValid(txEntry.previousOperation(), cacheCtx.toCacheObject(ret.value()));
                        txEntry.filters(CU.empty0());
                        txEntry.filtersSet(false);
                        boolean bl3 = updateTtl = !cacheCtx.putIfAbsentFilter(filter);
                    }
                    if (!updateTtl) continue block4;
                    if (!read) {
                        ExpiryPolicy expiryPlc = cacheCtx.expiryForTxEntry(txEntry);
                        if (expiryPlc == null) continue block4;
                        txEntry.ttl(CU.toTtl(expiryPlc.getExpiryForAccess()));
                        continue block4;
                    }
                    txEntry.ttl(accessTtl);
                    continue block4;
                }
                catch (GridCacheEntryRemovedException ignore) {
                    if (log.isDebugEnabled()) {
                        log.debug("Got removed entry in putAllAsync method (will retry): " + cached);
                    }
                    txEntry.cached(this.entryEx(cached.context(), txEntry.txKey(), this.topologyVersion()));
                    continue;
                }
                break;
            }
        }
    }

    private void addInvokeResult(IgniteTxEntry txEntry, CacheObject cacheVal, GridCacheReturn ret, GridCacheVersion ver) {
        GridCacheContext<?, ?> ctx = txEntry.context();
        Object key0 = null;
        Object val0 = null;
        try {
            Object res = null;
            for (T2<EntryProcessor<Object, Object, Object>, Object[]> t : txEntry.entryProcessors()) {
                CacheInvokeEntry<Object, Object> invokeEntry = new CacheInvokeEntry<Object, Object>(txEntry.key(), key0, cacheVal, val0, ver, txEntry.keepBinary(), txEntry.cached());
                EntryProcessor entryProcessor = (EntryProcessor)t.get1();
                res = entryProcessor.process(invokeEntry, (Object[])t.get2());
                val0 = invokeEntry.value();
                key0 = invokeEntry.key();
            }
            if (res != null) {
                ret.addEntryProcessResult(ctx, txEntry.key(), key0, res, null, txEntry.keepBinary());
            }
        }
        catch (Exception e) {
            ret.addEntryProcessResult(ctx, txEntry.key(), key0, null, e, txEntry.keepBinary());
        }
    }

    private void checkUpdatesAllowed(GridCacheContext cacheCtx) throws IgniteCheckedException {
        if (!cacheCtx.updatesAllowed()) {
            throw new IgniteTxRollbackCheckedException(new CacheException("Updates are not allowed for transactional cache: " + cacheCtx.name() + ". Configure " + "persistence store on client or use remote closure execution to start transactions " + "from server nodes."));
        }
    }

    private void beforePut(GridCacheContext cacheCtx, boolean retval) throws IgniteCheckedException {
        this.checkUpdatesAllowed(cacheCtx);
        cacheCtx.checkSecurity(SecurityPermission.CACHE_PUT);
        if (retval) {
            this.needReturnValue(true);
        }
        this.checkValid();
        this.init();
    }

    private <K, V> IgniteInternalFuture putAsync0(final GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, K key, @Nullable V val, @Nullable EntryProcessor<K, V, Object> entryProcessor, @Nullable Object[] invokeArgs, final boolean retval, @Nullable CacheEntryPredicate filter) {
        assert (key != null);
        try {
            this.beforePut(cacheCtx, retval);
            GridCacheReturn ret = new GridCacheReturn(this.localResult(), false);
            CacheOperationContext opCtx = cacheCtx.operationContextPerCall();
            Byte dataCenterId = opCtx != null ? opCtx.dataCenterId() : null;
            KeyCacheObject cacheKey = cacheCtx.toCacheKeyObject(key);
            boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
            final CacheEntryPredicate[] filters = CU.filterArray(filter);
            IgniteInternalFuture<Void> loadFut = this.enlistWrite(cacheCtx, entryTopVer, cacheKey, val, opCtx != null ? opCtx.expiry() : null, entryProcessor, invokeArgs, retval, false, filters, ret, opCtx != null && opCtx.skipStore(), false, keepBinary, dataCenterId);
            if (this.pessimistic()) {
                long timeout;
                assert (loadFut == null || loadFut.isDone()) : loadFut;
                if (loadFut != null) {
                    loadFut.get();
                }
                final Set<KeyCacheObject> enlisted = Collections.singleton(cacheKey);
                if (log.isDebugEnabled()) {
                    log.debug("Before acquiring transaction lock for put on key: " + enlisted);
                }
                if ((timeout = this.remainingTime()) == -1L) {
                    return new GridFinishedFuture(this.timeoutException());
                }
                IgniteInternalFuture<Boolean> fut = cacheCtx.cache().txLockAsync(enlisted, timeout, this, entryProcessor != null, retval, this.isolation, this.isInvalidate(), -1L, -1L);
                PLC1<GridCacheReturn> plc1 = new PLC1<GridCacheReturn>(ret){

                    @Override
                    public GridCacheReturn postLock(GridCacheReturn ret) throws IgniteCheckedException {
                        if (IgniteTxAdapter.log.isDebugEnabled()) {
                            IgniteTxAdapter.log.debug("Acquired transaction lock for put on keys: " + enlisted);
                        }
                        IgniteTxLocalAdapter.this.postLockWrite(cacheCtx, enlisted, ret, false, retval, false, -1L, filters, true);
                        return ret;
                    }
                };
                if (fut.isDone()) {
                    try {
                        return this.nonInterruptable(plc1.apply(fut.get(), null));
                    }
                    catch (GridClosureException e) {
                        return new GridFinishedFuture(e.unwrap());
                    }
                    catch (IgniteCheckedException e) {
                        try {
                            return this.nonInterruptable(plc1.apply(false, e));
                        }
                        catch (Exception e1) {
                            return new GridFinishedFuture(e1);
                        }
                    }
                }
                return this.nonInterruptable(new GridEmbeddedFuture<GridCacheReturn, Boolean>(fut, plc1));
            }
            return this.optimisticPutFuture(cacheCtx, loadFut, ret, keepBinary);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture(e);
        }
        catch (RuntimeException e) {
            this.onException();
            throw e;
        }
    }

    private <K, V> IgniteInternalFuture putAllAsync0(final GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, @Nullable Map<? extends K, ? extends V> map, @Nullable Map<? extends K, ? extends EntryProcessor<K, V, Object>> invokeMap, @Nullable Object[] invokeArgs, @Nullable Map<KeyCacheObject, GridCacheDrInfo> drMap, final boolean retval) {
        Byte dataCenterId;
        try {
            this.beforePut(cacheCtx, retval);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture(e);
        }
        CacheOperationContext opCtx = cacheCtx.operationContextPerCall();
        if (opCtx != null && opCtx.hasDataCenterId()) {
            assert (drMap == null) : drMap;
            assert (map != null || invokeMap != null);
            dataCenterId = opCtx.dataCenterId();
        } else {
            dataCenterId = null;
        }
        Map<K, V> map0 = map;
        Map<K, EntryProcessor<K, V, Object>> invokeMap0 = invokeMap;
        if (log.isDebugEnabled()) {
            log.debug("Called putAllAsync(...) [tx=" + this + ", map=" + map0 + ", retval=" + retval + "]");
        }
        assert (map0 != null || invokeMap0 != null);
        GridCacheReturn ret = new GridCacheReturn(this.localResult(), false);
        if (F.isEmpty(map0) && F.isEmpty(invokeMap0)) {
            if (this.implicit()) {
                try {
                    this.commit();
                }
                catch (IgniteCheckedException e) {
                    return new GridFinishedFuture(e);
                }
            }
            return new GridFinishedFuture<GridCacheReturn>(ret.success(true));
        }
        try {
            Set<K> keySet = map0 != null ? map0.keySet() : invokeMap0.keySet();
            final ArrayList<KeyCacheObject> enlisted = new ArrayList<KeyCacheObject>(keySet.size());
            boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
            IgniteInternalFuture<Void> loadFut = this.enlistWrite(cacheCtx, entryTopVer, keySet, opCtx != null ? opCtx.expiry() : null, map0, invokeMap0, invokeArgs, retval, false, CU.filterArray(null), ret, enlisted, drMap, null, opCtx != null && opCtx.skipStore(), false, keepBinary, dataCenterId);
            if (this.pessimistic()) {
                long timeout;
                assert (loadFut == null || loadFut.isDone()) : loadFut;
                if (loadFut != null) {
                    try {
                        loadFut.get();
                    }
                    catch (IgniteCheckedException e) {
                        return new GridFinishedFuture(e);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Before acquiring transaction lock for put on keys: " + enlisted);
                }
                if ((timeout = this.remainingTime()) == -1L) {
                    return new GridFinishedFuture(this.timeoutException());
                }
                IgniteInternalFuture<Boolean> fut = cacheCtx.cache().txLockAsync(enlisted, timeout, this, invokeMap != null, retval, this.isolation, this.isInvalidate(), -1L, -1L);
                PLC1<GridCacheReturn> plc1 = new PLC1<GridCacheReturn>(ret){

                    @Override
                    public GridCacheReturn postLock(GridCacheReturn ret) throws IgniteCheckedException {
                        if (IgniteTxAdapter.log.isDebugEnabled()) {
                            IgniteTxAdapter.log.debug("Acquired transaction lock for put on keys: " + enlisted);
                        }
                        IgniteTxLocalAdapter.this.postLockWrite(cacheCtx, enlisted, ret, false, retval, false, -1L, CU.filterArray(null), true);
                        return ret;
                    }
                };
                if (fut.isDone()) {
                    try {
                        return this.nonInterruptable(plc1.apply(fut.get(), null));
                    }
                    catch (GridClosureException e) {
                        return new GridFinishedFuture(e.unwrap());
                    }
                    catch (IgniteCheckedException e) {
                        try {
                            return this.nonInterruptable(plc1.apply(false, e));
                        }
                        catch (Exception e1) {
                            return new GridFinishedFuture(e1);
                        }
                    }
                }
                return this.nonInterruptable(new GridEmbeddedFuture<GridCacheReturn, Boolean>(fut, plc1));
            }
            return this.optimisticPutFuture(cacheCtx, loadFut, ret, keepBinary);
        }
        catch (RuntimeException e) {
            this.onException();
            throw e;
        }
    }

    private IgniteInternalFuture optimisticPutFuture(final GridCacheContext cacheCtx, IgniteInternalFuture<Void> loadFut, final GridCacheReturn ret, final boolean keepBinary) {
        if (this.implicit()) {
            assert (loadFut.isDone());
            try {
                loadFut.get();
            }
            catch (IgniteCheckedException e) {
                return new GridFinishedFuture(e);
            }
            return this.nonInterruptable(this.commitAsync().chain(new CX1<IgniteInternalFuture<IgniteInternalTx>, GridCacheReturn>(){

                @Override
                public GridCacheReturn applyx(IgniteInternalFuture<IgniteInternalTx> txFut) throws IgniteCheckedException {
                    try {
                        txFut.get();
                        Object res = IgniteTxLocalAdapter.this.implicitRes.value();
                        if (IgniteTxLocalAdapter.this.implicitRes.invokeResult()) {
                            assert (res == null || res instanceof Map) : IgniteTxLocalAdapter.this.implicitRes;
                            res = cacheCtx.unwrapInvokeResult((Map)res, keepBinary);
                        }
                        return new GridCacheReturn(cacheCtx, true, keepBinary, res, IgniteTxLocalAdapter.this.implicitRes.success());
                    }
                    catch (RuntimeException | IgniteCheckedException e) {
                        IgniteTxLocalAdapter.this.rollbackAsync();
                        throw e;
                    }
                }
            }));
        }
        return this.nonInterruptable(loadFut.chain(new CX1<IgniteInternalFuture<Void>, GridCacheReturn>(){

            @Override
            public GridCacheReturn applyx(IgniteInternalFuture<Void> f) throws IgniteCheckedException {
                f.get();
                return ret;
            }
        }));
    }

    private void onException() {
        for (IgniteTxEntry txEntry : this.allEntries()) {
            GridCacheEntryEx cached0 = txEntry.cached();
            if (cached0 == null) continue;
            txEntry.context().evicts().touch(cached0, this.topologyVersion());
        }
    }

    @Override
    public <K, V> IgniteInternalFuture<GridCacheReturn> removeAllAsync(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, Collection<? extends K> keys, boolean retval, CacheEntryPredicate filter, boolean singleRmv) {
        return this.removeAllAsync0(cacheCtx, entryTopVer, keys, null, retval, filter, singleRmv);
    }

    private <K, V> IgniteInternalFuture<GridCacheReturn> removeAllAsync0(final GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, @Nullable Collection<? extends K> keys, @Nullable Map<KeyCacheObject, GridCacheVersion> drMap, final boolean retval, @Nullable CacheEntryPredicate filter, boolean singleRmv) {
        Byte dataCenterId;
        Collection<? extends K> keys0;
        try {
            this.checkUpdatesAllowed(cacheCtx);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<GridCacheReturn>(e);
        }
        cacheCtx.checkSecurity(SecurityPermission.CACHE_REMOVE);
        if (retval) {
            this.needReturnValue(true);
        }
        if (drMap != null) {
            assert (keys == null);
            keys0 = drMap.keySet();
        } else {
            keys0 = keys;
        }
        CacheOperationContext opCtx = cacheCtx.operationContextPerCall();
        if (opCtx != null && opCtx.hasDataCenterId()) {
            assert (drMap == null) : drMap;
            dataCenterId = opCtx.dataCenterId();
        } else {
            dataCenterId = null;
        }
        assert (keys0 != null);
        if (log.isDebugEnabled()) {
            log.debug(S.toString("Called removeAllAsync(...)", "tx", this, false, "keys", keys0, true, "implicit", this.implicit, false, "retval", retval, false));
        }
        try {
            this.checkValid();
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<GridCacheReturn>(e);
        }
        final GridCacheReturn ret = new GridCacheReturn(this.localResult(), false);
        if (F.isEmpty(keys0)) {
            if (this.implicit()) {
                try {
                    this.commit();
                }
                catch (IgniteCheckedException e) {
                    return new GridFinishedFuture<GridCacheReturn>(e);
                }
            }
            return new GridFinishedFuture<GridCacheReturn>(ret.success(true));
        }
        this.init();
        final ArrayList<KeyCacheObject> enlisted = new ArrayList<KeyCacheObject>();
        final CacheEntryPredicate[] filters = CU.filterArray(filter);
        ExpiryPolicy plc = !F.isEmpty(filters) ? (opCtx != null ? opCtx.expiry() : null) : null;
        final boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
        IgniteInternalFuture<Void> loadFut = this.enlistWrite(cacheCtx, entryTopVer, keys0, plc, null, null, null, retval, false, filters, ret, enlisted, null, drMap, opCtx != null && opCtx.skipStore(), singleRmv, keepBinary, dataCenterId);
        if (log.isDebugEnabled()) {
            log.debug("Remove keys: " + enlisted);
        }
        if (this.pessimistic()) {
            long timeout;
            assert (loadFut == null || loadFut.isDone()) : loadFut;
            if (loadFut != null) {
                try {
                    loadFut.get();
                }
                catch (IgniteCheckedException e) {
                    return new GridFinishedFuture<GridCacheReturn>(e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Before acquiring transaction lock for remove on keys: " + enlisted);
            }
            if ((timeout = this.remainingTime()) == -1L) {
                return new GridFinishedFuture<GridCacheReturn>(this.timeoutException());
            }
            IgniteInternalFuture<Boolean> fut = cacheCtx.cache().txLockAsync(enlisted, timeout, this, false, retval, this.isolation, this.isInvalidate(), -1L, -1L);
            PLC1<GridCacheReturn> plc1 = new PLC1<GridCacheReturn>(ret){

                @Override
                protected GridCacheReturn postLock(GridCacheReturn ret) throws IgniteCheckedException {
                    if (IgniteTxAdapter.log.isDebugEnabled()) {
                        IgniteTxAdapter.log.debug("Acquired transaction lock for remove on keys: " + enlisted);
                    }
                    IgniteTxLocalAdapter.this.postLockWrite(cacheCtx, enlisted, ret, true, retval, false, -1L, filters, false);
                    return ret;
                }
            };
            if (fut.isDone()) {
                try {
                    return this.nonInterruptable(plc1.apply(fut.get(), null));
                }
                catch (GridClosureException e) {
                    return new GridFinishedFuture<GridCacheReturn>(e.unwrap());
                }
                catch (IgniteCheckedException e) {
                    try {
                        return this.nonInterruptable(plc1.apply(false, e));
                    }
                    catch (Exception e1) {
                        return new GridFinishedFuture<GridCacheReturn>(e1);
                    }
                }
            }
            return this.nonInterruptable(new GridEmbeddedFuture<GridCacheReturn, Boolean>(fut, plc1));
        }
        if (this.implicit()) {
            assert (loadFut.isDone());
            return this.nonInterruptable(this.commitAsync().chain(new CX1<IgniteInternalFuture<IgniteInternalTx>, GridCacheReturn>(){

                @Override
                public GridCacheReturn applyx(IgniteInternalFuture<IgniteInternalTx> txFut) throws IgniteCheckedException {
                    try {
                        txFut.get();
                        return new GridCacheReturn(cacheCtx, true, keepBinary, IgniteTxLocalAdapter.this.implicitRes.value(), IgniteTxLocalAdapter.this.implicitRes.success());
                    }
                    catch (RuntimeException | IgniteCheckedException e) {
                        IgniteTxLocalAdapter.this.rollbackAsync();
                        throw e;
                    }
                }
            }));
        }
        return this.nonInterruptable(loadFut.chain(new CX1<IgniteInternalFuture<Void>, GridCacheReturn>(){

            @Override
            public GridCacheReturn applyx(IgniteInternalFuture<Void> f) throws IgniteCheckedException {
                f.get();
                return ret;
            }
        }));
    }

    private <T> IgniteInternalFuture<T> nonInterruptable(IgniteInternalFuture<T> fut) {
        if (fut instanceof GridFutureAdapter) {
            ((GridFutureAdapter)fut).ignoreInterrupts(true);
        }
        return fut;
    }

    private boolean deserializeBinaries(GridCacheContext cacheCtx) {
        CacheOperationContext opCtx = cacheCtx.operationContextPerCall();
        return opCtx == null || !opCtx.isKeepBinary();
    }

    public boolean init() {
        return !this.txState.init(this.txSize) || this.cctx.tm().onStarted(this);
    }

    protected final void addActiveCache(GridCacheContext cacheCtx) throws IgniteCheckedException {
        this.txState.addActiveCache(cacheCtx, this);
    }

    protected void checkValid() throws IgniteCheckedException {
        if (this.local() && !this.dht() && this.remainingTime() == -1L) {
            this.state(TransactionState.MARKED_ROLLBACK, true);
        }
        if (this.isRollbackOnly()) {
            if (this.remainingTime() == -1L) {
                throw new IgniteTxTimeoutCheckedException("Cache transaction timed out: " + this);
            }
            TransactionState state = this.state();
            if (state == TransactionState.ROLLING_BACK || state == TransactionState.ROLLED_BACK) {
                throw new IgniteTxRollbackCheckedException("Cache transaction is marked as rollback-only (will be rolled back automatically): " + this);
            }
            if (state == TransactionState.UNKNOWN) {
                throw new IgniteTxHeuristicCheckedException("Cache transaction is in unknown state (remote transactions will be invalidated): " + this);
            }
            throw new IgniteCheckedException("Cache transaction marked as rollback-only: " + this);
        }
    }

    @Override
    public Collection<GridCacheVersion> alternateVersions() {
        return Collections.emptyList();
    }

    protected final IgniteTxEntry addEntry(GridCacheOperation op, @Nullable CacheObject val, @Nullable EntryProcessor entryProcessor, Object[] invokeArgs, GridCacheEntryEx entry, @Nullable ExpiryPolicy expiryPlc, CacheEntryPredicate[] filter, boolean filtersSet, long drTtl, long drExpireTime, @Nullable GridCacheVersion drVer, boolean skipStore, boolean keepBinary) {
        IgniteTxEntry txEntry;
        assert (invokeArgs == null || op == GridCacheOperation.TRANSFORM);
        IgniteTxKey key = entry.txKey();
        this.checkInternal(key);
        TransactionState state = this.state();
        assert (state == TransactionState.ACTIVE || this.remainingTime() == -1L) : "Invalid tx state for adding entry [op=" + (Object)((Object)op) + ", val=" + val + ", entry=" + entry + ", filter=" + Arrays.toString(filter) + ", txCtx=" + this.cctx.tm().txContextVersion() + ", tx=" + this + ']';
        IgniteTxEntry old = this.entry(key);
        if (!(filtersSet && F.isEmptyOrNulls(filter) || old == null || !old.filtersSet())) {
            filter = old.filters();
        }
        if (old != null) {
            if (entryProcessor != null) {
                assert (val == null);
                assert (op == GridCacheOperation.TRANSFORM);
                old.addEntryProcessor(entryProcessor, invokeArgs);
            } else {
                assert (old.op() != GridCacheOperation.TRANSFORM);
                old.op(op);
                old.value(val, op == GridCacheOperation.CREATE || op == GridCacheOperation.UPDATE || op == GridCacheOperation.DELETE, op == GridCacheOperation.READ);
            }
            old.cached(entry);
            old.filters(filter);
            old.skipStore(skipStore);
            old.keepBinary(keepBinary);
            if (drTtl >= 0L) {
                assert (drExpireTime >= 0L);
                this.entryTtlDr(key, drTtl, drExpireTime);
            } else {
                this.entryExpiry(key, expiryPlc);
            }
            txEntry = old;
            if (log.isDebugEnabled()) {
                log.debug("Updated transaction entry: " + txEntry);
            }
        } else {
            boolean hasDrTtl = drTtl >= 0L;
            txEntry = new IgniteTxEntry(entry.context(), this, op, val, EntryProcessorResourceInjectorProxy.wrap(this.cctx.kernalContext(), entryProcessor), invokeArgs, hasDrTtl ? drTtl : -1L, entry, filter, drVer, skipStore, keepBinary);
            txEntry.conflictExpireTime(drExpireTime);
            if (!hasDrTtl) {
                txEntry.expiry(expiryPlc);
            }
            this.txState.addEntry(txEntry);
            if (log.isDebugEnabled()) {
                log.debug("Created transaction entry: " + txEntry);
            }
        }
        txEntry.filtersSet(filtersSet);
        while (true) {
            try {
                this.updateExplicitVersion(txEntry, entry);
                return txEntry;
            }
            catch (GridCacheEntryRemovedException ignore) {
                if (log.isDebugEnabled()) {
                    log.debug("Got removed entry in transaction newEntry method (will retry): " + entry);
                }
                entry = this.entryEx(entry.context(), txEntry.txKey(), this.topologyVersion());
                txEntry.cached(entry);
                continue;
            }
            break;
        }
    }

    protected void updateExplicitVersion(IgniteTxEntry txEntry, GridCacheEntryEx entry) throws GridCacheEntryRemovedException {
        if (!entry.context().isDht()) {
            GridCacheMvccCandidate explicitCand = entry.localOwner();
            if (explicitCand == null) {
                explicitCand = this.cctx.mvcc().explicitLock(this.threadId(), entry.txKey());
            }
            if (explicitCand != null) {
                GridCacheVersion explicitVer = explicitCand.version();
                boolean locCand = false;
                if (explicitCand.nearLocal() || explicitCand.local()) {
                    locCand = this.cctx.localNodeId().equals(explicitCand.nodeId());
                } else if (explicitCand.dhtLocal()) {
                    locCand = this.cctx.localNodeId().equals(explicitCand.otherNodeId());
                }
                if (!explicitVer.equals(this.xidVer) && explicitCand.threadId() == this.threadId && !explicitCand.tx() && locCand) {
                    txEntry.explicitVersion(explicitVer);
                    if (explicitVer.isLess(this.minVer)) {
                        this.minVer = explicitVer;
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        return GridToStringBuilder.toString(IgniteTxLocalAdapter.class, this, "super", super.toString(), "size", this.allEntries().size());
    }

    void entryExpiry(IgniteTxKey key, @Nullable ExpiryPolicy expiryPlc) {
        assert (key != null);
        IgniteTxEntry e = this.entry(key);
        if (e != null) {
            e.expiry(expiryPlc);
            e.conflictExpireTime(-1L);
        }
    }

    boolean entryTtlDr(IgniteTxKey key, long ttl, long expireTime) {
        assert (key != null);
        assert (ttl >= 0L);
        IgniteTxEntry e = this.entry(key);
        if (e != null) {
            e.ttl(ttl);
            e.conflictExpireTime(expireTime);
            e.expiry(null);
        }
        return e != null;
    }

    public long entryTtl(IgniteTxKey key) {
        assert (key != null);
        IgniteTxEntry e = this.entry(key);
        return e != null ? e.ttl() : 0L;
    }

    public long entryExpireTime(IgniteTxKey key) {
        assert (key != null);
        IgniteTxEntry e = this.entry(key);
        if (e != null) {
            long expireTime;
            long ttl = e.ttl();
            assert (ttl != -1L);
            if (ttl > 0L && (expireTime = U.currentTimeMillis() + ttl) > 0L) {
                return expireTime;
            }
        }
        return 0L;
    }

    protected abstract class FinishClosure<T>
    implements IgniteBiClosure<T, Exception, T> {
        private static final long serialVersionUID = 0L;

        protected FinishClosure() {
        }

        @Override
        public final T apply(T t, @Nullable Exception e) {
            boolean rollback = true;
            try {
                if (e != null) {
                    throw new GridClosureException(e);
                }
                t = this.finish(t);
                if (IgniteTxLocalAdapter.this.implicit()) {
                    IgniteTxLocalAdapter.this.commit();
                }
                rollback = false;
                T t2 = t;
                return t2;
            }
            catch (IgniteCheckedException ex) {
                throw new GridClosureException(ex);
            }
            finally {
                if (rollback) {
                    IgniteTxLocalAdapter.this.setRollbackOnly();
                }
            }
        }

        abstract T finish(T var1) throws IgniteCheckedException;
    }

    protected abstract class PostMissClosure<T>
    implements IgniteBiClosure<T, Exception, IgniteInternalFuture<T>> {
        private static final long serialVersionUID = 0L;

        protected PostMissClosure() {
        }

        @Override
        public final IgniteInternalFuture<T> apply(T t, Exception e) {
            boolean rollback = true;
            try {
                if (e != null) {
                    throw new GridClosureException(e);
                }
                IgniteInternalFuture<T> fut = this.postMiss(t);
                rollback = false;
                IgniteInternalFuture<T> igniteInternalFuture = fut;
                return igniteInternalFuture;
            }
            catch (IgniteCheckedException ex) {
                throw new GridClosureException(ex);
            }
            finally {
                if (rollback) {
                    IgniteTxLocalAdapter.this.setRollbackOnly();
                }
            }
        }

        protected abstract IgniteInternalFuture<T> postMiss(T var1) throws IgniteCheckedException;
    }

    protected abstract class PostLockClosure2<T>
    implements IgniteBiClosure<Boolean, Exception, IgniteInternalFuture<T>> {
        private static final long serialVersionUID = 0L;

        protected PostLockClosure2() {
        }

        @Override
        public final IgniteInternalFuture<T> apply(Boolean locked, @Nullable Exception e) {
            boolean rollback = true;
            try {
                if (e != null) {
                    throw new GridClosureException(e);
                }
                if (!locked.booleanValue()) {
                    throw new GridClosureException(new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + IgniteTxLocalAdapter.this.timeout() + ", tx=" + IgniteTxLocalAdapter.this + ']'));
                }
                IgniteInternalFuture<T> fut = this.postLock();
                rollback = false;
                IgniteInternalFuture<T> igniteInternalFuture = fut;
                return igniteInternalFuture;
            }
            catch (IgniteCheckedException ex) {
                throw new GridClosureException(ex);
            }
            finally {
                if (rollback) {
                    IgniteTxLocalAdapter.this.setRollbackOnly();
                }
            }
        }

        protected abstract IgniteInternalFuture<T> postLock() throws IgniteCheckedException;
    }

    protected abstract class PostLockClosure1<T>
    implements IgniteBiClosure<Boolean, Exception, IgniteInternalFuture<T>> {
        private static final long serialVersionUID = 0L;
        private T arg;
        private boolean commit;

        protected PostLockClosure1(T arg) {
            this(arg, true);
        }

        protected PostLockClosure1(T arg, boolean commit) {
            this.arg = arg;
            this.commit = commit;
        }

        @Override
        public final IgniteInternalFuture<T> apply(Boolean locked, final @Nullable Exception e) {
            TransactionDeadlockException deadlockErr = X.cause(e, TransactionDeadlockException.class);
            if (e != null && deadlockErr == null) {
                IgniteTxLocalAdapter.this.setRollbackOnly();
                if (this.commit && IgniteTxLocalAdapter.this.commitAfterLock()) {
                    return IgniteTxLocalAdapter.this.rollbackAsync().chain(new C1<IgniteInternalFuture<IgniteInternalTx>, T>(){

                        @Override
                        public T apply(IgniteInternalFuture<IgniteInternalTx> f) {
                            throw new GridClosureException(e);
                        }
                    });
                }
                throw new GridClosureException(e);
            }
            if (deadlockErr != null || !locked.booleanValue()) {
                IgniteTxLocalAdapter.this.setRollbackOnly();
                final GridClosureException ex = new GridClosureException(new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + IgniteTxLocalAdapter.this.timeout() + ", tx=" + this + ']', deadlockErr));
                if (this.commit && IgniteTxLocalAdapter.this.commitAfterLock()) {
                    return IgniteTxLocalAdapter.this.rollbackAsync().chain(new C1<IgniteInternalFuture<IgniteInternalTx>, T>(){

                        @Override
                        public T apply(IgniteInternalFuture<IgniteInternalTx> f) {
                            throw ex;
                        }
                    });
                }
                throw ex;
            }
            boolean rollback = true;
            try {
                final T r = this.postLock(this.arg);
                if (this.commit && IgniteTxLocalAdapter.this.commitAfterLock()) {
                    rollback = false;
                    IgniteInternalFuture igniteInternalFuture = IgniteTxLocalAdapter.this.commitAsync().chain(new CX1<IgniteInternalFuture<IgniteInternalTx>, T>(){

                        @Override
                        public T applyx(IgniteInternalFuture<IgniteInternalTx> f) throws IgniteCheckedException {
                            f.get();
                            return r;
                        }
                    });
                    return igniteInternalFuture;
                }
                rollback = false;
                GridFinishedFuture<T> gridFinishedFuture = new GridFinishedFuture<T>(r);
                return gridFinishedFuture;
            }
            catch (IgniteCheckedException ex) {
                if (this.commit && IgniteTxLocalAdapter.this.commitAfterLock()) {
                    IgniteInternalFuture igniteInternalFuture = IgniteTxLocalAdapter.this.rollbackAsync().chain(new C1<IgniteInternalFuture<IgniteInternalTx>, T>(){

                        @Override
                        public T apply(IgniteInternalFuture<IgniteInternalTx> f) {
                            throw new GridClosureException(ex);
                        }
                    });
                    return igniteInternalFuture;
                }
                throw new GridClosureException(ex);
            }
            finally {
                if (rollback) {
                    IgniteTxLocalAdapter.this.setRollbackOnly();
                }
            }
        }

        protected abstract T postLock(T var1) throws IgniteCheckedException;
    }

    protected abstract class PMC<T>
    extends PostMissClosure<T> {
        private static final long serialVersionUID = 0L;

        protected PMC() {
        }
    }

    protected abstract class PLC2<T>
    extends PostLockClosure2<T> {
        private static final long serialVersionUID = 0L;

        protected PLC2() {
        }
    }

    protected abstract class PLC1<T>
    extends PostLockClosure1<T> {
        private static final long serialVersionUID = 0L;

        protected PLC1(T arg) {
            super(arg);
        }

        protected PLC1(T arg, boolean commit) {
            super(arg, commit);
        }
    }
}

