/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheInterceptor;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.store.CacheStoreManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalStateAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxMap;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class IgniteTxStateImpl
extends IgniteTxLocalStateAdapter {
    private GridLongList activeCacheIds = new GridLongList();
    @GridToStringInclude
    protected Map<IgniteTxKey, IgniteTxEntry> txMap;
    @GridToStringExclude
    protected IgniteTxMap readView;
    @GridToStringExclude
    protected IgniteTxMap writeView;

    @Override
    public boolean implicitSingle() {
        return false;
    }

    @Override
    @Nullable
    public Integer firstCacheId() {
        return this.activeCacheIds.isEmpty() ? null : Integer.valueOf((int)this.activeCacheIds.get(0));
    }

    @Override
    public void unwindEvicts(GridCacheSharedContext cctx) {
        for (int i = 0; i < this.activeCacheIds.size(); ++i) {
            int cacheId = (int)this.activeCacheIds.get(i);
            GridCacheContext ctx = cctx.cacheContext(cacheId);
            if (ctx == null) continue;
            CU.unwindEvicts(ctx);
        }
    }

    @Override
    @Nullable
    public GridCacheContext singleCacheContext(GridCacheSharedContext cctx) {
        if (this.activeCacheIds.size() == 1) {
            int cacheId = (int)this.activeCacheIds.get(0);
            return cctx.cacheContext(cacheId);
        }
        return null;
    }

    @Override
    public void awaitLastFut(GridCacheSharedContext cctx) {
        for (int i = 0; i < this.activeCacheIds.size(); ++i) {
            int cacheId = (int)this.activeCacheIds.get(i);
            cctx.cacheContext(cacheId).cache().awaitLastFut();
        }
    }

    @Override
    public IgniteCheckedException validateTopology(GridCacheSharedContext cctx, GridDhtTopologyFuture topFut) {
        int cacheId;
        int i;
        StringBuilder invalidCaches = null;
        for (i = 0; i < this.activeCacheIds.size(); ++i) {
            cacheId = (int)this.activeCacheIds.get(i);
            GridCacheContext ctx = cctx.cacheContext(cacheId);
            assert (ctx != null) : cacheId;
            Throwable err = topFut.validateCache(ctx);
            if (err == null) continue;
            if (invalidCaches != null) {
                invalidCaches.append(", ");
            } else {
                invalidCaches = new StringBuilder();
            }
            invalidCaches.append(U.maskName(ctx.name()));
        }
        if (invalidCaches != null) {
            return new IgniteCheckedException("Failed to perform cache operation (cache topology is not valid): " + invalidCaches.toString());
        }
        for (i = 0; i < this.activeCacheIds.size(); ++i) {
            cacheId = (int)this.activeCacheIds.get(i);
            GridCacheContext cacheCtx = cctx.cacheContext(cacheId);
            if (!CU.affinityNodes(cacheCtx, topFut.topologyVersion()).isEmpty()) continue;
            return new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid): " + cacheCtx.name());
        }
        return null;
    }

    @Override
    public CacheWriteSynchronizationMode syncMode(GridCacheSharedContext cctx) {
        CacheWriteSynchronizationMode syncMode = CacheWriteSynchronizationMode.FULL_ASYNC;
        block4: for (int i = 0; i < this.activeCacheIds.size(); ++i) {
            int cacheId = (int)this.activeCacheIds.get(i);
            CacheWriteSynchronizationMode cacheSyncMode = cctx.cacheContext(cacheId).config().getWriteSynchronizationMode();
            switch (cacheSyncMode) {
                case FULL_SYNC: {
                    return CacheWriteSynchronizationMode.FULL_SYNC;
                }
                case PRIMARY_SYNC: {
                    if (syncMode != CacheWriteSynchronizationMode.FULL_ASYNC) continue block4;
                    syncMode = CacheWriteSynchronizationMode.PRIMARY_SYNC;
                    continue block4;
                }
            }
        }
        return syncMode;
    }

    @Override
    public boolean hasNearCache(GridCacheSharedContext cctx) {
        for (int i = 0; i < this.activeCacheIds.size(); ++i) {
            int cacheId = (int)this.activeCacheIds.get(i);
            GridCacheContext cacheCtx = cctx.cacheContext(cacheId);
            if (!cacheCtx.isNear()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addActiveCache(GridCacheContext cacheCtx, IgniteTxLocalAdapter tx) throws IgniteCheckedException {
        GridCacheSharedContext cctx = cacheCtx.shared();
        int cacheId = cacheCtx.cacheId();
        if (!this.activeCacheIds.contains(cacheId)) {
            String err = cctx.verifyTxCompatibility(tx, this.activeCacheIds, cacheCtx);
            if (err != null) {
                StringBuilder cacheNames = new StringBuilder();
                int idx = 0;
                for (int i = 0; i < this.activeCacheIds.size(); ++i) {
                    int activeCacheId = (int)this.activeCacheIds.get(i);
                    cacheNames.append(cctx.cacheContext(activeCacheId).name());
                    if (idx++ >= this.activeCacheIds.size() - 1) continue;
                    cacheNames.append(", ");
                }
                throw new IgniteCheckedException("Failed to enlist new cache to existing transaction (" + err + ") [activeCaches=[" + cacheNames + "]" + ", cacheName=" + cacheCtx.name() + ", cacheSystem=" + cacheCtx.systemTx() + ", txSystem=" + tx.system() + ']');
            }
            this.activeCacheIds.add(cacheId);
            if (this.activeCacheIds.size() == 1) {
                tx.activeCachesDeploymentEnabled(cacheCtx.deploymentEnabled());
            }
        }
    }

    @Override
    public GridDhtTopologyFuture topologyReadLock(GridCacheSharedContext cctx, GridFutureAdapter<?> fut) {
        if (this.activeCacheIds.isEmpty()) {
            return cctx.exchange().lastTopologyFuture();
        }
        GridCacheContext nonLocCtx = null;
        for (int i = 0; i < this.activeCacheIds.size(); ++i) {
            int cacheId = (int)this.activeCacheIds.get(i);
            GridCacheContext cacheCtx = cctx.cacheContext(cacheId);
            if (cacheCtx.isLocal()) continue;
            nonLocCtx = cacheCtx;
            break;
        }
        if (nonLocCtx == null) {
            return cctx.exchange().lastTopologyFuture();
        }
        nonLocCtx.topology().readLock();
        if (nonLocCtx.topology().stopping()) {
            fut.onDone(new IgniteCheckedException("Failed to perform cache operation (cache is stopped): " + nonLocCtx.name()));
            return null;
        }
        return nonLocCtx.topology().topologyVersionFuture();
    }

    @Override
    public void topologyReadUnlock(GridCacheSharedContext cctx) {
        if (!this.activeCacheIds.isEmpty()) {
            GridCacheContext nonLocCtx = null;
            for (int i = 0; i < this.activeCacheIds.size(); ++i) {
                int cacheId = (int)this.activeCacheIds.get(i);
                GridCacheContext cacheCtx = cctx.cacheContext(cacheId);
                if (cacheCtx.isLocal()) continue;
                nonLocCtx = cacheCtx;
                break;
            }
            if (nonLocCtx != null) {
                nonLocCtx.topology().readUnlock();
            }
        }
    }

    @Override
    public boolean storeUsed(GridCacheSharedContext cctx) {
        if (!this.activeCacheIds.isEmpty()) {
            for (int i = 0; i < this.activeCacheIds.size(); ++i) {
                int cacheId = (int)this.activeCacheIds.get(i);
                CacheStoreManager store = cctx.cacheContext(cacheId).store();
                if (!store.configured()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasInterceptor(GridCacheSharedContext cctx) {
        for (int i = 0; i < this.activeCacheIds.size(); ++i) {
            int cacheId = (int)this.activeCacheIds.get(i);
            CacheInterceptor interceptor = cctx.cacheContext(cacheId).config().getInterceptor();
            if (interceptor == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<CacheStoreManager> stores(GridCacheSharedContext cctx) {
        GridLongList cacheIds = this.activeCacheIds;
        if (!cacheIds.isEmpty()) {
            ArrayList<CacheStoreManager> stores = new ArrayList<CacheStoreManager>(cacheIds.size());
            for (int i = 0; i < cacheIds.size(); ++i) {
                int cacheId = (int)cacheIds.get(i);
                CacheStoreManager store = cctx.cacheContext(cacheId).store();
                if (!store.configured()) continue;
                stores.add(store);
            }
            return stores;
        }
        return null;
    }

    @Override
    public void onTxEnd(GridCacheSharedContext cctx, IgniteInternalTx tx, boolean commit) {
        for (int i = 0; i < this.activeCacheIds.size(); ++i) {
            int cacheId = (int)this.activeCacheIds.get(i);
            GridCacheContext cacheCtx = cctx.cacheContext(cacheId);
            this.onTxEnd(cacheCtx, tx, commit);
        }
    }

    @Override
    public boolean init(int txSize) {
        if (this.txMap == null) {
            this.txMap = U.newLinkedHashMap(txSize > 0 ? txSize : 16);
            this.readView = new IgniteTxMap(this.txMap, CU.reads());
            this.writeView = new IgniteTxMap(this.txMap, CU.writes());
            return true;
        }
        return false;
    }

    @Override
    public boolean initialized() {
        return this.txMap != null;
    }

    @Override
    public Collection<IgniteTxEntry> allEntries() {
        return this.txMap == null ? Collections.emptySet() : this.txMap.values();
    }

    public synchronized Collection<IgniteTxEntry> allEntriesCopy() {
        return this.txMap == null ? Collections.emptySet() : new HashSet<IgniteTxEntry>(this.txMap.values());
    }

    @Override
    public IgniteTxEntry entry(IgniteTxKey key) {
        return this.txMap == null ? null : this.txMap.get(key);
    }

    @Override
    public boolean hasWriteKey(IgniteTxKey key) {
        return this.writeView.containsKey(key);
    }

    @Override
    public Set<IgniteTxKey> readSet() {
        return this.txMap == null ? Collections.emptySet() : this.readView.keySet();
    }

    @Override
    public Set<IgniteTxKey> writeSet() {
        return this.txMap == null ? Collections.emptySet() : this.writeView.keySet();
    }

    @Override
    public Collection<IgniteTxEntry> writeEntries() {
        return this.writeView == null ? Collections.emptyList() : this.writeView.values();
    }

    @Override
    public Collection<IgniteTxEntry> readEntries() {
        return this.readView == null ? Collections.emptyList() : this.readView.values();
    }

    @Override
    public Map<IgniteTxKey, IgniteTxEntry> writeMap() {
        return this.writeView == null ? Collections.emptyMap() : this.writeView;
    }

    @Override
    public Map<IgniteTxKey, IgniteTxEntry> readMap() {
        return this.readView == null ? Collections.emptyMap() : this.readView;
    }

    @Override
    public boolean empty() {
        return this.txMap.isEmpty();
    }

    @Override
    public synchronized void addEntry(IgniteTxEntry entry) {
        this.txMap.put(entry.txKey(), entry);
    }

    @Override
    public void seal() {
        if (this.readView != null) {
            this.readView.seal();
        }
        if (this.writeView != null) {
            this.writeView.seal();
        }
    }

    @Override
    public IgniteTxEntry singleWrite() {
        return this.writeView != null && this.writeView.size() == 1 ? F.firstValue(this.writeView) : null;
    }

    public String toString() {
        return S.toString(IgniteTxStateImpl.class, this);
    }
}

