/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.transactions.TransactionMetrics;

public class TransactionMetricsAdapter
implements TransactionMetrics,
Externalizable {
    private static final long serialVersionUID = 0L;
    private volatile int txCommits;
    private volatile int txRollbacks;
    private volatile long commitTime;
    private volatile long rollbackTime;

    public TransactionMetricsAdapter() {
    }

    public TransactionMetricsAdapter(TransactionMetrics m) {
        this.commitTime = m.commitTime();
        this.rollbackTime = m.rollbackTime();
        this.txCommits = m.txCommits();
        this.txRollbacks = m.txRollbacks();
    }

    @Override
    public long commitTime() {
        return this.commitTime;
    }

    @Override
    public long rollbackTime() {
        return this.rollbackTime;
    }

    @Override
    public int txCommits() {
        return this.txCommits;
    }

    @Override
    public int txRollbacks() {
        return this.txRollbacks;
    }

    public void onTxCommit() {
        this.commitTime = U.currentTimeMillis();
        ++this.txCommits;
    }

    public void onTxRollback() {
        this.rollbackTime = U.currentTimeMillis();
        ++this.txRollbacks;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.commitTime);
        out.writeLong(this.rollbackTime);
        out.writeInt(this.txCommits);
        out.writeInt(this.txRollbacks);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.commitTime = in.readLong();
        this.rollbackTime = in.readLong();
        this.txCommits = in.readInt();
        this.txRollbacks = in.readInt();
    }

    public String toString() {
        return S.toString(TransactionMetricsAdapter.class, this);
    }
}

