/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class TxLocksRequest
extends GridCacheMessage {
    private static final long serialVersionUID = 0L;
    private long futId;
    @GridToStringInclude
    @GridDirectTransient
    private Set<IgniteTxKey> txKeys;
    @GridToStringExclude
    private IgniteTxKey[] txKeysArr;

    public TxLocksRequest() {
    }

    public TxLocksRequest(long futId, Set<IgniteTxKey> txKeys) {
        A.notEmpty(txKeys, "txKeys");
        this.futId = futId;
        this.txKeys = txKeys;
    }

    public long futureId() {
        return this.futId;
    }

    public Collection<IgniteTxKey> txKeys() {
        return this.txKeys;
    }

    @Override
    public String toString() {
        return S.toString(TxLocksRequest.class, this);
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        this.txKeysArr = new IgniteTxKey[this.txKeys.size()];
        int i = 0;
        for (IgniteTxKey key : this.txKeys) {
            key.prepareMarshal(ctx.cacheContext(key.cacheId()));
            this.txKeysArr[i++] = key;
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        this.txKeys = U.newHashSet(this.txKeysArr.length);
        for (IgniteTxKey key : this.txKeysArr) {
            key.finishUnmarshal(ctx.cacheContext(key.cacheId()), ldr);
            this.txKeys.add(key);
        }
        this.txKeysArr = null;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeObjectArray("txKeysArr", this.txKeysArr, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.txKeysArr = reader.readObjectArray("txKeysArr", MessageCollectionItemType.MSG, IgniteTxKey.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxLocksRequest.class);
    }

    @Override
    public byte directType() {
        return -24;
    }

    @Override
    public byte fieldsCount() {
        return 5;
    }

    @Override
    public void onAckReceived() {
    }
}

