/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.version;

import org.apache.ignite.internal.processors.cache.version.GridCacheVersionedEntry;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridCacheVersionConflictContext<K, V> {
    @GridToStringInclude
    private final GridCacheVersionedEntry<K, V> oldEntry;
    @GridToStringInclude
    private final GridCacheVersionedEntry<K, V> newEntry;
    private State state;
    @GridToStringExclude
    private V mergeVal;
    private long ttl;
    private boolean manualResolve;

    public GridCacheVersionConflictContext(GridCacheVersionedEntry<K, V> oldEntry, GridCacheVersionedEntry<K, V> newEntry) {
        assert (oldEntry != null && newEntry != null);
        assert (oldEntry.ttl() >= 0L && newEntry.ttl() >= 0L);
        this.oldEntry = oldEntry;
        this.newEntry = newEntry;
        this.useNew();
    }

    public GridCacheVersionedEntry<K, V> oldEntry() {
        return this.oldEntry;
    }

    public GridCacheVersionedEntry<K, V> newEntry() {
        return this.newEntry;
    }

    public void useOld() {
        this.state = State.USE_OLD;
    }

    public void useNew() {
        this.state = State.USE_NEW;
        this.ttl = this.newEntry.ttl();
    }

    public void merge(@Nullable V mergeVal, long ttl) {
        if (ttl < 0L) {
            throw new IllegalArgumentException("TTL must be non-negative: " + ttl);
        }
        this.state = State.MERGE;
        this.mergeVal = mergeVal;
        this.ttl = ttl;
    }

    public boolean isUseOld() {
        return this.state == State.USE_OLD;
    }

    public boolean isUseNew() {
        return this.state == State.USE_NEW;
    }

    public boolean isMerge() {
        return this.state == State.MERGE;
    }

    public void manualResolve() {
        this.manualResolve = true;
    }

    public boolean isManualResolve() {
        return this.manualResolve;
    }

    @Nullable
    public V mergeValue() {
        return this.mergeVal;
    }

    public long ttl() {
        return this.ttl;
    }

    public long expireTime() {
        return this.isUseNew() ? this.newEntry.expireTime() : (this.isUseOld() ? this.oldEntry.expireTime() : CU.toExpireTime(this.ttl));
    }

    public String toString() {
        return this.state == State.MERGE ? S.toString(GridCacheVersionConflictContext.class, this, "mergeValue", this.mergeVal, true) : S.toString(GridCacheVersionConflictContext.class, this);
    }

    private static enum State {
        USE_OLD,
        USE_NEW,
        MERGE;

    }
}

