/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cacheobject;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMemoryMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectByteArrayImpl;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectImpl;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDefaultAffinityKeyMapper;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObjectImpl;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.cacheobject.NoOpBinary;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class IgniteCacheObjectProcessorImpl
extends GridProcessorAdapter
implements IgniteCacheObjectProcessor {
    private static final Collection<Class<?>> IMMUTABLE_CLS = new HashSet();
    private IgniteBinary noOpBinary = new NoOpBinary();

    public IgniteCacheObjectProcessorImpl(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public String affinityField(String keyType) {
        return null;
    }

    @Override
    public IgniteBinary binary() {
        return this.noOpBinary;
    }

    @Override
    @Nullable
    public CacheObject prepareForCache(@Nullable CacheObject obj, GridCacheContext cctx) {
        if (obj == null) {
            return null;
        }
        return obj.prepareForCache(cctx.cacheObjectContext());
    }

    @Override
    public byte[] marshal(CacheObjectContext ctx, Object val) throws IgniteCheckedException {
        return CU.marshal(ctx.kernalContext().cache().context(), ctx.addDeploymentInfo(), val);
    }

    @Override
    public Object unmarshal(CacheObjectContext ctx, byte[] bytes, ClassLoader clsLdr) throws IgniteCheckedException {
        return U.unmarshal(ctx.kernalContext(), bytes, U.resolveClassLoader(clsLdr, ctx.kernalContext().config()));
    }

    @Override
    public KeyCacheObject toCacheKeyObject(CacheObjectContext ctx, @Nullable GridCacheContext cctx, Object obj, boolean userObj) {
        if (obj instanceof KeyCacheObject) {
            KeyCacheObject key = (KeyCacheObject)obj;
            if (key.partition() == -1) {
                key.partition(this.partition(ctx, cctx, key));
            }
            return (KeyCacheObject)obj;
        }
        return this.toCacheKeyObject0(ctx, cctx, obj, userObj);
    }

    protected KeyCacheObject toCacheKeyObject0(CacheObjectContext ctx, @Nullable GridCacheContext cctx, Object obj, boolean userObj) {
        int part = this.partition(ctx, cctx, obj);
        if (!userObj) {
            return new KeyCacheObjectImpl(obj, null, part);
        }
        return new UserKeyCacheObjectImpl(obj, part);
    }

    @Override
    public CacheObject toCacheObject(GridCacheContext ctx, long valPtr, boolean tmp) throws IgniteCheckedException {
        assert (valPtr != 0L);
        int size = GridUnsafe.getInt(valPtr);
        byte type = GridUnsafe.getByte(valPtr + 4L);
        byte[] bytes = U.copyMemory(valPtr + 5L, size);
        if (ctx.kernalContext().config().isPeerClassLoadingEnabled() && ctx.offheapTiered() && type != 2) {
            IgniteUuid valClsLdrId = U.readGridUuid(valPtr + 5L + (long)size);
            ClassLoader ldr = valClsLdrId != null ? ctx.deploy().getClassLoader(valClsLdrId) : ctx.deploy().localLoader();
            return this.toCacheObject(ctx.cacheObjectContext(), this.unmarshal(ctx.cacheObjectContext(), bytes, ldr), false);
        }
        return this.toCacheObject(ctx.cacheObjectContext(), type, bytes);
    }

    @Override
    public CacheObject toCacheObject(CacheObjectContext ctx, byte type, byte[] bytes) {
        switch (type) {
            case 2: {
                return new CacheObjectByteArrayImpl(bytes);
            }
            case 1: {
                return new CacheObjectImpl(null, bytes);
            }
        }
        throw new IllegalArgumentException("Invalid object type: " + type);
    }

    @Override
    @Nullable
    public CacheObject toCacheObject(CacheObjectContext ctx, @Nullable Object obj, boolean userObj) {
        if (obj == null || obj instanceof CacheObject) {
            return (CacheObject)obj;
        }
        return this.toCacheObject0(obj, userObj);
    }

    protected CacheObject toCacheObject0(@Nullable Object obj, boolean userObj) {
        assert (obj != null);
        if (obj instanceof byte[]) {
            if (!userObj) {
                return new CacheObjectByteArrayImpl((byte[])obj);
            }
            return new UserCacheObjectByteArrayImpl((byte[])obj);
        }
        if (!userObj) {
            return new CacheObjectImpl(obj, null);
        }
        return new UserCacheObjectImpl(obj, null);
    }

    protected final int partition(CacheObjectContext ctx, @Nullable GridCacheContext cctx, Object obj) {
        try {
            return cctx != null ? cctx.affinity().partition(obj, false) : ctx.kernalContext().affinity().partition0(ctx.cacheName(), obj, null);
        }
        catch (IgniteCheckedException ignored) {
            U.error(this.log, "Failed to get partition");
            return -1;
        }
    }

    @Override
    public CacheObjectContext contextForCache(CacheConfiguration ccfg) throws IgniteCheckedException {
        assert (ccfg != null);
        CacheMemoryMode memMode = ccfg.getMemoryMode();
        boolean storeVal = !ccfg.isCopyOnRead() || !this.isBinaryEnabled(ccfg) && (GridQueryProcessor.isEnabled(ccfg) || this.ctx.config().isPeerClassLoadingEnabled());
        CacheObjectContext res = new CacheObjectContext(this.ctx, ccfg.getName(), ccfg.getAffinityMapper() != null ? ccfg.getAffinityMapper() : new GridCacheDefaultAffinityKeyMapper(), ccfg.isCopyOnRead() && memMode != CacheMemoryMode.OFFHEAP_VALUES, storeVal, this.ctx.config().isPeerClassLoadingEnabled() && !this.isBinaryEnabled(ccfg));
        this.ctx.resource().injectGeneric(res.defaultAffMapper());
        return res;
    }

    @Override
    public boolean immutable(Object obj) {
        assert (obj != null);
        return IMMUTABLE_CLS.contains(obj.getClass());
    }

    @Override
    public void onContinuousProcessorStarted(GridKernalContext ctx) throws IgniteCheckedException {
    }

    @Override
    public void onUtilityCacheStarted() throws IgniteCheckedException {
    }

    @Override
    public int typeId(String typeName) {
        return 0;
    }

    @Override
    public Object unwrapTemporary(GridCacheContext ctx, Object obj) throws IgniteException {
        return obj;
    }

    @Override
    public boolean isBinaryObject(Object obj) {
        return false;
    }

    @Override
    public boolean isBinaryEnabled(CacheConfiguration<?, ?> ccfg) {
        return false;
    }

    @Override
    public int typeId(Object obj) {
        return 0;
    }

    @Override
    public Object field(Object obj, String fieldName) {
        return null;
    }

    @Override
    public boolean hasField(Object obj, String fieldName) {
        return false;
    }

    static {
        IMMUTABLE_CLS.add(String.class);
        IMMUTABLE_CLS.add(Boolean.class);
        IMMUTABLE_CLS.add(Byte.class);
        IMMUTABLE_CLS.add(Short.class);
        IMMUTABLE_CLS.add(Character.class);
        IMMUTABLE_CLS.add(Integer.class);
        IMMUTABLE_CLS.add(Long.class);
        IMMUTABLE_CLS.add(Float.class);
        IMMUTABLE_CLS.add(Double.class);
        IMMUTABLE_CLS.add(UUID.class);
        IMMUTABLE_CLS.add(IgniteUuid.class);
        IMMUTABLE_CLS.add(BigDecimal.class);
    }

    private static class UserCacheObjectByteArrayImpl
    extends CacheObjectByteArrayImpl {
        private static final long serialVersionUID = 0L;

        public UserCacheObjectByteArrayImpl() {
        }

        public UserCacheObjectByteArrayImpl(byte[] val) {
            super(val);
        }

        @Override
        @Nullable
        public <T> T value(CacheObjectContext ctx, boolean cpy) {
            return super.value(ctx, false);
        }

        @Override
        public CacheObject prepareForCache(CacheObjectContext ctx) {
            byte[] valCpy = Arrays.copyOf(this.val, this.val.length);
            return new CacheObjectByteArrayImpl(valCpy);
        }
    }

    private static class UserCacheObjectImpl
    extends CacheObjectImpl {
        private static final long serialVersionUID = 0L;

        public UserCacheObjectImpl() {
        }

        public UserCacheObjectImpl(Object val, byte[] valBytes) {
            super(val, valBytes);
        }

        @Override
        @Nullable
        public <T> T value(CacheObjectContext ctx, boolean cpy) {
            return super.value(ctx, false);
        }

        @Override
        public CacheObject prepareForCache(CacheObjectContext ctx) {
            try {
                if (this.valBytes == null) {
                    this.valBytes = ctx.processor().marshal(ctx, this.val);
                }
                if (ctx.storeValue()) {
                    ClassLoader ldr = ctx.p2pEnabled() ? IgniteUtils.detectClass(this.val).getClassLoader() : this.val.getClass().getClassLoader();
                    Object val = this.val != null && ctx.processor().immutable(this.val) ? this.val : ctx.processor().unmarshal(ctx, this.valBytes, ldr);
                    return new CacheObjectImpl(val, this.valBytes);
                }
                return new CacheObjectImpl(null, this.valBytes);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to marshal object: " + this.val, e);
            }
        }
    }

    private static class UserKeyCacheObjectImpl
    extends KeyCacheObjectImpl {
        private static final long serialVersionUID = 0L;

        public UserKeyCacheObjectImpl() {
        }

        UserKeyCacheObjectImpl(Object key) {
            this(key, -1);
        }

        UserKeyCacheObjectImpl(Object key, int part) {
            super(key, null, part);
        }

        UserKeyCacheObjectImpl(Object key, byte[] valBytes, int part) {
            super(key, valBytes, part);
        }

        @Override
        public KeyCacheObject copy(int part) {
            if (this.partition() == part) {
                return this;
            }
            return new UserKeyCacheObjectImpl(this.val, this.valBytes, part);
        }

        @Override
        public CacheObject prepareForCache(CacheObjectContext ctx) {
            try {
                if (!ctx.processor().immutable(this.val)) {
                    if (this.valBytes == null) {
                        this.valBytes = ctx.processor().marshal(ctx, this.val);
                    }
                    ClassLoader ldr = ctx.p2pEnabled() ? IgniteUtils.detectClassLoader(IgniteUtils.detectClass(this.val)) : U.gridClassLoader();
                    Object val = ctx.processor().unmarshal(ctx, this.valBytes, ldr);
                    return new KeyCacheObjectImpl(val, this.valBytes);
                }
                return new KeyCacheObjectImpl(this.val, this.valBytes);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to marshal object: " + this.val, e);
            }
        }
    }
}

