/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.clock;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryTopologySnapshot;
import org.apache.ignite.internal.processors.clock.GridClockDeltaVersion;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridClockDeltaSnapshot {
    private final GridClockDeltaVersion ver;
    private final Map<UUID, Long> deltas;
    @GridToStringExclude
    private final Map<UUID, DeltaAverage> pendingDeltas;

    public GridClockDeltaSnapshot(GridClockDeltaVersion ver, UUID locNodeId, GridDiscoveryTopologySnapshot discoSnap, int avgSize) {
        assert (ver.topologyVersion() == discoSnap.topologyVersion());
        this.ver = ver;
        this.deltas = new HashMap<UUID, Long>(discoSnap.topologyNodes().size(), 1.0f);
        this.pendingDeltas = new HashMap<UUID, DeltaAverage>(discoSnap.topologyNodes().size(), 1.0f);
        for (ClusterNode n : discoSnap.topologyNodes()) {
            if (locNodeId.equals(n.id())) continue;
            this.pendingDeltas.put(n.id(), new DeltaAverage(avgSize));
        }
    }

    public GridClockDeltaSnapshot(GridClockDeltaVersion ver, Map<UUID, Long> deltas) {
        this.ver = ver;
        this.deltas = deltas;
        this.pendingDeltas = Collections.emptyMap();
    }

    public GridClockDeltaVersion version() {
        return this.ver;
    }

    public Map<UUID, Long> deltas() {
        return Collections.unmodifiableMap(this.deltas);
    }

    public synchronized void awaitReady(long timeout) throws IgniteInterruptedCheckedException {
        long start = System.currentTimeMillis();
        try {
            while (!this.ready()) {
                long now = System.currentTimeMillis();
                if (start + timeout - now <= 0L) {
                    return;
                }
                this.wait(start + timeout - now);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
    }

    public synchronized boolean onDeltaReceived(UUID nodeId, long timeDelta) {
        DeltaAverage avg = this.pendingDeltas.get(nodeId);
        if (avg != null) {
            avg.onValue(timeDelta);
            if (avg.ready()) {
                this.pendingDeltas.remove(nodeId);
                this.deltas.put(nodeId, avg.average());
                if (this.ready()) {
                    this.notifyAll();
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public synchronized void onNodeLeft(UUID nodeId) {
        this.pendingDeltas.remove(nodeId);
        this.deltas.put(nodeId, 0L);
        if (this.ready()) {
            this.notifyAll();
        }
    }

    public synchronized boolean ready() {
        return this.pendingDeltas.isEmpty();
    }

    public synchronized Collection<UUID> pendingNodeIds() {
        return new HashSet<UUID>(this.pendingDeltas.keySet());
    }

    public String toString() {
        return S.toString(GridClockDeltaSnapshot.class, this);
    }

    private static class DeltaAverage {
        private long[] vals;
        private int idx;

        private DeltaAverage(int size) {
            this.vals = new long[size];
        }

        public void onValue(long val) {
            if (this.idx < this.vals.length) {
                this.vals[this.idx++] = val;
            }
        }

        public boolean ready() {
            return this.idx == this.vals.length;
        }

        public long average() {
            long sum = 0L;
            for (long val : this.vals) {
                sum += val;
            }
            return sum / (long)this.vals.length;
        }
    }
}

