/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.clock;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.processors.clock.GridClockDeltaVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridClockDeltaSnapshotMessage
implements Message {
    private static final long serialVersionUID = 0L;
    private GridClockDeltaVersion snapVer;
    @GridToStringInclude
    @GridDirectMap(keyType=UUID.class, valueType=long.class)
    private Map<UUID, Long> deltas;

    public GridClockDeltaSnapshotMessage() {
    }

    public GridClockDeltaSnapshotMessage(GridClockDeltaVersion snapVer, Map<UUID, Long> deltas) {
        this.snapVer = snapVer;
        this.deltas = deltas;
    }

    public GridClockDeltaVersion snapshotVersion() {
        return this.snapVer;
    }

    public Map<UUID, Long> deltas() {
        return this.deltas;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeMap("deltas", this.deltas, MessageCollectionItemType.UUID, MessageCollectionItemType.LONG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeMessage("snapVer", this.snapVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.deltas = reader.readMap("deltas", MessageCollectionItemType.UUID, MessageCollectionItemType.LONG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.snapVer = (GridClockDeltaVersion)reader.readMessage("snapVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridClockDeltaSnapshotMessage.class);
    }

    @Override
    public byte directType() {
        return 60;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    public String toString() {
        return S.toString(GridClockDeltaSnapshotMessage.class, this);
    }
}

