/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.clock;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridClockDeltaVersion
implements Message,
Comparable<GridClockDeltaVersion>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private long ver;
    private long topVer;

    public GridClockDeltaVersion() {
    }

    public GridClockDeltaVersion(long ver, long topVer) {
        this.ver = ver;
        this.topVer = topVer;
    }

    public long version() {
        return this.ver;
    }

    public long topologyVersion() {
        return this.topVer;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public int compareTo(GridClockDeltaVersion o) {
        int res = Long.compare(this.topVer, o.topVer);
        if (res == 0) {
            res = Long.compare(this.ver, o.ver);
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GridClockDeltaVersion)) {
            return false;
        }
        GridClockDeltaVersion that = (GridClockDeltaVersion)o;
        return this.topVer == that.topVer && this.ver == that.ver;
    }

    public int hashCode() {
        int res = (int)(this.ver ^ this.ver >>> 32);
        res = 31 * res + (int)(this.topVer ^ this.topVer >>> 32);
        return res;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.ver);
        out.writeLong(this.topVer);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ver = in.readLong();
        this.topVer = in.readLong();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeLong("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("ver", this.ver)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.topVer = reader.readLong("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.ver = reader.readLong("ver");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridClockDeltaVersion.class);
    }

    @Override
    public byte directType() {
        return 83;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    public String toString() {
        return S.toString(GridClockDeltaVersion.class, this);
    }
}

