/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.clock;

import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridClockMessage {
    public static final int PACKET_SIZE = 48;
    private UUID origNodeId;
    private UUID targetNodeId;
    private long origTs;
    private long replyTs;

    public GridClockMessage(UUID origNodeId, UUID targetNodeId, long origTs, long replyTs) {
        this.origNodeId = origNodeId;
        this.targetNodeId = targetNodeId;
        this.origTs = origTs;
        this.replyTs = replyTs;
    }

    public UUID originatingNodeId() {
        return this.origNodeId;
    }

    public void originatingNodeId(UUID origNodeId) {
        this.origNodeId = origNodeId;
    }

    public UUID targetNodeId() {
        return this.targetNodeId;
    }

    public void targetNodeId(UUID targetNodeId) {
        this.targetNodeId = targetNodeId;
    }

    public long originatingTimestamp() {
        return this.origTs;
    }

    public void originatingTimestamp(long origTs) {
        this.origTs = origTs;
    }

    public long replyTimestamp() {
        return this.replyTs;
    }

    public void replyTimestamp(long replyTs) {
        this.replyTs = replyTs;
    }

    public byte[] toBytes() {
        byte[] buf = new byte[48];
        int off = 0;
        off = U.longToBytes(this.origNodeId.getLeastSignificantBits(), buf, off);
        off = U.longToBytes(this.origNodeId.getMostSignificantBits(), buf, off);
        off = U.longToBytes(this.targetNodeId.getLeastSignificantBits(), buf, off);
        off = U.longToBytes(this.targetNodeId.getMostSignificantBits(), buf, off);
        off = U.longToBytes(this.origTs, buf, off);
        off = U.longToBytes(this.replyTs, buf, off);
        assert (off == 48);
        return buf;
    }

    public static GridClockMessage fromBytes(byte[] buf, int off, int len) throws IgniteCheckedException {
        if (len < 48) {
            throw new IgniteCheckedException("Failed to assemble time server packet (message is too short).");
        }
        long lsb = U.bytesToLong(buf, off);
        long msb = U.bytesToLong(buf, off + 8);
        UUID origNodeId = new UUID(msb, lsb);
        lsb = U.bytesToLong(buf, off + 16);
        msb = U.bytesToLong(buf, off + 24);
        UUID targetNodeId = new UUID(msb, lsb);
        long origTs = U.bytesToLong(buf, off + 32);
        long replyTs = U.bytesToLong(buf, off + 40);
        return new GridClockMessage(origNodeId, targetNodeId, origTs, replyTs);
    }

    public String toString() {
        return S.toString(GridClockMessage.class, this);
    }
}

