/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.clock;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.clock.GridClockMessage;
import org.apache.ignite.internal.processors.clock.GridClockSyncProcessor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;

public class GridClockServer {
    private GridKernalContext ctx;
    private DatagramSocket sock;
    private IgniteLogger log;
    private GridWorker readWorker;
    private GridClockSyncProcessor clockSync;

    public void start(GridKernalContext ctx) throws IgniteCheckedException {
        this.ctx = ctx;
        this.clockSync = ctx.clockSync();
        this.log = ctx.log(GridClockServer.class);
        try {
            InetAddress locHost;
            int endPort;
            int startPort = ctx.config().getTimeServerPortBase();
            int portRange = ctx.config().getTimeServerPortRange();
            int n = endPort = portRange == 0 ? startPort : startPort + portRange - 1;
            if (F.isEmpty(ctx.config().getLocalHost())) {
                try {
                    locHost = U.getLocalHost();
                }
                catch (IOException ignored) {
                    locHost = InetAddress.getLoopbackAddress();
                    U.warn(this.log, "Failed to get local host address, will use loopback address: " + locHost);
                }
            } else {
                locHost = InetAddress.getByName(ctx.config().getLocalHost());
            }
            for (int p = startPort; p <= endPort; ++p) {
                try {
                    this.sock = new DatagramSocket(p, locHost);
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Successfully bound time server [host=" + locHost + ", port=" + p + ']');
                    break;
                }
                catch (SocketException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Failed to bind time server socket [host=" + locHost + ", port=" + p + ", err=" + e.getMessage() + ']');
                    continue;
                }
            }
            if (this.sock == null) {
                throw new IgniteCheckedException("Failed to bind time server socket within specified port range [locHost=" + locHost + ", startPort=" + startPort + ", endPort=" + endPort + ']');
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to start time server (failed to get local host address)", e);
        }
    }

    public void afterStart() {
        this.readWorker = new ReadWorker();
        IgniteThread th = new IgniteThread(this.readWorker);
        th.setPriority(10);
        th.start();
    }

    public void stop() {
    }

    public void beforeStop() {
        if (this.readWorker != null) {
            this.readWorker.cancel();
        }
        U.closeQuiet(this.sock);
        if (this.readWorker != null) {
            U.join(this.readWorker, this.log);
        }
    }

    public void sendPacket(GridClockMessage msg, InetAddress addr, int port) throws IgniteCheckedException {
        block3: {
            try {
                DatagramPacket packet = new DatagramPacket(msg.toBytes(), 48, addr, port);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Sending time sync packet [msg=" + msg + ", addr=" + addr + ", port=" + port);
                }
                this.sock.send(packet);
            }
            catch (IOException e) {
                if (this.sock.isClosed()) break block3;
                throw new IgniteCheckedException("Failed to send datagram message to remote node [addr=" + addr + ", port=" + port + ", msg=" + msg + ']', e);
            }
        }
    }

    public InetAddress host() {
        return this.sock.getLocalAddress();
    }

    public int port() {
        return this.sock.getLocalPort();
    }

    private class ReadWorker
    extends GridWorker {
        protected ReadWorker() {
            super(GridClockServer.this.ctx.gridName(), "grid-time-server-reader", GridClockServer.this.log);
        }

        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            DatagramPacket packet = new DatagramPacket(new byte[48], 48);
            while (!this.isCancelled()) {
                try {
                    GridClockServer.this.sock.receive(packet);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Received clock sync message from remote node [host=" + packet.getAddress() + ", port=" + packet.getPort() + ']');
                    }
                    GridClockMessage msg = GridClockMessage.fromBytes(packet.getData(), packet.getOffset(), packet.getLength());
                    GridClockServer.this.clockSync.onMessageReceived(msg, packet.getAddress(), packet.getPort());
                }
                catch (IgniteCheckedException e) {
                    U.warn(this.log, "Failed to assemble clock server message (will ignore the packet) [host=" + packet.getAddress() + ", port=" + packet.getPort() + ", err=" + e.getMessage() + ']');
                }
                catch (IOException e) {
                    if (this.isCancelled()) continue;
                    U.warn(this.log, "Failed to receive message on datagram socket: " + e);
                }
            }
        }
    }
}

