/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgniteProperties;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.cluster.IgniteClusterImpl;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cluster.GridUpdateNotifier;
import org.apache.ignite.internal.util.GridTimerTask;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.lang.IgniteFuture;
import org.jetbrains.annotations.Nullable;

public class ClusterProcessor
extends GridProcessorAdapter {
    private static final String ATTR_UPDATE_NOTIFIER_STATUS = "UPDATE_NOTIFIER_STATUS";
    private static final long PERIODIC_VER_CHECK_DELAY = 3600000L;
    private static final long PERIODIC_VER_CHECK_CONN_TIMEOUT = 10000L;
    private IgniteClusterImpl cluster;
    private final AtomicBoolean notifyEnabled = new AtomicBoolean();
    @GridToStringExclude
    private Timer updateNtfTimer;
    @GridToStringExclude
    private GridUpdateNotifier verChecker;

    public ClusterProcessor(GridKernalContext ctx) {
        super(ctx);
        this.notifyEnabled.set(IgniteSystemProperties.getBoolean("IGNITE_UPDATE_NOTIFIER", Boolean.parseBoolean(IgniteProperties.get("ignite.update.notifier.enabled.by.default"))));
        this.cluster = new IgniteClusterImpl(ctx);
    }

    public IgniteClusterImpl get() {
        return this.cluster;
    }

    public IgniteFuture<?> clientReconnectFuture() {
        IgniteFinishedFutureImpl fut = this.cluster.clientReconnectFuture();
        return fut != null ? fut : new IgniteFinishedFutureImpl();
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.CLUSTER_PROC;
    }

    @Override
    @Nullable
    public Serializable collectDiscoveryData(UUID nodeId) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put(ATTR_UPDATE_NOTIFIER_STATUS, this.notifyEnabled.get());
        return map;
    }

    @Override
    public void onDiscoveryDataReceived(UUID joiningNodeId, UUID rmtNodeId, Serializable data) {
        Map map;
        if (joiningNodeId.equals(this.ctx.localNodeId()) && (map = (Map)((Object)data)) != null && map.containsKey(ATTR_UPDATE_NOTIFIER_STATUS)) {
            this.notifyEnabled.set((Boolean)map.get(ATTR_UPDATE_NOTIFIER_STATUS));
        }
    }

    @Override
    public void onKernalStart() throws IgniteCheckedException {
        block3: {
            if (this.notifyEnabled.get()) {
                try {
                    this.verChecker = new GridUpdateNotifier(this.ctx.gridName(), IgniteVersionUtils.VER_STR, this.ctx.gateway(), this.ctx.plugins().allProviders(), false);
                    this.updateNtfTimer = new Timer("ignite-update-notifier-timer", true);
                    this.updateNtfTimer.scheduleAtFixedRate((TimerTask)new UpdateNotifierTimerTask((IgniteKernal)this.ctx.grid(), this.verChecker, this.notifyEnabled), 0L, 3600000L);
                }
                catch (IgniteCheckedException e) {
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug("Failed to create GridUpdateNotifier: " + e);
                }
            }
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        if (this.updateNtfTimer != null) {
            this.updateNtfTimer.cancel();
        }
        if (this.verChecker != null) {
            this.verChecker.stop();
        }
    }

    public void disableUpdateNotifier() {
        this.notifyEnabled.set(false);
    }

    public boolean updateNotifierEnabled() {
        return this.notifyEnabled.get();
    }

    public String latestVersion() {
        return this.verChecker != null ? this.verChecker.latestVersion() : null;
    }

    private static class UpdateNotifierTimerTask
    extends GridTimerTask {
        private final WeakReference<IgniteKernal> kernalRef;
        private final IgniteLogger log;
        private final GridUpdateNotifier verChecker;
        private boolean first = true;
        private final AtomicBoolean notifyEnabled;

        private UpdateNotifierTimerTask(IgniteKernal kernal, GridUpdateNotifier verChecker, AtomicBoolean notifyEnabled) {
            this.kernalRef = new WeakReference<IgniteKernal>(kernal);
            this.log = kernal.context().log(UpdateNotifierTimerTask.class);
            this.verChecker = verChecker;
            this.notifyEnabled = notifyEnabled;
        }

        @Override
        public void safeRun() throws InterruptedException {
            IgniteKernal kernal;
            if (!this.notifyEnabled.get()) {
                return;
            }
            if (!this.first && (kernal = (IgniteKernal)this.kernalRef.get()) != null) {
                this.verChecker.topologySize(kernal.cluster().nodes().size());
            }
            this.verChecker.checkForNewVersion(this.log);
            Thread.sleep(10000L);
            for (int i = 0; i < 60 && this.verChecker.latestVersion() == null; ++i) {
                Thread.sleep(1000L);
            }
            this.verChecker.reportStatus(this.log);
            if (this.first) {
                this.first = false;
                this.verChecker.reportOnlyNew(true);
            }
        }
    }
}

