/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.GridKernalGateway;
import org.apache.ignite.internal.IgniteProperties;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.plugin.PluginProvider;
import org.jetbrains.annotations.Nullable;

class GridUpdateNotifier {
    private static final String CHARSET = "UTF-8";
    private final String UPD_STATUS_PARAMS = IgniteProperties.get("ignite.update.status.params");
    private static final long THROTTLE_PERIOD = 86400000L;
    private static final int WORKER_THREAD_SLEEP_TIME = 5000;
    private static final String UPDATE_NOTIFIER_URL = "https://ignite.run/update_status_ignite-plain-text.php";
    private final String ver;
    private volatile String latestVer;
    private volatile String downloadUrl;
    private final String gridName;
    private volatile boolean reportOnlyNew;
    private volatile int topSize;
    private final String vmProps;
    private final String pluginsVers;
    private final GridKernalGateway gw;
    private long lastLog = -1L;
    private final AtomicReference<Runnable> cmd = new AtomicReference();
    private final Thread workerThread;

    GridUpdateNotifier(String gridName, String ver, GridKernalGateway gw, Collection<PluginProvider> pluginProviders, boolean reportOnlyNew) throws IgniteCheckedException {
        try {
            this.ver = ver;
            this.gridName = gridName == null ? "null" : gridName;
            this.gw = gw;
            SB pluginsBuilder = new SB();
            for (PluginProvider provider : pluginProviders) {
                pluginsBuilder.a("&").a(provider.name() + "-plugin-version").a("=").a(URLEncoder.encode(provider.version(), CHARSET));
            }
            this.pluginsVers = pluginsBuilder.toString();
            this.reportOnlyNew = reportOnlyNew;
            this.vmProps = GridUpdateNotifier.getSystemProperties();
            this.workerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (!Thread.currentThread().isInterrupted()) {
                            Runnable cmd0 = GridUpdateNotifier.this.cmd.getAndSet(null);
                            if (cmd0 != null) {
                                cmd0.run();
                                continue;
                            }
                            Thread.sleep(5000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }, "upd-ver-checker");
            this.workerThread.setDaemon(true);
            this.workerThread.start();
        }
        catch (UnsupportedEncodingException e) {
            throw new IgniteCheckedException("Failed to encode.", e);
        }
    }

    private static String getSystemProperties() {
        try {
            StringWriter sw = new StringWriter();
            try {
                IgniteSystemProperties.safeSnapshot().store(new PrintWriter(sw), "");
            }
            catch (IOException ignore) {
                return null;
            }
            return sw.toString();
        }
        catch (SecurityException ignore) {
            return null;
        }
    }

    void reportOnlyNew(boolean reportOnlyNew) {
        this.reportOnlyNew = reportOnlyNew;
    }

    void topologySize(int topSize) {
        this.topSize = topSize;
    }

    String latestVersion() {
        return this.latestVer;
    }

    void checkForNewVersion(IgniteLogger log) {
        assert (log != null);
        log = log.getLogger(this.getClass());
        try {
            this.cmd.set(new UpdateChecker(log));
        }
        catch (RejectedExecutionException e) {
            U.error(log, "Failed to schedule a thread due to execution rejection (safely ignoring): " + e.getMessage());
        }
    }

    void reportStatus(IgniteLogger log) {
        assert (log != null);
        log = log.getLogger(this.getClass());
        String latestVer = this.latestVer;
        String downloadUrl = this.downloadUrl;
        String string = downloadUrl = downloadUrl != null ? downloadUrl : "ignite.apache.org";
        if (latestVer != null) {
            if (latestVer.equals(this.ver)) {
                if (!this.reportOnlyNew) {
                    this.throttle(log, false, "Your version is up to date.");
                }
            } else {
                this.throttle(log, true, "New version is available at " + downloadUrl + ": " + latestVer);
            }
        } else if (!this.reportOnlyNew) {
            this.throttle(log, false, "Update status is not available.");
        }
    }

    private void throttle(IgniteLogger log, boolean warn, String msg) {
        assert (log != null);
        assert (msg != null);
        long now = U.currentTimeMillis();
        if (now - this.lastLog > 86400000L) {
            if (!warn) {
                U.log(log, msg);
            } else {
                U.quiet(true, msg);
                if (log.isInfoEnabled()) {
                    log.warning(msg);
                }
            }
            this.lastLog = now;
        }
    }

    public void stop() {
        this.workerThread.interrupt();
    }

    private class UpdateChecker
    extends GridWorker {
        private final IgniteLogger log;

        UpdateChecker(IgniteLogger log) {
            super(GridUpdateNotifier.this.gridName, "grid-version-checker", log);
            this.log = log.getLogger(this.getClass());
        }

        @Override
        protected void body() throws InterruptedException {
            block35: {
                try {
                    String stackTrace = GridUpdateNotifier.this.gw != null ? GridUpdateNotifier.this.gw.userStackTrace() : null;
                    String postParams = "gridName=" + URLEncoder.encode(GridUpdateNotifier.this.gridName, GridUpdateNotifier.CHARSET) + (!F.isEmpty(GridUpdateNotifier.this.UPD_STATUS_PARAMS) ? "&" + GridUpdateNotifier.this.UPD_STATUS_PARAMS : "") + (GridUpdateNotifier.this.topSize > 0 ? "&topSize=" + GridUpdateNotifier.this.topSize : "") + (!F.isEmpty(stackTrace) ? "&stackTrace=" + URLEncoder.encode(stackTrace, GridUpdateNotifier.CHARSET) : "") + (!F.isEmpty(GridUpdateNotifier.this.vmProps) ? "&vmProps=" + URLEncoder.encode(GridUpdateNotifier.this.vmProps, GridUpdateNotifier.CHARSET) : "") + GridUpdateNotifier.this.pluginsVers;
                    URLConnection conn = new URL(GridUpdateNotifier.UPDATE_NOTIFIER_URL).openConnection();
                    if (this.isCancelled()) break block35;
                    conn.setDoOutput(true);
                    conn.setRequestProperty("Accept-Charset", GridUpdateNotifier.CHARSET);
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                    conn.setConnectTimeout(3000);
                    conn.setReadTimeout(3000);
                    try {
                        try (OutputStream os = conn.getOutputStream();){
                            os.write(postParams.getBytes(GridUpdateNotifier.CHARSET));
                        }
                        var5_7 = null;
                        try (InputStream in = conn.getInputStream();){
                            String line;
                            if (in == null) {
                                return;
                            }
                            BufferedReader reader = new BufferedReader(new InputStreamReader(in, GridUpdateNotifier.CHARSET));
                            while ((line = reader.readLine()) != null) {
                                if (line.contains("version")) {
                                    GridUpdateNotifier.this.latestVer = this.obtainVersionFrom(line);
                                    continue;
                                }
                                if (!line.contains("downloadUrl")) continue;
                                GridUpdateNotifier.this.downloadUrl = this.obtainDownloadUrlFrom(line);
                            }
                        }
                        catch (Throwable throwable) {
                            var5_7 = throwable;
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Failed to connect to Ignite update server. " + e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.log.isDebugEnabled()) break block35;
                    this.log.debug("Unexpected exception in update checker. " + e.getMessage());
                }
            }
        }

        @Nullable
        private String obtainMeta(String metaName, String line) {
            assert (line.contains(metaName));
            return line.substring(line.indexOf(metaName) + metaName.length()).trim();
        }

        @Nullable
        private String obtainVersionFrom(String line) {
            return this.obtainMeta("version=", line);
        }

        @Nullable
        private String obtainDownloadUrlFrom(String line) {
            return this.obtainMeta("downloadUrl=", line);
        }
    }
}

