/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.continuous;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.processors.continuous.AbstractContinuousMessage;
import org.apache.ignite.internal.processors.continuous.StartRequestData;
import org.apache.ignite.internal.processors.continuous.StartRoutineAckDiscoveryMessage;
import org.apache.ignite.internal.util.typedef.internal.S;

public class StartRoutineDiscoveryMessage
extends AbstractContinuousMessage {
    private static final long serialVersionUID = 0L;
    private final StartRequestData startReqData;
    private final Map<UUID, IgniteCheckedException> errs = new HashMap<UUID, IgniteCheckedException>();
    private Map<Integer, Long> updateCntrs;
    private Map<UUID, Map<Integer, Long>> updateCntrsPerNode;
    private boolean keepBinary;

    public StartRoutineDiscoveryMessage(UUID routineId, StartRequestData startReqData, boolean keepBinary) {
        super(routineId);
        this.startReqData = startReqData;
        this.keepBinary = keepBinary;
    }

    public StartRequestData startRequestData() {
        return this.startReqData;
    }

    public void addError(UUID nodeId, IgniteCheckedException e) {
        this.errs.put(nodeId, e);
    }

    private void addUpdateCounters(Map<Integer, Long> cntrs) {
        if (this.updateCntrs == null) {
            this.updateCntrs = new HashMap<Integer, Long>();
        }
        for (Map.Entry<Integer, Long> e : cntrs.entrySet()) {
            Long cntr0 = this.updateCntrs.get(e.getKey());
            Long cntr1 = e.getValue();
            if (cntr0 != null && cntr1 <= cntr0) continue;
            this.updateCntrs.put(e.getKey(), cntr1);
        }
    }

    public void addUpdateCounters(UUID nodeId, Map<Integer, Long> cntrs) {
        this.addUpdateCounters(cntrs);
        if (this.updateCntrsPerNode == null) {
            this.updateCntrsPerNode = new HashMap<UUID, Map<Integer, Long>>();
        }
        Map<Integer, Long> old = this.updateCntrsPerNode.put(nodeId, cntrs);
        assert (old == null) : old;
    }

    public Map<UUID, IgniteCheckedException> errs() {
        return this.errs;
    }

    public boolean keepBinary() {
        return this.keepBinary;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public DiscoveryCustomMessage ackMessage() {
        return new StartRoutineAckDiscoveryMessage(this.routineId, this.errs, this.updateCntrs, this.updateCntrsPerNode);
    }

    public String toString() {
        return S.toString(StartRoutineDiscoveryMessage.class, this, "routineId", this.routineId());
    }
}

