/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastreamer;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerEntry;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataStreamerRequest
implements Message {
    private static final long serialVersionUID = 0L;
    private long reqId;
    private byte[] resTopicBytes;
    private String cacheName;
    private byte[] updaterBytes;
    @GridDirectCollection(value=DataStreamerEntry.class)
    private Collection<DataStreamerEntry> entries;
    private boolean ignoreDepOwnership;
    private boolean skipStore;
    private boolean keepBinary;
    private DeploymentMode depMode;
    private String sampleClsName;
    private String userVer;
    @GridToStringInclude
    @GridDirectMap(keyType=UUID.class, valueType=IgniteUuid.class)
    private Map<UUID, IgniteUuid> ldrParticipants;
    private IgniteUuid clsLdrId;
    private boolean forceLocDep;
    private AffinityTopologyVersion topVer;

    public DataStreamerRequest() {
    }

    public DataStreamerRequest(long reqId, byte[] resTopicBytes, @Nullable String cacheName, byte[] updaterBytes, Collection<DataStreamerEntry> entries, boolean ignoreDepOwnership, boolean skipStore, boolean keepBinary, DeploymentMode depMode, String sampleClsName, String userVer, Map<UUID, IgniteUuid> ldrParticipants, IgniteUuid clsLdrId, boolean forceLocDep, @NotNull AffinityTopologyVersion topVer) {
        assert (topVer != null);
        this.reqId = reqId;
        this.resTopicBytes = resTopicBytes;
        this.cacheName = cacheName;
        this.updaterBytes = updaterBytes;
        this.entries = entries;
        this.ignoreDepOwnership = ignoreDepOwnership;
        this.skipStore = skipStore;
        this.keepBinary = keepBinary;
        this.depMode = depMode;
        this.sampleClsName = sampleClsName;
        this.userVer = userVer;
        this.ldrParticipants = ldrParticipants;
        this.clsLdrId = clsLdrId;
        this.forceLocDep = forceLocDep;
        this.topVer = topVer;
    }

    public long requestId() {
        return this.reqId;
    }

    public byte[] responseTopicBytes() {
        return this.resTopicBytes;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public byte[] updaterBytes() {
        return this.updaterBytes;
    }

    public Collection<DataStreamerEntry> entries() {
        return this.entries;
    }

    public boolean ignoreDeploymentOwnership() {
        return this.ignoreDepOwnership;
    }

    public boolean skipStore() {
        return this.skipStore;
    }

    public boolean keepBinary() {
        return this.keepBinary;
    }

    public DeploymentMode deploymentMode() {
        return this.depMode;
    }

    public String sampleClassName() {
        return this.sampleClsName;
    }

    public String userVersion() {
        return this.userVer;
    }

    public Map<UUID, IgniteUuid> participants() {
        return this.ldrParticipants;
    }

    public IgniteUuid classLoaderId() {
        return this.clsLdrId;
    }

    public boolean forceLocalDeployment() {
        return this.forceLocDep;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(DataStreamerRequest.class, this);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeString("cacheName", this.cacheName)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeIgniteUuid("clsLdrId", this.clsLdrId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeByte("depMode", this.depMode != null ? (byte)this.depMode.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeCollection("entries", this.entries, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeBoolean("forceLocDep", this.forceLocDep)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeBoolean("ignoreDepOwnership", this.ignoreDepOwnership)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeBoolean("keepBinary", this.keepBinary)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeMap("ldrParticipants", this.ldrParticipants, MessageCollectionItemType.UUID, MessageCollectionItemType.IGNITE_UUID)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeLong("reqId", this.reqId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeByteArray("resTopicBytes", this.resTopicBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeString("sampleClsName", this.sampleClsName)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeBoolean("skipStore", this.skipStore)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeByteArray("updaterBytes", this.updaterBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeString("userVer", this.userVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.cacheName = reader.readString("cacheName");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.clsLdrId = reader.readIgniteUuid("clsLdrId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                byte depModeOrd = reader.readByte("depMode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.depMode = DeploymentMode.fromOrdinal(depModeOrd);
                reader.incrementState();
            }
            case 3: {
                this.entries = reader.readCollection("entries", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.forceLocDep = reader.readBoolean("forceLocDep");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.ignoreDepOwnership = reader.readBoolean("ignoreDepOwnership");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.keepBinary = reader.readBoolean("keepBinary");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.ldrParticipants = reader.readMap("ldrParticipants", MessageCollectionItemType.UUID, MessageCollectionItemType.IGNITE_UUID, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.reqId = reader.readLong("reqId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.resTopicBytes = reader.readByteArray("resTopicBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.sampleClsName = reader.readString("sampleClsName");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.skipStore = reader.readBoolean("skipStore");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.updaterBytes = reader.readByteArray("updaterBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.userVer = reader.readString("userVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(DataStreamerRequest.class);
    }

    @Override
    public byte directType() {
        return 62;
    }

    @Override
    public byte fieldsCount() {
        return 15;
    }
}

