/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteAtomicReference;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteAtomicStamped;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCountDownLatch;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLock;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteQueue;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.IgniteSet;
import org.apache.ignite.cache.CacheAtomicWriteOrderMode;
import org.apache.ignite.cache.CacheEntryEventSerializableFilter;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.CollectionConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.datastructures.CacheDataStructuresCacheKey;
import org.apache.ignite.internal.processors.datastructures.CacheDataStructuresConfigurationKey;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicLongValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicReferenceValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicSequenceValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicStampedValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheCountDownLatchEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheCountDownLatchValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKey;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKeyImpl;
import org.apache.ignite.internal.processors.datastructures.GridCacheLockEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheLockState;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueAdapter;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueHeader;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueHeaderKey;
import org.apache.ignite.internal.processors.datastructures.GridCacheRemovable;
import org.apache.ignite.internal.processors.datastructures.GridCacheSemaphoreEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheSemaphoreState;
import org.apache.ignite.internal.processors.datastructures.GridCacheSetHeader;
import org.apache.ignite.internal.processors.datastructures.GridCacheSetHeaderKey;
import org.apache.ignite.internal.util.lang.IgniteClosureX;
import org.apache.ignite.internal.util.lang.IgniteInClosureX;
import org.apache.ignite.internal.util.lang.IgniteOutClosureX;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.GPR;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public final class DataStructuresProcessor
extends GridProcessorAdapter {
    public static final CacheDataStructuresConfigurationKey DATA_STRUCTURES_KEY = new CacheDataStructuresConfigurationKey();
    private static final CacheDataStructuresCacheKey DATA_STRUCTURES_CACHE_KEY = new CacheDataStructuresCacheKey();
    private static final int INITIAL_CAPACITY = 10;
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private boolean initFailed;
    private IgniteInternalCache<GridCacheInternal, GridCacheInternal> dsView;
    private final ConcurrentMap<GridCacheInternal, GridCacheRemovable> dsMap = new ConcurrentHashMap8<GridCacheInternal, GridCacheRemovable>(10);
    private IgniteInternalCache<GridCacheInternalKey, GridCacheAtomicLongValue> atomicLongView;
    private IgniteInternalCache<GridCacheInternalKey, GridCacheCountDownLatchValue> cntDownLatchView;
    private IgniteInternalCache<GridCacheInternalKey, GridCacheSemaphoreState> semView;
    private IgniteInternalCache<GridCacheInternalKey, GridCacheLockState> reentrantLockView;
    private IgniteInternalCache<GridCacheInternalKey, GridCacheAtomicReferenceValue> atomicRefView;
    private IgniteInternalCache<GridCacheInternalKey, GridCacheAtomicStampedValue> atomicStampedView;
    private IgniteInternalCache<GridCacheInternalKey, GridCacheAtomicSequenceValue> seqView;
    private GridCacheContext dsCacheCtx;
    private final AtomicConfiguration atomicCfg;
    private IgniteInternalCache<CacheDataStructuresConfigurationKey, Map<String, DataStructureInfo>> utilityCache;
    private IgniteInternalCache<CacheDataStructuresCacheKey, List<CacheCollectionInfo>> utilityDataCache;
    private volatile UUID qryId;

    public DataStructuresProcessor(GridKernalContext ctx) {
        super(ctx);
        this.atomicCfg = ctx.config().getAtomicConfiguration();
    }

    @Override
    public void start() throws IgniteCheckedException {
        super.start();
        this.ctx.event().addLocalEventListener(new GridLocalEventListener(){

            @Override
            public void onEvent(final Event evt) {
                DataStructuresProcessor.this.ctx.closure().callLocalSafe(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
                        UUID leftNodeId = discoEvt.eventNode().id();
                        for (GridCacheRemovable ds : DataStructuresProcessor.this.dsMap.values()) {
                            if (ds instanceof GridCacheSemaphoreEx) {
                                ((GridCacheSemaphoreEx)ds).onNodeRemoved(leftNodeId);
                                continue;
                            }
                            if (!(ds instanceof GridCacheLockEx)) continue;
                            ((GridCacheLockEx)ds).onNodeRemoved(leftNodeId);
                        }
                        return null;
                    }
                }, false);
            }
        }, 11, 12);
    }

    @Override
    public void onKernalStart() throws IgniteCheckedException {
        if (this.ctx.config().isDaemon()) {
            return;
        }
        this.utilityCache = this.ctx.cache().utilityCache();
        this.utilityDataCache = this.ctx.cache().utilityCache();
        assert (this.utilityCache != null);
        if (this.atomicCfg != null) {
            IgniteInternalCache atomicsCache = this.ctx.cache().atomicsCache();
            assert (atomicsCache != null);
            this.dsView = atomicsCache;
            this.cntDownLatchView = atomicsCache;
            this.semView = atomicsCache;
            this.reentrantLockView = atomicsCache;
            this.atomicLongView = atomicsCache;
            this.atomicRefView = atomicsCache;
            this.atomicStampedView = atomicsCache;
            this.seqView = atomicsCache;
            this.dsCacheCtx = atomicsCache.context();
        }
        this.initLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startQuery() throws IgniteCheckedException {
        if (this.qryId == null) {
            DataStructuresProcessor dataStructuresProcessor = this;
            synchronized (dataStructuresProcessor) {
                if (this.qryId == null) {
                    this.qryId = this.dsCacheCtx.continuousQueries().executeInternalQuery(new DataStructuresEntryListener(), new DataStructuresEntryFilter(), this.dsCacheCtx.isReplicated() && this.dsCacheCtx.affinityNode(), false, false);
                }
            }
        }
    }

    @Override
    public void onKernalStop(boolean cancel) {
        super.onKernalStop(cancel);
        for (GridCacheRemovable ds : this.dsMap.values()) {
            if (ds instanceof GridCacheSemaphoreEx) {
                ((GridCacheSemaphoreEx)ds).stop();
            }
            if (!(ds instanceof GridCacheLockEx)) continue;
            ((GridCacheLockEx)ds).onStop();
        }
        if (this.initLatch.getCount() > 0L) {
            this.initFailed = true;
            this.initLatch.countDown();
        }
        if (this.qryId != null) {
            this.dsCacheCtx.continuousQueries().cancelInternalQuery(this.qryId);
        }
    }

    void onRemoved(GridCacheInternal key, GridCacheRemovable obj) {
        this.dsMap.remove(key, obj);
    }

    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) throws IgniteCheckedException {
        for (Map.Entry e : this.dsMap.entrySet()) {
            GridCacheRemovable obj = (GridCacheRemovable)e.getValue();
            if (clusterRestarted) {
                obj.onRemoved();
                this.dsMap.remove(e.getKey(), obj);
                continue;
            }
            obj.needCheckNotRemoved();
        }
        for (GridCacheContext cctx : this.ctx.cache().context().cacheContexts()) {
            cctx.dataStructures().onReconnected(clusterRestarted);
        }
        return null;
    }

    public final IgniteAtomicSequence sequence(final String name, final long initVal, final boolean create) throws IgniteCheckedException {
        A.notNull(name, "name");
        this.awaitInitialization();
        this.checkAtomicsConfiguration();
        this.startQuery();
        return this.getAtomic(new IgniteOutClosureX<IgniteAtomicSequence>(){

            /*
             * Exception decompiling
             */
            @Override
            public IgniteAtomicSequence applyx() throws IgniteCheckedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, new DataStructureInfo(name, DataStructureType.ATOMIC_SEQ, null), create, IgniteAtomicSequence.class);
    }

    public final void removeSequence(final String name) throws IgniteCheckedException {
        assert (name != null);
        this.awaitInitialization();
        this.checkAtomicsConfiguration();
        this.removeDataStructure(new IgniteOutClosureX<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void applyx() throws IgniteCheckedException {
                DataStructuresProcessor.this.dsCacheCtx.gate().enter();
                try {
                    GridCacheInternalKeyImpl key = new GridCacheInternalKeyImpl(name);
                    DataStructuresProcessor.this.removeInternal(key, GridCacheAtomicSequenceValue.class);
                }
                finally {
                    DataStructuresProcessor.this.dsCacheCtx.gate().leave();
                }
                return null;
            }
        }, name, DataStructureType.ATOMIC_SEQ, null);
    }

    public final IgniteAtomicLong atomicLong(final String name, final long initVal, final boolean create) throws IgniteCheckedException {
        A.notNull(name, "name");
        this.awaitInitialization();
        this.checkAtomicsConfiguration();
        this.startQuery();
        return this.getAtomic(new IgniteOutClosureX<IgniteAtomicLong>(){

            /*
             * Exception decompiling
             */
            @Override
            public IgniteAtomicLong applyx() throws IgniteCheckedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, new DataStructureInfo(name, DataStructureType.ATOMIC_LONG, null), create, IgniteAtomicLong.class);
    }

    @Nullable
    private <T> T getAtomic(final IgniteOutClosureX<T> c, final DataStructureInfo dsInfo, final boolean create, Class<? extends T> cls) throws IgniteCheckedException {
        Map<String, DataStructureInfo> dsMap = this.utilityCache.get(DATA_STRUCTURES_KEY);
        if (!(create || dsMap != null && dsMap.containsKey(dsInfo.name))) {
            return null;
        }
        IgniteCheckedException err = DataStructuresProcessor.validateDataStructure(dsMap, dsInfo, create);
        if (err != null) {
            throw err;
        }
        GridCacheInternalKeyImpl key = new GridCacheInternalKeyImpl(dsInfo.name);
        T dataStructure = this.cast(this.dsMap.get(key), cls);
        if (dataStructure != null) {
            return dataStructure;
        }
        return DataStructuresProcessor.retryTopologySafe(new IgniteOutClosureX<T>(){

            @Override
            public T applyx() throws IgniteCheckedException {
                if (!create) {
                    return c.applyx();
                }
                try (IgniteInternalTx tx = DataStructuresProcessor.this.utilityCache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    IgniteCheckedException err = DataStructuresProcessor.this.utilityCache.invoke(DATA_STRUCTURES_KEY, new AddAtomicProcessor(dsInfo), new Object[0]).get();
                    if (err != null) {
                        throw err;
                    }
                    Object dataStructure = c.applyx();
                    tx.commit();
                    Object t = dataStructure;
                    return t;
                }
            }
        });
    }

    public final void removeAtomicLong(final String name) throws IgniteCheckedException {
        assert (name != null);
        assert (this.dsCacheCtx != null);
        this.awaitInitialization();
        this.removeDataStructure(new IgniteOutClosureX<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void applyx() throws IgniteCheckedException {
                DataStructuresProcessor.this.dsCacheCtx.gate().enter();
                try {
                    DataStructuresProcessor.this.removeInternal(new GridCacheInternalKeyImpl(name), GridCacheAtomicLongValue.class);
                }
                finally {
                    DataStructuresProcessor.this.dsCacheCtx.gate().leave();
                }
                return null;
            }
        }, name, DataStructureType.ATOMIC_LONG, null);
    }

    private <T> void removeDataStructure(final IgniteOutClosureX<T> c, String name, DataStructureType type, final @Nullable IgniteInClosureX<T> afterRmv) throws IgniteCheckedException {
        Map<String, DataStructureInfo> dsMap = this.utilityCache.get(DATA_STRUCTURES_KEY);
        if (dsMap == null || !dsMap.containsKey(name)) {
            return;
        }
        final DataStructureInfo dsInfo = new DataStructureInfo(name, type, null);
        IgniteCheckedException err = DataStructuresProcessor.validateDataStructure(dsMap, dsInfo, false);
        if (err != null) {
            throw err;
        }
        DataStructuresProcessor.retryTopologySafe(new IgniteOutClosureX<Void>(){

            @Override
            public Void applyx() throws IgniteCheckedException {
                try (IgniteInternalTx tx = DataStructuresProcessor.this.utilityCache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    T2<Boolean, IgniteCheckedException> res = DataStructuresProcessor.this.utilityCache.invoke(DATA_STRUCTURES_KEY, new RemoveDataStructureProcessor(dsInfo), new Object[0]).get();
                    IgniteCheckedException err = (IgniteCheckedException)res.get2();
                    if (err != null) {
                        throw err;
                    }
                    assert (res.get1() != null);
                    boolean exists = (Boolean)res.get1();
                    if (!exists) {
                        Void void_ = null;
                        return void_;
                    }
                    Object rmvInfo = c.applyx();
                    tx.commit();
                    if (afterRmv != null && rmvInfo != null) {
                        afterRmv.applyx(rmvInfo);
                    }
                    Void void_ = null;
                    return void_;
                }
            }
        });
    }

    public final <T> IgniteAtomicReference<T> atomicReference(final String name, final T initVal, final boolean create) throws IgniteCheckedException {
        A.notNull(name, "name");
        this.awaitInitialization();
        this.checkAtomicsConfiguration();
        this.startQuery();
        return this.getAtomic(new IgniteOutClosureX<IgniteAtomicReference>(){

            /*
             * Exception decompiling
             */
            @Override
            public IgniteAtomicReference<T> applyx() throws IgniteCheckedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, new DataStructureInfo(name, DataStructureType.ATOMIC_REF, null), create, IgniteAtomicReference.class);
    }

    public final void removeAtomicReference(final String name) throws IgniteCheckedException {
        assert (name != null);
        assert (this.dsCacheCtx != null);
        this.awaitInitialization();
        this.removeDataStructure(new IgniteOutClosureX<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void applyx() throws IgniteCheckedException {
                DataStructuresProcessor.this.dsCacheCtx.gate().enter();
                try {
                    GridCacheInternalKeyImpl key = new GridCacheInternalKeyImpl(name);
                    DataStructuresProcessor.this.removeInternal(key, GridCacheAtomicReferenceValue.class);
                }
                finally {
                    DataStructuresProcessor.this.dsCacheCtx.gate().leave();
                }
                return null;
            }
        }, name, DataStructureType.ATOMIC_REF, null);
    }

    public final <T, S> IgniteAtomicStamped<T, S> atomicStamped(final String name, final T initVal, final S initStamp, final boolean create) throws IgniteCheckedException {
        A.notNull(name, "name");
        this.awaitInitialization();
        this.checkAtomicsConfiguration();
        this.startQuery();
        return this.getAtomic(new IgniteOutClosureX<IgniteAtomicStamped>(){

            /*
             * Exception decompiling
             */
            @Override
            public IgniteAtomicStamped<T, S> applyx() throws IgniteCheckedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, new DataStructureInfo(name, DataStructureType.ATOMIC_STAMPED, null), create, IgniteAtomicStamped.class);
    }

    public final void removeAtomicStamped(final String name) throws IgniteCheckedException {
        assert (name != null);
        assert (this.dsCacheCtx != null);
        this.awaitInitialization();
        this.removeDataStructure(new IgniteOutClosureX<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void applyx() throws IgniteCheckedException {
                DataStructuresProcessor.this.dsCacheCtx.gate().enter();
                try {
                    GridCacheInternalKeyImpl key = new GridCacheInternalKeyImpl(name);
                    DataStructuresProcessor.this.removeInternal(key, GridCacheAtomicStampedValue.class);
                }
                finally {
                    DataStructuresProcessor.this.dsCacheCtx.gate().leave();
                }
                return null;
            }
        }, name, DataStructureType.ATOMIC_STAMPED, null);
    }

    public final <T> IgniteQueue<T> queue(final String name, int cap, final @Nullable CollectionConfiguration cfg) throws IgniteCheckedException {
        A.notNull(name, "name");
        this.awaitInitialization();
        String cacheName = null;
        if (cfg != null) {
            if (cap <= 0) {
                cap = Integer.MAX_VALUE;
            }
            cacheName = this.compatibleConfiguration(cfg);
        }
        DataStructureInfo dsInfo = new DataStructureInfo(name, DataStructureType.QUEUE, cfg != null ? new QueueInfo(cacheName, cfg.isCollocated(), cap) : null);
        final int cap0 = cap;
        final boolean create = cfg != null;
        return (IgniteQueue)this.getCollection(new IgniteClosureX<GridCacheContext, IgniteQueue<T>>(){

            @Override
            public IgniteQueue<T> applyx(GridCacheContext ctx) throws IgniteCheckedException {
                return ctx.dataStructures().queue(name, cap0, create && cfg.isCollocated(), create);
            }
        }, dsInfo, create);
    }

    private CacheConfiguration cacheConfiguration(CollectionConfiguration cfg, String name) {
        CacheConfiguration ccfg = new CacheConfiguration();
        ccfg.setName(name);
        ccfg.setBackups(cfg.getBackups());
        ccfg.setCacheMode(cfg.getCacheMode());
        ccfg.setMemoryMode(cfg.getMemoryMode());
        ccfg.setAtomicityMode(cfg.getAtomicityMode());
        ccfg.setOffHeapMaxMemory(cfg.getOffHeapMaxMemory());
        ccfg.setNodeFilter(cfg.getNodeFilter());
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAtomicWriteOrderMode(CacheAtomicWriteOrderMode.PRIMARY);
        ccfg.setRebalanceMode(CacheRebalanceMode.SYNC);
        return ccfg;
    }

    private String compatibleConfiguration(CollectionConfiguration cfg) throws IgniteCheckedException {
        List<CacheCollectionInfo> caches = this.utilityDataCache.context().affinityNode() ? this.utilityDataCache.localPeek(DATA_STRUCTURES_CACHE_KEY, null, null) : this.utilityDataCache.get(DATA_STRUCTURES_CACHE_KEY);
        String cacheName = DataStructuresProcessor.findCompatibleConfiguration(cfg, caches);
        if (cacheName == null) {
            cacheName = this.utilityDataCache.invoke(DATA_STRUCTURES_CACHE_KEY, new AddDataCacheProcessor(cfg), new Object[0]).get();
        }
        assert (cacheName != null);
        CacheConfiguration newCfg = this.cacheConfiguration(cfg, cacheName);
        if (this.ctx.cache().cache(cacheName) == null) {
            this.ctx.cache().dynamicStartCache(newCfg, cacheName, null, CacheType.INTERNAL, false, true, true).get();
        }
        assert (this.ctx.cache().cache(cacheName) != null) : cacheName;
        return cacheName;
    }

    public void removeQueue(final String name, final GridCacheContext cctx) throws IgniteCheckedException {
        assert (name != null);
        assert (cctx != null);
        this.awaitInitialization();
        IgniteOutClosureX<GridCacheQueueHeader> rmv = new IgniteOutClosureX<GridCacheQueueHeader>(){

            @Override
            public GridCacheQueueHeader applyx() throws IgniteCheckedException {
                return (GridCacheQueueHeader)cctx.cache().withNoRetries().getAndRemove(new GridCacheQueueHeaderKey(name));
            }
        };
        CIX1<GridCacheQueueHeader> afterRmv = new CIX1<GridCacheQueueHeader>(){

            @Override
            public void applyx(GridCacheQueueHeader hdr) throws IgniteCheckedException {
                if (hdr.empty()) {
                    return;
                }
                GridCacheQueueAdapter.removeKeys(cctx.cache(), hdr.id(), name, hdr.collocated(), cctx.binaryMarshaller(), hdr.head(), hdr.tail(), 0);
            }
        };
        this.removeDataStructure(rmv, name, DataStructureType.QUEUE, afterRmv);
    }

    @Nullable
    private <T> T getCollection(final IgniteClosureX<GridCacheContext, T> c, final DataStructureInfo dsInfo, boolean create) throws IgniteCheckedException {
        this.awaitInitialization();
        Map<String, DataStructureInfo> dsMap = this.utilityCache.get(DATA_STRUCTURES_KEY);
        if (!(create || dsMap != null && dsMap.containsKey(dsInfo.name))) {
            return null;
        }
        IgniteCheckedException err = DataStructuresProcessor.validateDataStructure(dsMap, dsInfo, create);
        if (err != null) {
            throw err;
        }
        if (!create) {
            DataStructureInfo oldInfo = dsMap.get(dsInfo.name);
            assert (oldInfo.info instanceof CollectionInfo) : DataStructureInfo.access$1800(oldInfo);
            String cacheName = ((CollectionInfo)oldInfo.info).cacheName;
            GridCacheContext cacheCtx = this.ctx.cache().getOrStartCache(cacheName).context();
            return c.applyx(cacheCtx);
        }
        return DataStructuresProcessor.retryTopologySafe(new IgniteOutClosureX<T>(){

            @Override
            public T applyx() throws IgniteCheckedException {
                try (IgniteInternalTx tx = DataStructuresProcessor.this.utilityCache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    T2<String, IgniteCheckedException> res = DataStructuresProcessor.this.utilityCache.invoke(DATA_STRUCTURES_KEY, new AddCollectionProcessor(dsInfo), new Object[0]).get();
                    IgniteCheckedException err = (IgniteCheckedException)res.get2();
                    if (err != null) {
                        throw err;
                    }
                    String cacheName = (String)res.get1();
                    GridCacheContext cacheCtx = DataStructuresProcessor.this.ctx.cache().internalCache(cacheName).context();
                    Object col = c.applyx(cacheCtx);
                    tx.commit();
                    Object r = col;
                    return r;
                }
            }
        });
    }

    private void awaitInitialization() {
        if (this.initLatch.getCount() > 0L) {
            try {
                U.await(this.initLatch);
                if (this.initFailed) {
                    throw new IllegalStateException("Failed to initialize data structures processor.");
                }
            }
            catch (IgniteInterruptedCheckedException e) {
                throw new IllegalStateException("Failed to initialize data structures processor (thread has been interrupted).", e);
            }
        }
    }

    @Nullable
    private static IgniteCheckedException validateDataStructure(@Nullable Map<String, DataStructureInfo> dsMap, DataStructureInfo info, boolean create) {
        if (dsMap == null) {
            return null;
        }
        DataStructureInfo oldInfo = dsMap.get(info.name);
        if (oldInfo != null) {
            return oldInfo.validate(info, create);
        }
        return null;
    }

    public IgniteCountDownLatch countDownLatch(final String name, final int cnt, final boolean autoDel, final boolean create) throws IgniteCheckedException {
        A.notNull(name, "name");
        this.awaitInitialization();
        if (create) {
            A.ensure(cnt >= 0, "count can not be negative");
        }
        this.checkAtomicsConfiguration();
        this.startQuery();
        return this.getAtomic(new IgniteOutClosureX<IgniteCountDownLatch>(){

            /*
             * Exception decompiling
             */
            @Override
            public IgniteCountDownLatch applyx() throws IgniteCheckedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, new DataStructureInfo(name, DataStructureType.COUNT_DOWN_LATCH, null), create, GridCacheCountDownLatchEx.class);
    }

    public void removeCountDownLatch(final String name) throws IgniteCheckedException {
        assert (name != null);
        assert (this.dsCacheCtx != null);
        this.awaitInitialization();
        this.removeDataStructure(new IgniteOutClosureX<Void>(){

            /*
             * Loose catch block
             */
            @Override
            public Void applyx() throws IgniteCheckedException {
                GridCacheInternalKeyImpl key = new GridCacheInternalKeyImpl(name);
                DataStructuresProcessor.this.dsCacheCtx.gate().enter();
                try {
                    try (IgniteInternalTx tx = CU.txStartInternal(DataStructuresProcessor.this.dsCacheCtx, DataStructuresProcessor.this.dsView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                        GridCacheCountDownLatchValue val = (GridCacheCountDownLatchValue)DataStructuresProcessor.this.cast(DataStructuresProcessor.this.dsView.get(key), GridCacheCountDownLatchValue.class);
                        if (val != null) {
                            if (val.get() > 0) {
                                throw new IgniteCheckedException("Failed to remove count down latch with non-zero count: " + val.get());
                            }
                            DataStructuresProcessor.this.dsView.remove(key);
                            tx.commit();
                        } else {
                            tx.setRollbackOnly();
                        }
                        Void void_ = null;
                        return void_;
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    DataStructuresProcessor.this.dsCacheCtx.gate().leave();
                }
            }
        }, name, DataStructureType.COUNT_DOWN_LATCH, null);
    }

    public IgniteSemaphore semaphore(final String name, final int cnt, final boolean failoverSafe, final boolean create) throws IgniteCheckedException {
        A.notNull(name, "name");
        this.awaitInitialization();
        this.checkAtomicsConfiguration();
        this.startQuery();
        return this.getAtomic(new IgniteOutClosureX<IgniteSemaphore>(){

            /*
             * Exception decompiling
             */
            @Override
            public IgniteSemaphore applyx() throws IgniteCheckedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, new DataStructureInfo(name, DataStructureType.SEMAPHORE, null), create, GridCacheSemaphoreEx.class);
    }

    public void removeSemaphore(final String name) throws IgniteCheckedException {
        assert (name != null);
        assert (this.dsCacheCtx != null);
        this.awaitInitialization();
        this.removeDataStructure(new IgniteOutClosureX<Void>(){

            /*
             * Loose catch block
             */
            @Override
            public Void applyx() throws IgniteCheckedException {
                GridCacheInternalKeyImpl key = new GridCacheInternalKeyImpl(name);
                DataStructuresProcessor.this.dsCacheCtx.gate().enter();
                try {
                    try (IgniteInternalTx tx = CU.txStartInternal(DataStructuresProcessor.this.dsCacheCtx, DataStructuresProcessor.this.dsView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                        GridCacheSemaphoreState val = (GridCacheSemaphoreState)DataStructuresProcessor.this.cast(DataStructuresProcessor.this.dsView.get(key), GridCacheSemaphoreState.class);
                        if (val != null) {
                            if (val.getCount() < 0) {
                                throw new IgniteCheckedException("Failed to remove semaphore with blocked threads. ");
                            }
                            DataStructuresProcessor.this.dsView.remove(key);
                            tx.commit();
                        } else {
                            tx.setRollbackOnly();
                        }
                        Void void_ = null;
                        return void_;
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    DataStructuresProcessor.this.dsCacheCtx.gate().leave();
                }
            }
        }, name, DataStructureType.SEMAPHORE, null);
    }

    public IgniteLock reentrantLock(final String name, final boolean failoverSafe, final boolean fair, final boolean create) throws IgniteCheckedException {
        A.notNull(name, "name");
        this.awaitInitialization();
        this.checkAtomicsConfiguration();
        this.startQuery();
        return this.getAtomic(new IgniteOutClosureX<IgniteLock>(){

            /*
             * Exception decompiling
             */
            @Override
            public IgniteLock applyx() throws IgniteCheckedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, new DataStructureInfo(name, DataStructureType.REENTRANT_LOCK, null), create, GridCacheLockEx.class);
    }

    public void removeReentrantLock(final String name, final boolean broken) throws IgniteCheckedException {
        assert (name != null);
        assert (this.dsCacheCtx != null);
        this.awaitInitialization();
        this.removeDataStructure(new IgniteOutClosureX<Void>(){

            /*
             * Loose catch block
             */
            @Override
            public Void applyx() throws IgniteCheckedException {
                GridCacheInternalKeyImpl key = new GridCacheInternalKeyImpl(name);
                DataStructuresProcessor.this.dsCacheCtx.gate().enter();
                try {
                    try (IgniteInternalTx tx = CU.txStartInternal(DataStructuresProcessor.this.dsCacheCtx, DataStructuresProcessor.this.dsView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                        GridCacheLockState val = (GridCacheLockState)DataStructuresProcessor.this.cast(DataStructuresProcessor.this.dsView.get(key), GridCacheLockState.class);
                        if (val != null) {
                            if (val.get() > 0 && !broken) {
                                throw new IgniteCheckedException("Failed to remove reentrant lock with blocked threads. ");
                            }
                            DataStructuresProcessor.this.dsView.remove(key);
                            tx.commit();
                        } else {
                            tx.setRollbackOnly();
                        }
                        Void void_ = null;
                        return void_;
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    DataStructuresProcessor.this.dsCacheCtx.gate().leave();
                }
            }
        }, name, DataStructureType.REENTRANT_LOCK, null);
    }

    private <R> boolean removeInternal(final GridCacheInternal key, final Class<R> cls) throws IgniteCheckedException {
        return CU.outTx(new Callable<Boolean>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Boolean call() throws Exception {
                try (IgniteInternalTx tx = CU.txStartInternal(DataStructuresProcessor.this.dsCacheCtx, DataStructuresProcessor.this.dsView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    Object val = DataStructuresProcessor.this.cast(DataStructuresProcessor.this.dsView.get(key), cls);
                    if (val != null) {
                        DataStructuresProcessor.this.dsView.remove(key);
                        tx.commit();
                    } else {
                        tx.setRollbackOnly();
                    }
                    Boolean bl = val != null;
                    return bl;
                }
                catch (Error | Exception e) {
                    U.error(DataStructuresProcessor.this.log, "Failed to remove data structure: " + key, e);
                    throw e;
                }
            }
        }, this.dsCacheCtx);
    }

    @Nullable
    public <T> IgniteSet<T> set(final String name, final @Nullable CollectionConfiguration cfg) throws IgniteCheckedException {
        A.notNull(name, "name");
        this.awaitInitialization();
        String cacheName = null;
        if (cfg != null) {
            cacheName = this.compatibleConfiguration(cfg);
        }
        DataStructureInfo dsInfo = new DataStructureInfo(name, DataStructureType.SET, cfg != null ? new CollectionInfo(cacheName, cfg.isCollocated()) : null);
        final boolean create = cfg != null;
        return (IgniteSet)this.getCollection(new CX1<GridCacheContext, IgniteSet<T>>(){

            @Override
            public IgniteSet<T> applyx(GridCacheContext cctx) throws IgniteCheckedException {
                return cctx.dataStructures().set(name, create ? cfg.isCollocated() : false, create);
            }
        }, dsInfo, create);
    }

    public void removeSet(final String name, final GridCacheContext cctx) throws IgniteCheckedException {
        assert (name != null);
        assert (cctx != null);
        this.awaitInitialization();
        IgniteOutClosureX<GridCacheSetHeader> rmv = new IgniteOutClosureX<GridCacheSetHeader>(){

            @Override
            public GridCacheSetHeader applyx() throws IgniteCheckedException {
                return (GridCacheSetHeader)cctx.cache().withNoRetries().getAndRemove(new GridCacheSetHeaderKey(name));
            }
        };
        CIX1<GridCacheSetHeader> afterRmv = new CIX1<GridCacheSetHeader>(){

            @Override
            public void applyx(GridCacheSetHeader hdr) throws IgniteCheckedException {
                cctx.dataStructures().removeSetData(hdr.id());
            }
        };
        this.removeDataStructure(rmv, name, DataStructureType.SET, afterRmv);
    }

    public static <R> R retry(IgniteLogger log, Callable<R> call) throws IgniteCheckedException {
        try {
            return GridCacheUtils.retryTopologySafe(call).call();
        }
        catch (IgniteCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteCheckedException(e);
        }
    }

    @Nullable
    private <R> R cast(@Nullable Object obj, Class<R> cls) throws IgniteCheckedException {
        if (obj == null) {
            return null;
        }
        if (cls.isInstance(obj)) {
            return (R)obj;
        }
        throw new IgniteCheckedException("Failed to cast object [expected=" + cls + ", actual=" + obj.getClass() + ']');
    }

    @Override
    public void printMemoryStats() {
        X.println(">>> ", new Object[0]);
        X.println(">>> Data structure processor memory stats [grid=" + this.ctx.gridName() + ", cache=" + (this.dsCacheCtx != null ? this.dsCacheCtx.name() : null) + ']', new Object[0]);
        X.println(">>>   dsMapSize: " + this.dsMap.size(), new Object[0]);
    }

    private void checkAtomicsConfiguration() throws IgniteException {
        if (this.atomicCfg == null) {
            throw new IgniteException("Atomic data structure can not be created, need to provide IgniteAtomicConfiguration.");
        }
    }

    private static String findCompatibleConfiguration(CollectionConfiguration cfg, List<CacheCollectionInfo> infos) {
        if (infos == null) {
            return null;
        }
        for (CacheCollectionInfo col : infos) {
            if (col.cfg.getAtomicityMode() != cfg.getAtomicityMode() || col.cfg.getMemoryMode() != cfg.getMemoryMode() || col.cfg.getCacheMode() != cfg.getCacheMode() || col.cfg.getBackups() != cfg.getBackups() || col.cfg.getOffHeapMaxMemory() != cfg.getOffHeapMaxMemory() || (col.cfg.getNodeFilter() != null || cfg.getNodeFilter() != null) && (col.cfg.getNodeFilter() == null || !col.cfg.getNodeFilter().equals(cfg.getNodeFilter()))) continue;
            return col.cacheName;
        }
        return null;
    }

    private static <T> T retryTopologySafe(IgniteOutClosureX<T> c) throws IgniteCheckedException {
        for (int i = 0; i < GridCacheAdapter.MAX_RETRIES; ++i) {
            try {
                return c.applyx();
            }
            catch (IgniteCheckedException e) {
                if (i == GridCacheAdapter.MAX_RETRIES - 1) {
                    throw e;
                }
                ClusterTopologyCheckedException topErr = e.getCause(ClusterTopologyCheckedException.class);
                if (topErr == null || topErr instanceof ClusterTopologyServerNotFoundException) {
                    throw e;
                }
                IgniteInternalFuture<?> fut = topErr.retryReadyFuture();
                if (fut == null) continue;
                fut.get();
                continue;
            }
        }
        assert (false);
        return null;
    }

    static /* synthetic */ AtomicConfiguration access$600(DataStructuresProcessor x0) {
        return x0.atomicCfg;
    }

    static /* synthetic */ IgniteInternalCache access$700(DataStructuresProcessor x0) {
        return x0.seqView;
    }

    static /* synthetic */ IgniteLogger access$800(DataStructuresProcessor x0) {
        return x0.log;
    }

    static /* synthetic */ IgniteInternalCache access$1000(DataStructuresProcessor x0) {
        return x0.atomicLongView;
    }

    static /* synthetic */ IgniteLogger access$1100(DataStructuresProcessor x0) {
        return x0.log;
    }

    static /* synthetic */ IgniteInternalCache access$1400(DataStructuresProcessor x0) {
        return x0.atomicRefView;
    }

    static /* synthetic */ IgniteLogger access$1500(DataStructuresProcessor x0) {
        return x0.log;
    }

    static /* synthetic */ IgniteInternalCache access$1600(DataStructuresProcessor x0) {
        return x0.atomicStampedView;
    }

    static /* synthetic */ IgniteLogger access$1700(DataStructuresProcessor x0) {
        return x0.log;
    }

    static /* synthetic */ IgniteInternalCache access$2100(DataStructuresProcessor x0) {
        return x0.cntDownLatchView;
    }

    static /* synthetic */ IgniteLogger access$2200(DataStructuresProcessor x0) {
        return x0.log;
    }

    static /* synthetic */ IgniteInternalCache access$2300(DataStructuresProcessor x0) {
        return x0.semView;
    }

    static /* synthetic */ IgniteLogger access$2400(DataStructuresProcessor x0) {
        return x0.log;
    }

    static /* synthetic */ IgniteInternalCache access$2500(DataStructuresProcessor x0) {
        return x0.reentrantLockView;
    }

    static /* synthetic */ IgniteLogger access$2600(DataStructuresProcessor x0) {
        return x0.log;
    }

    static class RemoveDataStructureProcessor
    implements EntryProcessor<CacheDataStructuresConfigurationKey, Map<String, DataStructureInfo>, T2<Boolean, IgniteCheckedException>>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private DataStructureInfo info;

        RemoveDataStructureProcessor(DataStructureInfo info) {
            assert (info != null);
            this.info = info;
        }

        public RemoveDataStructureProcessor() {
        }

        @Override
        public T2<Boolean, IgniteCheckedException> process(MutableEntry<CacheDataStructuresConfigurationKey, Map<String, DataStructureInfo>> entry, Object ... args) {
            HashMap map = (HashMap)entry.getValue();
            if (map == null) {
                return new T2<Boolean, Object>(false, null);
            }
            DataStructureInfo oldInfo = (DataStructureInfo)map.get(this.info.name);
            if (oldInfo == null) {
                return new T2<Boolean, Object>(false, null);
            }
            IgniteCheckedException err = oldInfo.validate(this.info, false);
            if (err == null) {
                map = new HashMap(map);
                map.remove(this.info.name);
                entry.setValue(map);
            }
            return new T2<Boolean, IgniteCheckedException>(true, err);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            this.info.writeExternal(out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.info = new DataStructureInfo();
            this.info.readExternal(in);
        }

        public String toString() {
            return S.toString(RemoveDataStructureProcessor.class, this);
        }
    }

    static class AddDataCacheProcessor
    implements EntryProcessor<CacheDataStructuresCacheKey, List<CacheCollectionInfo>, String>,
    Externalizable {
        private static final String CACHE_NAME_PREFIX = "datastructures_";
        private static final long serialVersionUID = 0L;
        private CollectionConfiguration cfg;

        AddDataCacheProcessor(CollectionConfiguration cfg) {
            this.cfg = cfg;
        }

        public AddDataCacheProcessor() {
        }

        @Override
        public String process(MutableEntry<CacheDataStructuresCacheKey, List<CacheCollectionInfo>> entry, Object ... args) {
            ArrayList<CacheCollectionInfo> list = (ArrayList<CacheCollectionInfo>)entry.getValue();
            if (list == null) {
                list = new ArrayList<CacheCollectionInfo>();
                String newName = "datastructures_0";
                list.add(new CacheCollectionInfo(newName, this.cfg));
                entry.setValue(list);
                return newName;
            }
            String oldName = DataStructuresProcessor.findCompatibleConfiguration(this.cfg, list);
            if (oldName != null) {
                return oldName;
            }
            String newName = CACHE_NAME_PREFIX + list.size();
            ArrayList<CacheCollectionInfo> newList = new ArrayList<CacheCollectionInfo>(list);
            newList.add(new CacheCollectionInfo(newName, this.cfg));
            return newName;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.cfg);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.cfg = (CollectionConfiguration)in.readObject();
        }

        public String toString() {
            return S.toString(AddDataCacheProcessor.class, this);
        }
    }

    static class AddCollectionProcessor
    implements EntryProcessor<CacheDataStructuresConfigurationKey, Map<String, DataStructureInfo>, T2<String, IgniteCheckedException>>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private DataStructureInfo info;

        AddCollectionProcessor(DataStructureInfo info) {
            assert (info != null);
            assert (info.info instanceof CollectionInfo);
            this.info = info;
        }

        public AddCollectionProcessor() {
        }

        @Override
        public T2<String, IgniteCheckedException> process(MutableEntry<CacheDataStructuresConfigurationKey, Map<String, DataStructureInfo>> entry, Object ... args) {
            HashMap<String, DataStructureInfo> map = (HashMap<String, DataStructureInfo>)entry.getValue();
            CollectionInfo colInfo = (CollectionInfo)this.info.info;
            if (map == null) {
                map = new HashMap<String, DataStructureInfo>();
                map.put(this.info.name, this.info);
                entry.setValue(map);
                return new T2<String, Object>(colInfo.cacheName, null);
            }
            DataStructureInfo oldInfo = (DataStructureInfo)map.get(this.info.name);
            if (oldInfo == null) {
                map = new HashMap(map);
                map.put(this.info.name, this.info);
                entry.setValue(map);
                return new T2<String, Object>(colInfo.cacheName, null);
            }
            return new T2<String, IgniteCheckedException>(colInfo.cacheName, oldInfo.validate(this.info, true));
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            this.info.writeExternal(out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.info = new DataStructureInfo();
            this.info.readExternal(in);
        }

        public String toString() {
            return S.toString(AddCollectionProcessor.class, this);
        }
    }

    static class AddAtomicProcessor
    implements EntryProcessor<CacheDataStructuresConfigurationKey, Map<String, DataStructureInfo>, IgniteCheckedException>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private DataStructureInfo info;

        AddAtomicProcessor(DataStructureInfo info) {
            assert (info != null);
            this.info = info;
        }

        public AddAtomicProcessor() {
        }

        @Override
        public IgniteCheckedException process(MutableEntry<CacheDataStructuresConfigurationKey, Map<String, DataStructureInfo>> entry, Object ... args) throws EntryProcessorException {
            HashMap<String, DataStructureInfo> map = (HashMap<String, DataStructureInfo>)entry.getValue();
            if (map == null) {
                map = new HashMap<String, DataStructureInfo>();
                map.put(this.info.name, this.info);
                entry.setValue(map);
                return null;
            }
            DataStructureInfo oldInfo = (DataStructureInfo)map.get(this.info.name);
            if (oldInfo == null) {
                map = new HashMap(map);
                map.put(this.info.name, this.info);
                entry.setValue(map);
                return null;
            }
            return oldInfo.validate(this.info, true);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            this.info.writeExternal(out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.info = new DataStructureInfo();
            this.info.readExternal(in);
        }

        public String toString() {
            return S.toString(AddAtomicProcessor.class, this);
        }
    }

    static class DataStructureInfo
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private String name;
        private DataStructureType type;
        private Object info;

        public DataStructureInfo() {
        }

        DataStructureInfo(String name, DataStructureType type, Externalizable info) {
            this.name = name;
            this.type = type;
            this.info = info;
        }

        @Nullable
        IgniteCheckedException validate(DataStructureInfo dsInfo, boolean create) {
            if (this.type != dsInfo.type) {
                return new IgniteCheckedException("Another data structure with the same name already created [name=" + this.name + ", newType=" + dsInfo.type.className() + ", existingType=" + this.type.className() + ']');
            }
            if (create && (this.type == DataStructureType.QUEUE || this.type == DataStructureType.SET)) {
                CollectionInfo oldInfo = (CollectionInfo)this.info;
                CollectionInfo newInfo = (CollectionInfo)dsInfo.info;
                if (oldInfo.collocated != newInfo.collocated) {
                    return new IgniteCheckedException("Another collection with the same name but different configuration already created [name=" + this.name + ", newCollocated=" + newInfo.collocated + ", existingCollocated=" + newInfo.collocated + ']');
                }
                if (this.type == DataStructureType.QUEUE && ((QueueInfo)oldInfo).cap != ((QueueInfo)newInfo).cap) {
                    return new IgniteCheckedException("Another queue with the same name but different configuration already created [name=" + this.name + ", newCapacity=" + ((QueueInfo)newInfo).cap + ", existingCapacity=" + ((QueueInfo)oldInfo).cap + ']');
                }
            }
            return null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString(out, this.name);
            U.writeEnum(out, this.type);
            out.writeObject(this.info);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = U.readString(in);
            this.type = DataStructureType.fromOrdinal(in.readByte());
            this.info = in.readObject();
        }

        public String toString() {
            return S.toString(DataStructureInfo.class, this);
        }
    }

    static class QueueInfo
    extends CollectionInfo {
        private static final long serialVersionUID = 0L;
        private int cap;

        public QueueInfo() {
        }

        public QueueInfo(String cacheName, boolean collocated, int cap) {
            super(cacheName, collocated);
            this.cap = cap;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.cap = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeInt(this.cap);
        }

        @Override
        public String toString() {
            return S.toString(QueueInfo.class, this, "super", super.toString());
        }
    }

    static class CacheCollectionInfo
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private String cacheName;
        private CollectionConfiguration cfg;

        public CacheCollectionInfo() {
        }

        public CacheCollectionInfo(String cacheName, CollectionConfiguration cfg) {
            this.cacheName = cacheName;
            this.cfg = cfg;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.cfg = (CollectionConfiguration)in.readObject();
            this.cacheName = U.readString(in);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.cfg);
            U.writeString(out, this.cacheName);
        }

        public String toString() {
            return S.toString(CacheCollectionInfo.class, this);
        }
    }

    static class CollectionInfo
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private boolean collocated;
        private String cacheName;

        public CollectionInfo() {
        }

        public CollectionInfo(String cacheName, boolean collocated) {
            this.cacheName = cacheName;
            this.collocated = collocated;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.collocated = in.readBoolean();
            this.cacheName = U.readString(in);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeBoolean(this.collocated);
            U.writeString(out, this.cacheName);
        }

        public String toString() {
            return S.toString(CollectionInfo.class, this);
        }
    }

    static enum DataStructureType {
        ATOMIC_LONG(IgniteAtomicLong.class.getSimpleName()),
        ATOMIC_REF(IgniteAtomicReference.class.getSimpleName()),
        ATOMIC_SEQ(IgniteAtomicSequence.class.getSimpleName()),
        ATOMIC_STAMPED(IgniteAtomicStamped.class.getSimpleName()),
        COUNT_DOWN_LATCH(IgniteCountDownLatch.class.getSimpleName()),
        QUEUE(IgniteQueue.class.getSimpleName()),
        SET(IgniteSet.class.getSimpleName()),
        SEMAPHORE(IgniteSemaphore.class.getSimpleName()),
        REENTRANT_LOCK(IgniteLock.class.getSimpleName());

        private static final DataStructureType[] VALS;
        private String name;

        private DataStructureType(String name) {
            this.name = name;
        }

        public String className() {
            return this.name;
        }

        @Nullable
        public static DataStructureType fromOrdinal(int ord) {
            return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
        }

        static {
            VALS = DataStructureType.values();
        }
    }

    private class DataStructuresEntryListener
    implements CacheEntryUpdatedListener<GridCacheInternalKey, GridCacheInternal> {
        private DataStructuresEntryListener() {
        }

        @Override
        public void onUpdated(Iterable<CacheEntryEvent<? extends GridCacheInternalKey, ? extends GridCacheInternal>> evts) throws CacheEntryListenerException {
            for (CacheEntryEvent<? extends GridCacheInternalKey, ? extends GridCacheInternal> evt : evts) {
                if (evt.getEventType() == EventType.CREATED || evt.getEventType() == EventType.UPDATED) {
                    GridCacheInternal val;
                    GridCacheInternalKey key;
                    GridCacheInternal val0 = (GridCacheInternal)evt.getValue();
                    if (val0 instanceof GridCacheCountDownLatchValue) {
                        key = (GridCacheInternalKey)evt.getKey();
                        final GridCacheRemovable latch = (GridCacheRemovable)DataStructuresProcessor.this.dsMap.get(key);
                        val = (GridCacheCountDownLatchValue)val0;
                        if (latch instanceof GridCacheCountDownLatchEx) {
                            final GridCacheCountDownLatchEx latch0 = (GridCacheCountDownLatchEx)latch;
                            latch0.onUpdate(((GridCacheCountDownLatchValue)val).get());
                            if (((GridCacheCountDownLatchValue)val).get() != 0 || !((GridCacheCountDownLatchValue)val).autoDelete()) continue;
                            DataStructuresProcessor.this.dsMap.remove(key);
                            IgniteInternalFuture<?> removeFut = DataStructuresProcessor.this.ctx.closure().runLocalSafe(new GPR(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        DataStructuresProcessor.this.removeCountDownLatch(latch0.name());
                                    }
                                    catch (IgniteCheckedException e) {
                                        U.error(DataStructuresProcessor.this.log, "Failed to remove count down latch: " + latch0.name(), e);
                                    }
                                    finally {
                                        DataStructuresProcessor.this.ctx.cache().context().txContextReset();
                                    }
                                }
                            });
                            removeFut.listen(new CI1<IgniteInternalFuture<?>>(){

                                @Override
                                public void apply(IgniteInternalFuture<?> f) {
                                    try {
                                        f.get();
                                    }
                                    catch (IgniteCheckedException e) {
                                        U.error(DataStructuresProcessor.this.log, "Failed to remove count down latch: " + latch0.name(), e);
                                    }
                                    latch.onRemoved();
                                }
                            });
                            continue;
                        }
                        if (latch == null) continue;
                        U.error(DataStructuresProcessor.this.log, "Failed to cast object [expected=" + IgniteCountDownLatch.class.getSimpleName() + ", actual=" + latch.getClass() + ", value=" + latch + ']');
                        continue;
                    }
                    if (val0 instanceof GridCacheSemaphoreState) {
                        key = (GridCacheInternalKey)evt.getKey();
                        GridCacheRemovable sem = (GridCacheRemovable)DataStructuresProcessor.this.dsMap.get(key);
                        val = (GridCacheSemaphoreState)val0;
                        if (sem instanceof GridCacheSemaphoreEx) {
                            GridCacheSemaphoreEx semaphore0 = (GridCacheSemaphoreEx)sem;
                            semaphore0.onUpdate((GridCacheSemaphoreState)val);
                            continue;
                        }
                        if (sem == null) continue;
                        U.error(DataStructuresProcessor.this.log, "Failed to cast object [expected=" + IgniteSemaphore.class.getSimpleName() + ", actual=" + sem.getClass() + ", value=" + sem + ']');
                        continue;
                    }
                    if (!(val0 instanceof GridCacheLockState)) continue;
                    key = (GridCacheInternalKey)evt.getKey();
                    GridCacheRemovable reentrantLock = (GridCacheRemovable)DataStructuresProcessor.this.dsMap.get(key);
                    val = (GridCacheLockState)val0;
                    if (reentrantLock instanceof GridCacheLockEx) {
                        GridCacheLockEx lock0 = (GridCacheLockEx)reentrantLock;
                        lock0.onUpdate((GridCacheLockState)val);
                        continue;
                    }
                    if (reentrantLock == null) continue;
                    U.error(DataStructuresProcessor.this.log, "Failed to cast object [expected=" + IgniteLock.class.getSimpleName() + ", actual=" + reentrantLock.getClass() + ", value=" + reentrantLock + ']');
                    continue;
                }
                assert (evt.getEventType() == EventType.REMOVED) : evt;
                GridCacheInternal key = (GridCacheInternal)evt.getKey();
                GridCacheRemovable obj = (GridCacheRemovable)DataStructuresProcessor.this.dsMap.remove(key);
                if (obj == null) continue;
                obj.onRemoved();
            }
        }

        public String toString() {
            return S.toString(DataStructuresEntryListener.class, this);
        }
    }

    static class DataStructuresEntryFilter
    implements CacheEntryEventSerializableFilter<Object, Object> {
        private static final long serialVersionUID = 0L;

        DataStructuresEntryFilter() {
        }

        @Override
        public boolean evaluate(CacheEntryEvent<?, ?> evt) throws CacheEntryListenerException {
            if (evt.getEventType() == EventType.CREATED || evt.getEventType() == EventType.UPDATED) {
                return evt.getValue() instanceof GridCacheCountDownLatchValue || evt.getValue() instanceof GridCacheSemaphoreState || evt.getValue() instanceof GridCacheLockState;
            }
            assert (evt.getEventType() == EventType.REMOVED) : evt;
            return true;
        }

        public String toString() {
            return S.toString(DataStructuresEntryFilter.class, this);
        }
    }
}

