/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicLongEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicLongValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKey;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public final class GridCacheAtomicLongImpl
implements GridCacheAtomicLongEx,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<IgniteBiTuple<GridKernalContext, String>> stash = new ThreadLocal<IgniteBiTuple<GridKernalContext, String>>(){

        @Override
        protected IgniteBiTuple<GridKernalContext, String> initialValue() {
            return new IgniteBiTuple<GridKernalContext, String>();
        }
    };
    private IgniteLogger log;
    private String name;
    private volatile boolean rmvd;
    private boolean rmvCheck;
    private GridCacheInternalKey key;
    private IgniteInternalCache<GridCacheInternalKey, GridCacheAtomicLongValue> atomicView;
    private GridCacheContext ctx;
    private final Callable<Long> getCall = new Callable<Long>(){

        @Override
        public Long call() throws Exception {
            GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)GridCacheAtomicLongImpl.this.atomicView.get(GridCacheAtomicLongImpl.this.key);
            if (val == null) {
                throw new IgniteCheckedException("Failed to find atomic long with given name: " + GridCacheAtomicLongImpl.this.name);
            }
            return val.get();
        }
    };
    private final Callable<Long> incAndGetCall = CU.retryTopologySafe(new Callable<Long>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Long call() throws Exception {
            try (IgniteInternalTx tx = CU.txStartInternal(GridCacheAtomicLongImpl.this.ctx, GridCacheAtomicLongImpl.this.atomicView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)GridCacheAtomicLongImpl.this.atomicView.get(GridCacheAtomicLongImpl.this.key);
                if (val == null) {
                    throw new IgniteCheckedException("Failed to find atomic long with given name: " + GridCacheAtomicLongImpl.this.name);
                }
                long retVal = val.get() + 1L;
                val.set(retVal);
                GridCacheAtomicLongImpl.this.atomicView.put(GridCacheAtomicLongImpl.this.key, val);
                tx.commit();
                Long l = retVal;
                return l;
            }
            catch (Error | Exception e) {
                U.error(GridCacheAtomicLongImpl.this.log, "Failed to increment and get: " + this, e);
                throw e;
            }
        }
    });
    private final Callable<Long> getAndIncCall = CU.retryTopologySafe(new Callable<Long>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Long call() throws Exception {
            try (IgniteInternalTx tx = CU.txStartInternal(GridCacheAtomicLongImpl.this.ctx, GridCacheAtomicLongImpl.this.atomicView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)GridCacheAtomicLongImpl.this.atomicView.get(GridCacheAtomicLongImpl.this.key);
                if (val == null) {
                    throw new IgniteCheckedException("Failed to find atomic long with given name: " + GridCacheAtomicLongImpl.this.name);
                }
                long retVal = val.get();
                val.set(retVal + 1L);
                GridCacheAtomicLongImpl.this.atomicView.put(GridCacheAtomicLongImpl.this.key, val);
                tx.commit();
                Long l = retVal;
                return l;
            }
            catch (Error | Exception e) {
                U.error(GridCacheAtomicLongImpl.this.log, "Failed to get and increment: " + this, e);
                throw e;
            }
        }
    });
    private final Callable<Long> decAndGetCall = CU.retryTopologySafe(new Callable<Long>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Long call() throws Exception {
            try (IgniteInternalTx tx = CU.txStartInternal(GridCacheAtomicLongImpl.this.ctx, GridCacheAtomicLongImpl.this.atomicView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)GridCacheAtomicLongImpl.this.atomicView.get(GridCacheAtomicLongImpl.this.key);
                if (val == null) {
                    throw new IgniteCheckedException("Failed to find atomic long with given name: " + GridCacheAtomicLongImpl.this.name);
                }
                long retVal = val.get() - 1L;
                val.set(retVal);
                GridCacheAtomicLongImpl.this.atomicView.put(GridCacheAtomicLongImpl.this.key, val);
                tx.commit();
                Long l = retVal;
                return l;
            }
            catch (Error | Exception e) {
                U.error(GridCacheAtomicLongImpl.this.log, "Failed to decrement and get: " + this, e);
                throw e;
            }
        }
    });
    private final Callable<Long> getAndDecCall = CU.retryTopologySafe(new Callable<Long>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Long call() throws Exception {
            try (IgniteInternalTx tx = CU.txStartInternal(GridCacheAtomicLongImpl.this.ctx, GridCacheAtomicLongImpl.this.atomicView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)GridCacheAtomicLongImpl.this.atomicView.get(GridCacheAtomicLongImpl.this.key);
                if (val == null) {
                    throw new IgniteCheckedException("Failed to find atomic long with given name: " + GridCacheAtomicLongImpl.this.name);
                }
                long retVal = val.get();
                val.set(retVal - 1L);
                GridCacheAtomicLongImpl.this.atomicView.put(GridCacheAtomicLongImpl.this.key, val);
                tx.commit();
                Long l = retVal;
                return l;
            }
            catch (Error | Exception e) {
                U.error(GridCacheAtomicLongImpl.this.log, "Failed to get and decrement and get: " + this, e);
                throw e;
            }
        }
    });

    public GridCacheAtomicLongImpl() {
    }

    public GridCacheAtomicLongImpl(String name, GridCacheInternalKey key, IgniteInternalCache<GridCacheInternalKey, GridCacheAtomicLongValue> atomicView, GridCacheContext ctx) {
        assert (key != null);
        assert (atomicView != null);
        assert (ctx != null);
        assert (name != null);
        this.ctx = ctx;
        this.key = key;
        this.atomicView = atomicView;
        this.name = name;
        this.log = ctx.logger(this.getClass());
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public long get() {
        this.checkRemoved();
        try {
            return CU.outTx(this.getCall, this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long incrementAndGet() {
        this.checkRemoved();
        try {
            return CU.outTx(this.incAndGetCall, this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long getAndIncrement() {
        this.checkRemoved();
        try {
            return CU.outTx(this.getAndIncCall, this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long addAndGet(long l) {
        this.checkRemoved();
        try {
            return CU.outTx(this.internalAddAndGet(l), this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long getAndAdd(long l) {
        this.checkRemoved();
        try {
            return CU.outTx(this.internalGetAndAdd(l), this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long decrementAndGet() {
        this.checkRemoved();
        try {
            return CU.outTx(this.decAndGetCall, this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long getAndDecrement() {
        this.checkRemoved();
        try {
            return CU.outTx(this.getAndDecCall, this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long getAndSet(long l) {
        this.checkRemoved();
        try {
            return CU.outTx(this.internalGetAndSet(l), this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean compareAndSet(long expVal, long newVal) {
        this.checkRemoved();
        try {
            return CU.outTx(this.internalCompareAndSetAndGet(expVal, newVal), this.ctx) == expVal;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public long compareAndSetAndGet(long expVal, long newVal) {
        this.checkRemoved();
        try {
            return CU.outTx(this.internalCompareAndSetAndGet(expVal, newVal), this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    private void checkRemoved() throws IllegalStateException {
        if (this.rmvd) {
            throw this.removedError();
        }
        if (this.rmvCheck) {
            try {
                this.rmvd = this.atomicView.get(this.key) == null;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            this.rmvCheck = false;
            if (this.rmvd) {
                this.ctx.kernalContext().dataStructures().onRemoved(this.key, this);
                throw this.removedError();
            }
        }
    }

    private IllegalStateException removedError() {
        return new IllegalStateException("Atomic long was removed from cache: " + this.name);
    }

    @Override
    public boolean onRemoved() {
        this.rmvd = true;
        return true;
    }

    @Override
    public void needCheckNotRemoved() {
        this.rmvCheck = true;
    }

    @Override
    public GridCacheInternalKey key() {
        return this.key;
    }

    @Override
    public boolean removed() {
        return this.rmvd;
    }

    @Override
    public void close() {
        if (this.rmvd) {
            return;
        }
        try {
            this.ctx.kernalContext().dataStructures().removeAtomicLong(this.name);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    private Callable<Long> internalAddAndGet(final long l) {
        return CU.retryTopologySafe(new Callable<Long>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Long call() throws Exception {
                try (IgniteInternalTx tx = CU.txStartInternal(GridCacheAtomicLongImpl.this.ctx, GridCacheAtomicLongImpl.this.atomicView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)GridCacheAtomicLongImpl.this.atomicView.get(GridCacheAtomicLongImpl.this.key);
                    if (val == null) {
                        throw new IgniteCheckedException("Failed to find atomic long with given name: " + GridCacheAtomicLongImpl.this.name);
                    }
                    long retVal = val.get() + l;
                    val.set(retVal);
                    GridCacheAtomicLongImpl.this.atomicView.put(GridCacheAtomicLongImpl.this.key, val);
                    tx.commit();
                    Long l2 = retVal;
                    return l2;
                }
                catch (Error | Exception e) {
                    U.error(GridCacheAtomicLongImpl.this.log, "Failed to add and get: " + this, e);
                    throw e;
                }
            }
        });
    }

    private Callable<Long> internalGetAndAdd(final long l) {
        return CU.retryTopologySafe(new Callable<Long>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Long call() throws Exception {
                try (IgniteInternalTx tx = CU.txStartInternal(GridCacheAtomicLongImpl.this.ctx, GridCacheAtomicLongImpl.this.atomicView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)GridCacheAtomicLongImpl.this.atomicView.get(GridCacheAtomicLongImpl.this.key);
                    if (val == null) {
                        throw new IgniteCheckedException("Failed to find atomic long with given name: " + GridCacheAtomicLongImpl.this.name);
                    }
                    long retVal = val.get();
                    val.set(retVal + l);
                    GridCacheAtomicLongImpl.this.atomicView.put(GridCacheAtomicLongImpl.this.key, val);
                    tx.commit();
                    Long l2 = retVal;
                    return l2;
                }
                catch (Error | Exception e) {
                    U.error(GridCacheAtomicLongImpl.this.log, "Failed to get and add: " + this, e);
                    throw e;
                }
            }
        });
    }

    private Callable<Long> internalGetAndSet(final long l) {
        return new Callable<Long>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Long call() throws Exception {
                try (IgniteInternalTx tx = CU.txStartInternal(GridCacheAtomicLongImpl.this.ctx, GridCacheAtomicLongImpl.this.atomicView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)GridCacheAtomicLongImpl.this.atomicView.get(GridCacheAtomicLongImpl.this.key);
                    if (val == null) {
                        throw new IgniteCheckedException("Failed to find atomic long with given name: " + GridCacheAtomicLongImpl.this.name);
                    }
                    long retVal = val.get();
                    val.set(l);
                    GridCacheAtomicLongImpl.this.atomicView.put(GridCacheAtomicLongImpl.this.key, val);
                    tx.commit();
                    Long l2 = retVal;
                    return l2;
                }
                catch (Error | Exception e) {
                    U.error(GridCacheAtomicLongImpl.this.log, "Failed to get and set: " + this, e);
                    throw e;
                }
            }
        };
    }

    private Callable<Long> internalCompareAndSetAndGet(final long expVal, final long newVal) {
        return new Callable<Long>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Long call() throws Exception {
                try (IgniteInternalTx tx = CU.txStartInternal(GridCacheAtomicLongImpl.this.ctx, GridCacheAtomicLongImpl.this.atomicView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)GridCacheAtomicLongImpl.this.atomicView.get(GridCacheAtomicLongImpl.this.key);
                    if (val == null) {
                        throw new IgniteCheckedException("Failed to find atomic long with given name: " + GridCacheAtomicLongImpl.this.name);
                    }
                    long retVal = val.get();
                    if (retVal == expVal) {
                        val.set(newVal);
                        GridCacheAtomicLongImpl.this.atomicView.getAndPut(GridCacheAtomicLongImpl.this.key, val);
                        tx.commit();
                    }
                    Long l = retVal;
                    return l;
                }
                catch (Error | Exception e) {
                    U.error(GridCacheAtomicLongImpl.this.log, "Failed to compare and set: " + this, e);
                    throw e;
                }
            }
        };
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx.kernalContext());
        out.writeUTF(this.name);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<GridKernalContext, String> t = stash.get();
        t.set1((GridKernalContext)in.readObject());
        t.set2(in.readUTF());
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<GridKernalContext, String> t = stash.get();
            IgniteAtomicLong igniteAtomicLong = t.get1().dataStructures().atomicLong(t.get2(), 0L, false);
            return igniteAtomicLong;
        }
        catch (IgniteCheckedException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    public String toString() {
        return S.toString(GridCacheAtomicLongImpl.class, this);
    }
}

