/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteAtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicReferenceEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicReferenceValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKey;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public final class GridCacheAtomicReferenceImpl<T>
implements GridCacheAtomicReferenceEx<T>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<IgniteBiTuple<GridKernalContext, String>> stash = new ThreadLocal<IgniteBiTuple<GridKernalContext, String>>(){

        @Override
        protected IgniteBiTuple<GridKernalContext, String> initialValue() {
            return new IgniteBiTuple<GridKernalContext, String>();
        }
    };
    private IgniteLogger log;
    private String name;
    private volatile boolean rmvd;
    private boolean rmvCheck;
    private GridCacheInternalKey key;
    private IgniteInternalCache<GridCacheInternalKey, GridCacheAtomicReferenceValue<T>> atomicView;
    private GridCacheContext ctx;
    private final Callable<T> getCall = new Callable<T>(){

        @Override
        public T call() throws Exception {
            GridCacheAtomicReferenceValue ref = (GridCacheAtomicReferenceValue)GridCacheAtomicReferenceImpl.this.atomicView.get(GridCacheAtomicReferenceImpl.this.key);
            if (ref == null) {
                throw new IgniteCheckedException("Failed to find atomic reference with given name: " + GridCacheAtomicReferenceImpl.this.name);
            }
            return ref.get();
        }
    };

    public GridCacheAtomicReferenceImpl() {
    }

    public GridCacheAtomicReferenceImpl(String name, GridCacheInternalKey key, IgniteInternalCache<GridCacheInternalKey, GridCacheAtomicReferenceValue<T>> atomicView, GridCacheContext ctx) {
        assert (key != null);
        assert (atomicView != null);
        assert (ctx != null);
        assert (name != null);
        this.ctx = ctx;
        this.key = key;
        this.atomicView = atomicView;
        this.name = name;
        this.log = ctx.logger(this.getClass());
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public T get() {
        this.checkRemoved();
        try {
            return CU.outTx(this.getCall, this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public void set(T val) {
        this.checkRemoved();
        try {
            CU.outTx(this.internalSet(val), this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean compareAndSet(T expVal, T newVal) {
        return this.compareAndSetAndGet(newVal, expVal) == expVal;
    }

    public T compareAndSetAndGet(T newVal, T expVal) {
        this.checkRemoved();
        try {
            return CU.outTx(this.internalCompareAndSetAndGet(expVal, newVal), this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean onRemoved() {
        this.rmvd = true;
        return true;
    }

    @Override
    public void needCheckNotRemoved() {
        this.rmvCheck = true;
    }

    @Override
    public GridCacheInternalKey key() {
        return this.key;
    }

    @Override
    public boolean removed() {
        return this.rmvd;
    }

    @Override
    public void close() {
        if (this.rmvd) {
            return;
        }
        try {
            this.ctx.kernalContext().dataStructures().removeAtomicReference(this.name);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    private Callable<Boolean> internalSet(final T val) {
        return GridCacheUtils.retryTopologySafe(new Callable<Boolean>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Boolean call() throws Exception {
                try (IgniteInternalTx tx = CU.txStartInternal(GridCacheAtomicReferenceImpl.this.ctx, GridCacheAtomicReferenceImpl.this.atomicView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    GridCacheAtomicReferenceValue ref = (GridCacheAtomicReferenceValue)GridCacheAtomicReferenceImpl.this.atomicView.get(GridCacheAtomicReferenceImpl.this.key);
                    if (ref == null) {
                        throw new IgniteCheckedException("Failed to find atomic reference with given name: " + GridCacheAtomicReferenceImpl.this.name);
                    }
                    ref.set(val);
                    GridCacheAtomicReferenceImpl.this.atomicView.put(GridCacheAtomicReferenceImpl.this.key, ref);
                    tx.commit();
                    Boolean bl = true;
                    return bl;
                }
                catch (Error | Exception e) {
                    U.error(GridCacheAtomicReferenceImpl.this.log, "Failed to set value [val=" + val + ", atomicReference=" + this + ']', e);
                    throw e;
                }
            }
        });
    }

    private Callable<T> internalCompareAndSetAndGet(final T expVal, final T newVal) {
        return GridCacheUtils.retryTopologySafe(new Callable<T>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public T call() throws Exception {
                try (IgniteInternalTx tx = CU.txStartInternal(GridCacheAtomicReferenceImpl.this.ctx, GridCacheAtomicReferenceImpl.this.atomicView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    GridCacheAtomicReferenceValue ref = (GridCacheAtomicReferenceValue)GridCacheAtomicReferenceImpl.this.atomicView.get(GridCacheAtomicReferenceImpl.this.key);
                    if (ref == null) {
                        throw new IgniteCheckedException("Failed to find atomic reference with given name: " + GridCacheAtomicReferenceImpl.this.name);
                    }
                    Object origVal = ref.get();
                    if (!F.eq(expVal, origVal)) {
                        tx.setRollbackOnly();
                        Object t = origVal;
                        return t;
                    }
                    ref.set(newVal);
                    GridCacheAtomicReferenceImpl.this.atomicView.getAndPut(GridCacheAtomicReferenceImpl.this.key, ref);
                    tx.commit();
                    Object object = expVal;
                    return object;
                }
                catch (Error | Exception e) {
                    U.error(GridCacheAtomicReferenceImpl.this.log, "Failed to compare and value [expVal=" + expVal + ", newVal" + newVal + ", atomicReference" + this + ']', e);
                    throw e;
                }
            }
        });
    }

    private void checkRemoved() throws IllegalStateException {
        if (this.rmvd) {
            throw this.removedError();
        }
        if (this.rmvCheck) {
            try {
                this.rmvd = this.atomicView.get(this.key) == null;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            this.rmvCheck = false;
            if (this.rmvd) {
                this.ctx.kernalContext().dataStructures().onRemoved(this.key, this);
                throw this.removedError();
            }
        }
    }

    private IllegalStateException removedError() {
        return new IllegalStateException("Atomic reference was removed from cache: " + this.name);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx.kernalContext());
        out.writeUTF(this.name);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<GridKernalContext, String> t = stash.get();
        t.set1((GridKernalContext)in.readObject());
        t.set2(in.readUTF());
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<GridKernalContext, String> t = stash.get();
            IgniteAtomicReference<Object> igniteAtomicReference = t.get1().dataStructures().atomicReference(t.get2(), null, false);
            return igniteAtomicReference;
        }
        catch (IgniteCheckedException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    public String toString() {
        return S.toString(GridCacheAtomicReferenceImpl.class, this);
    }
}

