/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicSequenceEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicSequenceValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKey;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public final class GridCacheAtomicSequenceImpl
implements GridCacheAtomicSequenceEx,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<IgniteBiTuple<GridKernalContext, String>> stash = new ThreadLocal<IgniteBiTuple<GridKernalContext, String>>(){

        @Override
        protected IgniteBiTuple<GridKernalContext, String> initialValue() {
            return new IgniteBiTuple<GridKernalContext, String>();
        }
    };
    private IgniteLogger log;
    private String name;
    private volatile boolean rmvd;
    private boolean rmvCheck;
    private GridCacheInternalKey key;
    private IgniteInternalCache<GridCacheInternalKey, GridCacheAtomicSequenceValue> seqView;
    private volatile GridCacheContext ctx;
    @GridToStringInclude(sensitive=true)
    private long locVal;
    private long upBound;
    private volatile int batchSize;
    private final Lock lock = new ReentrantLock();
    private Condition cond = this.lock.newCondition();
    private final Callable<Long> incAndGetCall = this.internalUpdate(1L, true);
    private final Callable<Long> getAndIncCall = this.internalUpdate(1L, false);
    private final AtomicBoolean updateGuard = new AtomicBoolean();

    public GridCacheAtomicSequenceImpl() {
    }

    public GridCacheAtomicSequenceImpl(String name, GridCacheInternalKey key, IgniteInternalCache<GridCacheInternalKey, GridCacheAtomicSequenceValue> seqView, GridCacheContext ctx, int batchSize, long locVal, long upBound) {
        assert (key != null);
        assert (seqView != null);
        assert (ctx != null);
        assert (locVal <= upBound);
        this.batchSize = batchSize;
        this.ctx = ctx;
        this.key = key;
        this.seqView = seqView;
        this.upBound = upBound;
        this.locVal = locVal;
        this.name = name;
        this.log = ctx.logger(this.getClass());
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long get() {
        this.checkRemoved();
        this.lock.lock();
        try {
            long l = this.locVal;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long incrementAndGet() {
        try {
            return this.internalUpdate(1L, this.incAndGetCall, true);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long getAndIncrement() {
        try {
            return this.internalUpdate(1L, this.getAndIncCall, false);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long addAndGet(long l) {
        A.ensure(l > 0L, " Parameter mustn't be less then 1: " + l);
        try {
            return this.internalUpdate(l, null, true);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long getAndAdd(long l) {
        A.ensure(l > 0L, " Parameter mustn't be less then 1: " + l);
        try {
            return this.internalUpdate(l, null, false);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long internalUpdate(long l, @Nullable Callable<Long> updateCall, boolean updated) throws IgniteCheckedException {
        this.checkRemoved();
        assert (l > 0L);
        this.lock.lock();
        try {
            if (this.locVal + l <= this.upBound) {
                long curVal = this.locVal;
                this.locVal += l;
                long l2 = updated ? this.locVal : curVal;
                return l2;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (updateCall == null) {
            updateCall = this.internalUpdate(l, updated);
        }
        while (true) {
            if (this.updateGuard.compareAndSet(false, true)) {
                try {
                    long curVal = updateCall.call();
                    return curVal;
                }
                catch (IllegalStateException | IgniteCheckedException | IgniteException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IgniteCheckedException(e);
                }
                finally {
                    this.lock.lock();
                    try {
                        this.updateGuard.set(false);
                        this.cond.signalAll();
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            }
            this.lock.lock();
            try {
                while (this.locVal >= this.upBound && this.updateGuard.get()) {
                    U.await(this.cond, 500L, TimeUnit.MILLISECONDS);
                }
                this.checkRemoved();
                if (this.locVal + l > this.upBound) continue;
                long curVal = this.locVal;
                this.locVal += l;
                long l3 = updated ? this.locVal : curVal;
                return l3;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalFuture<Long> internalUpdateAsync(long l, @Nullable Callable<Long> updateCall, boolean updated) throws IgniteCheckedException {
        this.checkRemoved();
        A.ensure(l > 0L, " Parameter mustn't be less then 1: " + l);
        this.lock.lock();
        try {
            if (this.locVal + l <= this.upBound) {
                long curVal = this.locVal;
                this.locVal += l;
                GridFinishedFuture<Long> gridFinishedFuture = new GridFinishedFuture<Long>(updated ? this.locVal : curVal);
                return gridFinishedFuture;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (updateCall == null) {
            updateCall = this.internalUpdate(l, updated);
        }
        while (true) {
            if (this.updateGuard.compareAndSet(false, true)) {
                try {
                    IgniteInternalFuture<Long> curVal = this.ctx.closures().callLocalSafe(updateCall, true);
                    return curVal;
                }
                finally {
                    this.lock.lock();
                    try {
                        this.updateGuard.set(false);
                        this.cond.signalAll();
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            }
            this.lock.lock();
            try {
                while (this.locVal >= this.upBound && this.updateGuard.get()) {
                    U.await(this.cond, 500L, TimeUnit.MILLISECONDS);
                }
                this.checkRemoved();
                if (this.locVal + l > this.upBound) continue;
                long curVal = this.locVal;
                this.locVal += l;
                GridFinishedFuture<Long> gridFinishedFuture = new GridFinishedFuture<Long>(updated ? this.locVal : curVal);
                return gridFinishedFuture;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchSize(int size) {
        A.ensure(size > 0, " Batch size can't be less then 0: " + size);
        this.lock.lock();
        try {
            this.batchSize = size;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkRemoved() throws IllegalStateException {
        if (this.rmvd) {
            throw this.removedError();
        }
        if (this.rmvCheck) {
            try {
                this.rmvd = this.seqView.get(this.key) == null;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            this.rmvCheck = false;
            if (this.rmvd) {
                this.ctx.kernalContext().dataStructures().onRemoved(this.key, this);
                throw this.removedError();
            }
        }
    }

    private IllegalStateException removedError() {
        return new IllegalStateException("Sequence was removed from cache: " + this.name);
    }

    @Override
    public boolean onRemoved() {
        this.rmvd = true;
        return true;
    }

    @Override
    public void needCheckNotRemoved() {
        this.rmvCheck = true;
    }

    @Override
    public GridCacheInternalKey key() {
        return this.key;
    }

    @Override
    public boolean removed() {
        return this.rmvd;
    }

    @Override
    public void close() {
        try {
            if (this.rmvd) {
                return;
            }
            this.ctx.kernalContext().dataStructures().removeSequence(this.name);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    private Callable<Long> internalUpdate(final long l, final boolean updated) {
        return CU.retryTopologySafe(new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Long call() throws Exception {
                try (IgniteInternalTx tx = CU.txStartInternal(GridCacheAtomicSequenceImpl.this.ctx, GridCacheAtomicSequenceImpl.this.seqView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    long newUpBound;
                    long curLocVal;
                    GridCacheAtomicSequenceValue seq = (GridCacheAtomicSequenceValue)GridCacheAtomicSequenceImpl.this.seqView.get(GridCacheAtomicSequenceImpl.this.key);
                    GridCacheAtomicSequenceImpl.this.checkRemoved();
                    assert (seq != null);
                    GridCacheAtomicSequenceImpl.this.lock.lock();
                    try {
                        long newLocVal;
                        long off;
                        curLocVal = GridCacheAtomicSequenceImpl.this.locVal;
                        if (GridCacheAtomicSequenceImpl.this.locVal + l <= GridCacheAtomicSequenceImpl.this.upBound) {
                            long retVal = GridCacheAtomicSequenceImpl.this.locVal;
                            GridCacheAtomicSequenceImpl.this.locVal += l;
                            Long l2 = updated ? GridCacheAtomicSequenceImpl.this.locVal : retVal;
                            return l2;
                        }
                        long curGlobalVal = seq.get();
                        long l3 = off = GridCacheAtomicSequenceImpl.this.batchSize > 1 ? (long)(GridCacheAtomicSequenceImpl.this.batchSize - 1) : 1L;
                        if (curLocVal + l >= curGlobalVal) {
                            newLocVal = curLocVal + l;
                            newUpBound = newLocVal + off;
                        } else {
                            newLocVal = curGlobalVal;
                            newUpBound = newLocVal + off;
                        }
                        GridCacheAtomicSequenceImpl.this.locVal = newLocVal;
                        GridCacheAtomicSequenceImpl.this.upBound = newUpBound;
                        if (updated) {
                            curLocVal = newLocVal;
                        }
                    }
                    finally {
                        GridCacheAtomicSequenceImpl.this.lock.unlock();
                    }
                    seq.set(newUpBound + 1L);
                    GridCacheAtomicSequenceImpl.this.seqView.put(GridCacheAtomicSequenceImpl.this.key, seq);
                    tx.commit();
                    Long l4 = curLocVal;
                    return l4;
                }
                catch (Error | Exception e) {
                    U.error(GridCacheAtomicSequenceImpl.this.log, "Failed to get and add: " + this, e);
                    throw e;
                }
            }
        });
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx.kernalContext());
        out.writeUTF(this.name);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<GridKernalContext, String> t = stash.get();
        t.set1((GridKernalContext)in.readObject());
        t.set2(in.readUTF());
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<GridKernalContext, String> t = stash.get();
            IgniteAtomicSequence igniteAtomicSequence = t.get1().dataStructures().sequence(t.get2(), 0L, false);
            return igniteAtomicSequence;
        }
        catch (IgniteCheckedException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    public String toString() {
        return S.toString(GridCacheAtomicSequenceImpl.class, this);
    }
}

