/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteAtomicStamped;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicStampedEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicStampedValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKey;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public final class GridCacheAtomicStampedImpl<T, S>
implements GridCacheAtomicStampedEx<T, S>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<IgniteBiTuple<GridKernalContext, String>> stash = new ThreadLocal<IgniteBiTuple<GridKernalContext, String>>(){

        @Override
        protected IgniteBiTuple<GridKernalContext, String> initialValue() {
            return new IgniteBiTuple<GridKernalContext, String>();
        }
    };
    private IgniteLogger log;
    private String name;
    private volatile boolean rmvd;
    private boolean rmvCheck;
    private GridCacheInternalKey key;
    private IgniteInternalCache<GridCacheInternalKey, GridCacheAtomicStampedValue<T, S>> atomicView;
    private GridCacheContext ctx;
    private final Callable<IgniteBiTuple<T, S>> getCall = CU.retryTopologySafe(new Callable<IgniteBiTuple<T, S>>(){

        @Override
        public IgniteBiTuple<T, S> call() throws Exception {
            GridCacheAtomicStampedValue stmp = (GridCacheAtomicStampedValue)GridCacheAtomicStampedImpl.this.atomicView.get(GridCacheAtomicStampedImpl.this.key);
            if (stmp == null) {
                throw new IgniteCheckedException("Failed to find atomic stamped with given name: " + GridCacheAtomicStampedImpl.this.name);
            }
            return stmp.get();
        }
    });
    private final Callable<T> valCall = CU.retryTopologySafe(new Callable<T>(){

        @Override
        public T call() throws Exception {
            GridCacheAtomicStampedValue stmp = (GridCacheAtomicStampedValue)GridCacheAtomicStampedImpl.this.atomicView.get(GridCacheAtomicStampedImpl.this.key);
            if (stmp == null) {
                throw new IgniteCheckedException("Failed to find atomic stamped with given name: " + GridCacheAtomicStampedImpl.this.name);
            }
            return stmp.value();
        }
    });
    private final Callable<S> stampCall = CU.retryTopologySafe(new Callable<S>(){

        @Override
        public S call() throws Exception {
            GridCacheAtomicStampedValue stmp = (GridCacheAtomicStampedValue)GridCacheAtomicStampedImpl.this.atomicView.get(GridCacheAtomicStampedImpl.this.key);
            if (stmp == null) {
                throw new IgniteCheckedException("Failed to find atomic stamped with given name: " + GridCacheAtomicStampedImpl.this.name);
            }
            return stmp.stamp();
        }
    });

    public GridCacheAtomicStampedImpl() {
    }

    public GridCacheAtomicStampedImpl(String name, GridCacheInternalKey key, IgniteInternalCache<GridCacheInternalKey, GridCacheAtomicStampedValue<T, S>> atomicView, GridCacheContext ctx) {
        assert (key != null);
        assert (atomicView != null);
        assert (ctx != null);
        assert (name != null);
        this.ctx = ctx;
        this.key = key;
        this.atomicView = atomicView;
        this.name = name;
        this.log = ctx.logger(this.getClass());
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public IgniteBiTuple<T, S> get() {
        this.checkRemoved();
        try {
            return CU.outTx(this.getCall, this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public void set(T val, S stamp) {
        this.checkRemoved();
        try {
            CU.outTx(this.internalSet(val, stamp), this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean compareAndSet(T expVal, T newVal, S expStamp, S newStamp) {
        this.checkRemoved();
        try {
            return CU.outTx(this.internalCompareAndSet(F0.equalTo(expVal), this.wrapperClosure(newVal), F0.equalTo(expStamp), this.wrapperClosure(newStamp)), this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public S stamp() {
        this.checkRemoved();
        try {
            return CU.outTx(this.stampCall, this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public T value() {
        this.checkRemoved();
        try {
            return CU.outTx(this.valCall, this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean onRemoved() {
        this.rmvd = true;
        return true;
    }

    @Override
    public void needCheckNotRemoved() {
        this.rmvCheck = true;
    }

    @Override
    public GridCacheInternalKey key() {
        return this.key;
    }

    @Override
    public boolean removed() {
        return this.rmvd;
    }

    @Override
    public void close() {
        if (this.rmvd) {
            return;
        }
        try {
            this.ctx.kernalContext().dataStructures().removeAtomicStamped(this.name);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    private <N> IgniteClosure<N, N> wrapperClosure(final N val) {
        return new IgniteClosure<N, N>(){

            @Override
            public N apply(N e) {
                return val;
            }
        };
    }

    private Callable<Boolean> internalSet(final T val, final S stamp) {
        return CU.retryTopologySafe(new Callable<Boolean>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Boolean call() throws Exception {
                try (IgniteInternalTx tx = CU.txStartInternal(GridCacheAtomicStampedImpl.this.ctx, GridCacheAtomicStampedImpl.this.atomicView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    GridCacheAtomicStampedValue stmp = (GridCacheAtomicStampedValue)GridCacheAtomicStampedImpl.this.atomicView.get(GridCacheAtomicStampedImpl.this.key);
                    if (stmp == null) {
                        throw new IgniteCheckedException("Failed to find atomic stamped with given name: " + GridCacheAtomicStampedImpl.this.name);
                    }
                    stmp.set(val, stamp);
                    GridCacheAtomicStampedImpl.this.atomicView.put(GridCacheAtomicStampedImpl.this.key, stmp);
                    tx.commit();
                    Boolean bl = true;
                    return bl;
                }
                catch (Error | Exception e) {
                    U.error(GridCacheAtomicStampedImpl.this.log, "Failed to set [val=" + val + ", stamp=" + stamp + ", atomicStamped=" + this + ']', e);
                    throw e;
                }
            }
        });
    }

    private Callable<Boolean> internalCompareAndSet(final IgnitePredicate<T> expValPred, final IgniteClosure<T, T> newValClos, final IgnitePredicate<S> expStampPred, final IgniteClosure<S, S> newStampClos) {
        return CU.retryTopologySafe(new Callable<Boolean>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Boolean call() throws Exception {
                try (IgniteInternalTx tx = CU.txStartInternal(GridCacheAtomicStampedImpl.this.ctx, GridCacheAtomicStampedImpl.this.atomicView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    GridCacheAtomicStampedValue stmp = (GridCacheAtomicStampedValue)GridCacheAtomicStampedImpl.this.atomicView.get(GridCacheAtomicStampedImpl.this.key);
                    if (stmp == null) {
                        throw new IgniteCheckedException("Failed to find atomic stamped with given name: " + GridCacheAtomicStampedImpl.this.name);
                    }
                    if (!expValPred.apply(stmp.value()) || !expStampPred.apply(stmp.stamp())) {
                        tx.setRollbackOnly();
                        Boolean bl = false;
                        return bl;
                    }
                    stmp.set(newValClos.apply(stmp.value()), newStampClos.apply(stmp.stamp()));
                    GridCacheAtomicStampedImpl.this.atomicView.getAndPut(GridCacheAtomicStampedImpl.this.key, stmp);
                    tx.commit();
                    Boolean bl = true;
                    return bl;
                }
                catch (Error | Exception e) {
                    U.error(GridCacheAtomicStampedImpl.this.log, "Failed to compare and set [expValPred=" + expValPred + ", newValClos=" + newValClos + ", expStampPred=" + expStampPred + ", newStampClos=" + newStampClos + ", atomicStamped=" + this + ']', e);
                    throw e;
                }
            }
        });
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx.kernalContext());
        out.writeUTF(this.name);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<GridKernalContext, String> t = stash.get();
        t.set1((GridKernalContext)in.readObject());
        t.set2(in.readUTF());
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<GridKernalContext, String> t = stash.get();
            IgniteAtomicStamped<Object, Object> igniteAtomicStamped = t.get1().dataStructures().atomicStamped(t.get2(), null, null, false);
            return igniteAtomicStamped;
        }
        catch (IgniteCheckedException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    private void checkRemoved() throws IllegalStateException {
        if (this.rmvd) {
            throw this.removedError();
        }
        if (this.rmvCheck) {
            try {
                this.rmvd = this.atomicView.get(this.key) == null;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            this.rmvCheck = false;
            if (this.rmvd) {
                this.ctx.kernalContext().dataStructures().onRemoved(this.key, this);
                throw this.removedError();
            }
        }
    }

    private IllegalStateException removedError() {
        return new IllegalStateException("Atomic stamped was removed from cache: " + this.name);
    }

    public String toString() {
        return GridToStringBuilder.toString(GridCacheAtomicStampedImpl.class, this);
    }
}

