/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.util.lang.GridPeerDeployAware;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiTuple;

public final class GridCacheAtomicStampedValue<T, S>
implements GridCacheInternal,
GridPeerDeployAware,
Externalizable {
    private static final long serialVersionUID = 0L;
    private T val;
    private S stamp;

    public GridCacheAtomicStampedValue(T val, S stamp) {
        this.val = val;
        this.stamp = stamp;
    }

    public GridCacheAtomicStampedValue() {
    }

    public void set(T val, S stamp) {
        this.val = val;
        this.stamp = stamp;
    }

    public IgniteBiTuple<T, S> get() {
        return F.t(this.val, this.stamp);
    }

    public T value() {
        return this.val;
    }

    public S stamp() {
        return this.stamp;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.val);
        out.writeObject(this.stamp);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.val = in.readObject();
        this.stamp = in.readObject();
    }

    @Override
    public Class<?> deployClass() {
        ClassLoader clsLdr = this.getClass().getClassLoader();
        return this.stamp != null && !clsLdr.equals(this.stamp.getClass().getClassLoader()) ? this.stamp.getClass() : (this.val != null ? this.val.getClass() : this.getClass());
    }

    @Override
    public ClassLoader classLoader() {
        return this.deployClass().getClassLoader();
    }

    public String toString() {
        return GridToStringBuilder.toString(GridCacheAtomicStampedValue.class, this);
    }
}

