/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteQueue;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheGateway;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueAdapter;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.jetbrains.annotations.Nullable;

public class GridCacheQueueProxy<T>
implements IgniteQueue<T>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<IgniteBiTuple<GridKernalContext, String>> stash = new ThreadLocal<IgniteBiTuple<GridKernalContext, String>>(){

        @Override
        protected IgniteBiTuple<GridKernalContext, String> initialValue() {
            return new IgniteBiTuple<GridKernalContext, String>();
        }
    };
    private GridCacheQueueAdapter<T> delegate;
    private GridCacheContext cctx;
    private GridCacheGateway gate;

    public GridCacheQueueProxy() {
    }

    public GridCacheQueueProxy(GridCacheContext cctx, GridCacheQueueAdapter<T> delegate) {
        this.cctx = cctx;
        this.delegate = delegate;
        this.gate = cctx.gate();
    }

    public GridCacheQueueAdapter<T> delegate() {
        return this.delegate;
    }

    @Override
    public boolean add(final T item) {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                boolean bl = CU.outTx(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.add(item);
                    }
                }, this.cctx);
                return bl;
            }
            boolean bl = this.delegate.add(item);
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean offer(final T item) {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                boolean bl = CU.outTx(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.offer(item);
                    }
                }, this.cctx);
                return bl;
            }
            boolean bl = this.delegate.offer(item);
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean addAll(final Collection<? extends T> items) {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                boolean bl = CU.outTx(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.addAll(items);
                    }
                }, this.cctx);
                return bl;
            }
            boolean bl = this.delegate.addAll(items);
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean contains(final Object item) {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                boolean bl = CU.outTx(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.contains(item);
                    }
                }, this.cctx);
                return bl;
            }
            boolean bl = this.delegate.contains(item);
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean containsAll(final Collection<?> items) {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                boolean bl = CU.outTx(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.containsAll(items);
                    }
                }, this.cctx);
                return bl;
            }
            boolean bl = this.delegate.containsAll(items);
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public void clear() {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                CU.outTx(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        GridCacheQueueProxy.this.delegate.clear();
                        return null;
                    }
                }, this.cctx);
            } else {
                this.delegate.clear();
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean remove(final Object item) {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                boolean bl = CU.outTx(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.remove(item);
                    }
                }, this.cctx);
                return bl;
            }
            boolean bl = this.delegate.remove(item);
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean removeAll(final Collection<?> items) {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                boolean bl = CU.outTx(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.removeAll(items);
                    }
                }, this.cctx);
                return bl;
            }
            boolean bl = this.delegate.removeAll(items);
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean isEmpty() {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                boolean bl = CU.outTx(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.isEmpty();
                    }
                }, this.cctx);
                return bl;
            }
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public Iterator<T> iterator() {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                Iterator iterator = (Iterator)CU.outTx(new Callable<Iterator<T>>(){

                    @Override
                    public Iterator<T> call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.iterator();
                    }
                }, this.cctx);
                return iterator;
            }
            Iterator<T> iterator = this.delegate.iterator();
            return iterator;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public Object[] toArray() {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                Object[] objectArray = CU.outTx(new Callable<Object[]>(){

                    @Override
                    public Object[] call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.toArray();
                    }
                }, this.cctx);
                return objectArray;
            }
            Object[] objectArray = this.delegate.toArray();
            return objectArray;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public <T1> T1[] toArray(final T1[] a) {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                T1[] T1Array = CU.outTx(new Callable<T1[]>(){

                    @Override
                    public T1[] call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.toArray(a);
                    }
                }, this.cctx);
                return T1Array;
            }
            T1[] T1Array = this.delegate.toArray(a);
            return T1Array;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean retainAll(final Collection<?> items) {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                boolean bl = CU.outTx(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.retainAll(items);
                    }
                }, this.cctx);
                return bl;
            }
            boolean bl = this.delegate.retainAll(items);
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public int size() {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                int n = CU.outTx(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.size();
                    }
                }, this.cctx);
                return n;
            }
            int n = this.delegate.size();
            return n;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    @Nullable
    public T poll() {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                Object t = CU.outTx(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.poll();
                    }
                }, this.cctx);
                return t;
            }
            Object t = this.delegate.poll();
            return t;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    @Nullable
    public T peek() {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                Object t = CU.outTx(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.peek();
                    }
                }, this.cctx);
                return t;
            }
            T t = this.delegate.peek();
            return t;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public void clear(final int batchSize) {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                CU.outTx(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        GridCacheQueueProxy.this.delegate.clear(batchSize);
                        return null;
                    }
                }, this.cctx);
            } else {
                this.delegate.clear(batchSize);
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public int remainingCapacity() {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                int n = CU.outTx(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.remainingCapacity();
                    }
                }, this.cctx);
                return n;
            }
            int n = this.delegate.remainingCapacity();
            return n;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public int drainTo(final Collection<? super T> c) {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                int n = CU.outTx(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.drainTo(c);
                    }
                }, this.cctx);
                return n;
            }
            int n = this.delegate.drainTo(c);
            return n;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public int drainTo(final Collection<? super T> c, final int maxElements) {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                int n = CU.outTx(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.drainTo(c, maxElements);
                    }
                }, this.cctx);
                return n;
            }
            int n = this.delegate.drainTo(c, maxElements);
            return n;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public T remove() {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                Object t = CU.outTx(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.remove();
                    }
                }, this.cctx);
                return t;
            }
            T t = this.delegate.remove();
            return t;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public T element() {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                Object t = CU.outTx(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.element();
                    }
                }, this.cctx);
                return t;
            }
            T t = this.delegate.element();
            return t;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public void put(final T item) {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                CU.outTx(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        GridCacheQueueProxy.this.delegate.put(item);
                        return null;
                    }
                }, this.cctx);
            } else {
                this.delegate.put(item);
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean offer(final T item, final long timeout, final TimeUnit unit) {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                boolean bl = CU.outTx(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.offer(item, timeout, unit);
                    }
                }, this.cctx);
                return bl;
            }
            boolean bl = this.delegate.offer(item, timeout, unit);
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    @Nullable
    public T take() {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                Object t = CU.outTx(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.take();
                    }
                }, this.cctx);
                return t;
            }
            T t = this.delegate.take();
            return t;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    @Nullable
    public T poll(final long timeout, final TimeUnit unit) {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                Object t = CU.outTx(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return GridCacheQueueProxy.this.delegate.poll(timeout, unit);
                    }
                }, this.cctx);
                return t;
            }
            T t = this.delegate.poll(timeout, unit);
            return t;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public void close() {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                CU.outTx(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        GridCacheQueueProxy.this.delegate.close();
                        return null;
                    }
                }, this.cctx);
            } else {
                this.delegate.close();
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public int capacity() {
        return this.delegate.capacity();
    }

    @Override
    public boolean bounded() {
        return this.delegate.bounded();
    }

    @Override
    public boolean collocated() {
        return this.delegate.collocated();
    }

    @Override
    public boolean removed() {
        return this.delegate.removed();
    }

    @Override
    public void affinityRun(IgniteRunnable job) {
        this.delegate.affinityRun(job);
    }

    @Override
    public <R> R affinityCall(IgniteCallable<R> job) {
        return this.delegate.affinityCall(job);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridCacheQueueProxy that = (GridCacheQueueProxy)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cctx.kernalContext());
        U.writeString(out, this.name());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<GridKernalContext, String> t = stash.get();
        t.set1((GridKernalContext)in.readObject());
        t.set2(U.readString(in));
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<GridKernalContext, String> t = stash.get();
            IgniteQueue igniteQueue = t.get1().dataStructures().queue(t.get2(), 0, null);
            return igniteQueue;
        }
        catch (IgniteCheckedException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

