/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSet;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheGateway;
import org.apache.ignite.internal.processors.datastructures.GridCacheSetImpl;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.jetbrains.annotations.NotNull;

public class GridCacheSetProxy<T>
implements IgniteSet<T>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<IgniteBiTuple<GridKernalContext, String>> stash = new ThreadLocal<IgniteBiTuple<GridKernalContext, String>>(){

        @Override
        protected IgniteBiTuple<GridKernalContext, String> initialValue() {
            return new IgniteBiTuple<GridKernalContext, String>();
        }
    };
    private GridCacheSetImpl<T> delegate;
    private GridCacheContext cctx;
    private GridCacheGateway gate;
    private GridSpinBusyLock busyLock;
    private boolean rmvCheck;

    public GridCacheSetProxy() {
    }

    public GridCacheSetProxy(GridCacheContext cctx, GridCacheSetImpl<T> delegate) {
        this.cctx = cctx;
        this.delegate = delegate;
        this.gate = cctx.gate();
        this.busyLock = new GridSpinBusyLock();
    }

    public GridCacheSetImpl delegate() {
        return this.delegate;
    }

    public void blockOnRemove() {
        this.delegate.removed(true);
        this.busyLock.block();
    }

    /*
     * Loose catch block
     */
    @Override
    public int size() {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                if (this.cctx.transactional()) {
                    int n = CU.outTx(new Callable<Integer>(){

                        @Override
                        public Integer call() throws Exception {
                            return GridCacheSetProxy.this.delegate.size();
                        }
                    }, this.cctx);
                    return n;
                }
                int n = this.delegate.size();
                return n;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.gate.leave();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean isEmpty() {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                if (this.cctx.transactional()) {
                    boolean bl = CU.outTx(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return GridCacheSetProxy.this.delegate.isEmpty();
                        }
                    }, this.cctx);
                    return bl;
                }
                boolean bl = this.delegate.isEmpty();
                return bl;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.gate.leave();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean contains(final Object o) {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                if (this.cctx.transactional()) {
                    boolean bl = CU.outTx(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return GridCacheSetProxy.this.delegate.contains(o);
                        }
                    }, this.cctx);
                    return bl;
                }
                boolean bl = this.delegate.contains(o);
                return bl;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.gate.leave();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    @NotNull
    public Object[] toArray() {
        this.enterBusy();
        try {
            Object[] objectArray;
            this.gate.enter();
            try {
                if (this.cctx.transactional()) {
                    Object[] objectArray2 = CU.outTx(new Callable<Object[]>(){

                        @Override
                        public Object[] call() throws Exception {
                            return GridCacheSetProxy.this.delegate.toArray();
                        }
                    }, this.cctx);
                    return objectArray2;
                }
                objectArray = this.delegate.toArray();
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.gate.leave();
            }
            return objectArray;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    @NotNull
    public <T1> T1[] toArray(final T1[] a) {
        this.enterBusy();
        try {
            T1[] T1Array;
            this.gate.enter();
            try {
                if (this.cctx.transactional()) {
                    T1[] T1Array2 = CU.outTx(new Callable<T1[]>(){

                        @Override
                        public T1[] call() throws Exception {
                            return GridCacheSetProxy.this.delegate.toArray((T[])a);
                        }
                    }, this.cctx);
                    return T1Array2;
                }
                T1Array = this.delegate.toArray((T[])a);
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.gate.leave();
            }
            return T1Array;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean add(final T t) {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                if (this.cctx.transactional()) {
                    boolean bl = CU.outTx(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return GridCacheSetProxy.this.delegate.add(t);
                        }
                    }, this.cctx);
                    return bl;
                }
                boolean bl = this.delegate.add(t);
                return bl;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.gate.leave();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean remove(final Object o) {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                if (this.cctx.transactional()) {
                    boolean bl = CU.outTx(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return GridCacheSetProxy.this.delegate.remove(o);
                        }
                    }, this.cctx);
                    return bl;
                }
                boolean bl = this.delegate.remove(o);
                return bl;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.gate.leave();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean containsAll(final Collection<?> c) {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                if (this.cctx.transactional()) {
                    boolean bl = CU.outTx(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return GridCacheSetProxy.this.delegate.containsAll(c);
                        }
                    }, this.cctx);
                    return bl;
                }
                boolean bl = this.delegate.containsAll(c);
                return bl;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.gate.leave();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean addAll(final Collection<? extends T> c) {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                if (this.cctx.transactional()) {
                    boolean bl = CU.outTx(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return GridCacheSetProxy.this.delegate.addAll(c);
                        }
                    }, this.cctx);
                    return bl;
                }
                boolean bl = this.delegate.addAll(c);
                return bl;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.gate.leave();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean retainAll(final Collection<?> c) {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                if (this.cctx.transactional()) {
                    boolean bl = CU.outTx(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return GridCacheSetProxy.this.delegate.retainAll(c);
                        }
                    }, this.cctx);
                    return bl;
                }
                boolean bl = this.delegate.retainAll(c);
                return bl;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.gate.leave();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean removeAll(final Collection<?> c) {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                if (this.cctx.transactional()) {
                    boolean bl = CU.outTx(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return GridCacheSetProxy.this.delegate.removeAll(c);
                        }
                    }, this.cctx);
                    return bl;
                }
                boolean bl = this.delegate.removeAll(c);
                return bl;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.gate.leave();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                if (this.cctx.transactional()) {
                    CU.outTx(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            GridCacheSetProxy.this.delegate.clear();
                            return null;
                        }
                    }, this.cctx);
                } else {
                    this.delegate.clear();
                }
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.gate.leave();
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Iterator<T> iterator() {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                if (this.cctx.transactional()) {
                    Iterator iterator = (Iterator)CU.outTx(new Callable<Iterator<T>>(){

                        @Override
                        public Iterator<T> call() throws Exception {
                            return GridCacheSetProxy.this.delegate.iterator();
                        }
                    }, this.cctx);
                    return iterator;
                }
                Iterator<T> iterator = this.delegate.iterator();
                return iterator;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.gate.leave();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public void close() {
        this.gate.enter();
        try {
            if (this.cctx.transactional()) {
                CU.outTx(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        GridCacheSetProxy.this.delegate.close();
                        return null;
                    }
                }, this.cctx);
            } else {
                this.delegate.close();
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public boolean collocated() {
        return this.delegate.collocated();
    }

    @Override
    public boolean removed() {
        return this.delegate.removed();
    }

    @Override
    public void affinityRun(IgniteRunnable job) {
        this.delegate.affinityRun(job);
    }

    @Override
    public <R> R affinityCall(IgniteCallable<R> job) {
        return this.delegate.affinityCall(job);
    }

    private void enterBusy() {
        if (this.rmvCheck) {
            boolean rmvd;
            try {
                rmvd = !this.delegate().checkHeader();
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            this.rmvCheck = false;
            if (rmvd) {
                this.delegate.removed(true);
                this.cctx.dataStructures().onRemoved(this);
                throw this.removedError();
            }
        }
        if (!this.busyLock.enterBusy()) {
            throw this.removedError();
        }
    }

    public void needCheckNotRemoved() {
        this.rmvCheck = true;
    }

    private IllegalStateException removedError() {
        return new IllegalStateException("Set has been removed from cache: " + this.delegate);
    }

    private void leaveBusy() {
        this.busyLock.leaveBusy();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cctx.kernalContext());
        U.writeString(out, this.name());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<GridKernalContext, String> t = stash.get();
        t.set1((GridKernalContext)in.readObject());
        t.set2(U.readString(in));
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<GridKernalContext, String> t = stash.get();
            IgniteSet igniteSet = t.get1().dataStructures().set(t.get2(), null);
            return igniteSet;
        }
        catch (IgniteCheckedException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

