/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.hadoop;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.hadoop.HadoopHelper;
import org.apache.ignite.internal.processors.hadoop.HadoopJob;
import org.apache.ignite.internal.processors.hadoop.HadoopJobId;
import org.apache.ignite.internal.processors.hadoop.HadoopJobInfo;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class HadoopDefaultJobInfo
implements HadoopJobInfo,
Externalizable {
    private static final long serialVersionUID = 5489900236464999951L;
    private boolean hasCombiner;
    private int numReduces;
    private Map<String, String> props = new HashMap<String, String>();
    private String jobName;
    private String user;

    public HadoopDefaultJobInfo() {
    }

    public HadoopDefaultJobInfo(String jobName, String user, boolean hasCombiner, int numReduces, Map<String, String> props) {
        this.jobName = jobName;
        this.user = user;
        this.hasCombiner = hasCombiner;
        this.numReduces = numReduces;
        this.props = props;
    }

    @Override
    @Nullable
    public String property(String name) {
        return this.props.get(name);
    }

    @Override
    public HadoopJob createJob(Class<? extends HadoopJob> jobCls, HadoopJobId jobId, IgniteLogger log, @Nullable String[] libNames, HadoopHelper helper) throws IgniteCheckedException {
        assert (jobCls != null);
        try {
            Constructor<? extends HadoopJob> constructor = jobCls.getConstructor(HadoopJobId.class, HadoopDefaultJobInfo.class, IgniteLogger.class, String[].class, HadoopHelper.class);
            return constructor.newInstance(jobId, this, log, libNames, helper);
        }
        catch (Throwable t) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new IgniteCheckedException(t);
        }
    }

    @Override
    public boolean hasCombiner() {
        return this.hasCombiner;
    }

    @Override
    public boolean hasReducer() {
        return this.reducers() > 0;
    }

    @Override
    public int reducers() {
        return this.numReduces;
    }

    @Override
    public String jobName() {
        return this.jobName;
    }

    @Override
    public String user() {
        return this.user;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.jobName);
        U.writeString(out, this.user);
        out.writeBoolean(this.hasCombiner);
        out.writeInt(this.numReduces);
        U.writeStringMap(out, this.props);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.jobName = U.readString(in);
        this.user = U.readString(in);
        this.hasCombiner = in.readBoolean();
        this.numReduces = in.readInt();
        this.props = U.readStringMap(in);
    }

    public Map<String, String> properties() {
        return this.props;
    }
}

