/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.hadoop;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class HadoopJobId
implements Message,
GridCacheInternal,
Externalizable {
    private static final long serialVersionUID = 0L;
    private UUID nodeId;
    private int jobId;

    public HadoopJobId() {
    }

    public HadoopJobId(UUID nodeId, int jobId) {
        this.nodeId = nodeId;
        this.jobId = jobId;
    }

    public UUID globalId() {
        return this.nodeId;
    }

    public int localId() {
        return this.jobId;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeUuid("nodeId", this.nodeId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeInt("localId", this.jobId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.nodeId = reader.readUuid("nodeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.jobId = reader.readInt("jobId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HadoopJobId.class);
    }

    @Override
    public byte directType() {
        return -39;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeUuid(out, this.nodeId);
        out.writeInt(this.jobId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeId = U.readUuid(in);
        this.jobId = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HadoopJobId that = (HadoopJobId)o;
        if (this.jobId != that.jobId) {
            return false;
        }
        return this.nodeId.equals(that.nodeId);
    }

    public int hashCode() {
        return 31 * this.nodeId.hashCode() + this.jobId;
    }

    public String toString() {
        return this.nodeId + "_" + this.jobId;
    }
}

