/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.hadoop.shuffle;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.processors.hadoop.HadoopJobId;
import org.apache.ignite.internal.processors.hadoop.message.HadoopMessage;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class HadoopShuffleAck
implements HadoopMessage,
Message {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private long msgId;
    @GridToStringInclude
    private HadoopJobId jobId;

    public HadoopShuffleAck() {
    }

    public HadoopShuffleAck(long msgId, HadoopJobId jobId) {
        assert (jobId != null);
        this.msgId = msgId;
        this.jobId = jobId;
    }

    public long id() {
        return this.msgId;
    }

    public HadoopJobId jobId() {
        return this.jobId;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeLong("msgId", this.msgId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeMessage("jobId", this.jobId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msgId = reader.readLong("msgId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.jobId = (HadoopJobId)reader.readMessage("jobId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HadoopShuffleAck.class);
    }

    @Override
    public byte directType() {
        return -38;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.jobId.writeExternal(out);
        out.writeLong(this.msgId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.jobId = new HadoopJobId();
        this.jobId.readExternal(in);
        this.msgId = in.readLong();
    }

    public String toString() {
        return S.toString(HadoopShuffleAck.class, this);
    }
}

