/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.hadoop.shuffle;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.processors.hadoop.HadoopJobId;
import org.apache.ignite.internal.processors.hadoop.message.HadoopMessage;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class HadoopShuffleFinishRequest
implements Message,
HadoopMessage {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private HadoopJobId jobId;
    private long msgCnt;

    public HadoopShuffleFinishRequest() {
    }

    public HadoopShuffleFinishRequest(HadoopJobId jobId, long msgCnt) {
        this.jobId = jobId;
        this.msgCnt = msgCnt;
    }

    public HadoopJobId jobId() {
        return this.jobId;
    }

    public long messageCount() {
        return this.msgCnt;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeMessage("jobId", this.jobId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("msgCnt", this.msgCnt)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.jobId = (HadoopJobId)reader.readMessage("jobId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msgCnt = reader.readLong("msgCnt");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HadoopShuffleFinishRequest.class);
    }

    @Override
    public byte directType() {
        return -40;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.jobId.writeExternal(out);
        out.writeLong(this.msgCnt);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.jobId = new HadoopJobId();
        this.jobId.readExternal(in);
        this.msgCnt = in.readLong();
    }

    public String toString() {
        return S.toString(HadoopShuffleFinishRequest.class, this);
    }
}

