/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GridInternal
public final class IgfsBlockKey
implements Message,
Externalizable,
Binarylizable,
Comparable<IgfsBlockKey> {
    private static final long serialVersionUID = 0L;
    private IgniteUuid fileId;
    private long blockId;
    private IgniteUuid affKey;
    private boolean evictExclude;

    public IgfsBlockKey(IgniteUuid fileId, @Nullable IgniteUuid affKey, boolean evictExclude, long blockId) {
        assert (fileId != null);
        assert (blockId >= 0L);
        this.fileId = fileId;
        this.affKey = affKey;
        this.evictExclude = evictExclude;
        this.blockId = blockId;
    }

    public IgfsBlockKey() {
    }

    public IgniteUuid getFileId() {
        return this.fileId;
    }

    public IgniteUuid affinityKey() {
        return this.affKey;
    }

    public boolean evictExclude() {
        return this.evictExclude;
    }

    public long getBlockId() {
        return this.blockId;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public int compareTo(@NotNull IgfsBlockKey o) {
        int res = this.fileId.compareTo(o.fileId);
        if (res != 0) {
            return res;
        }
        long v1 = this.blockId;
        long v2 = o.blockId;
        if (v1 != v2) {
            return v1 > v2 ? 1 : -1;
        }
        if (this.affKey == null && o.affKey == null) {
            return 0;
        }
        if (this.affKey != null && o.affKey != null) {
            return this.affKey.compareTo(o.affKey);
        }
        return this.affKey != null ? -1 : 1;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeGridUuid(out, this.fileId);
        U.writeGridUuid(out, this.affKey);
        out.writeBoolean(this.evictExclude);
        out.writeLong(this.blockId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.fileId = U.readGridUuid(in);
        this.affKey = U.readGridUuid(in);
        this.evictExclude = in.readBoolean();
        this.blockId = in.readLong();
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        BinaryUtils.writeIgniteUuid(out, this.fileId);
        BinaryUtils.writeIgniteUuid(out, this.affKey);
        out.writeBoolean(this.evictExclude);
        out.writeLong(this.blockId);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.fileId = BinaryUtils.readIgniteUuid(in);
        this.affKey = BinaryUtils.readIgniteUuid(in);
        this.evictExclude = in.readBoolean();
        this.blockId = in.readLong();
    }

    public int hashCode() {
        return this.fileId.hashCode() + (int)(this.blockId ^ this.blockId >>> 32);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        IgfsBlockKey that = (IgfsBlockKey)o;
        return this.blockId == that.blockId && this.fileId.equals(that.fileId) && F.eq(this.affKey, that.affKey) && this.evictExclude == that.evictExclude;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeIgniteUuid("affKey", this.affKey)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("blockId", this.blockId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeBoolean("evictExclude", this.evictExclude)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeIgniteUuid("fileId", this.fileId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.affKey = reader.readIgniteUuid("affKey");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.blockId = reader.readLong("blockId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.evictExclude = reader.readBoolean("evictExclude");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.fileId = reader.readIgniteUuid("fileId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(IgfsBlockKey.class);
    }

    @Override
    public byte directType() {
        return 65;
    }

    @Override
    public byte fieldsCount() {
        return 4;
    }

    public String toString() {
        return S.toString(IgfsBlockKey.class, this);
    }
}

