/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.igfs.IgfsCommunicationMessage;
import org.apache.ignite.internal.processors.igfs.IgfsFileAffinityRange;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class IgfsFragmentizerRequest
extends IgfsCommunicationMessage {
    private static final long serialVersionUID = 0L;
    private IgniteUuid fileId;
    @GridToStringInclude
    @GridDirectCollection(value=IgfsFileAffinityRange.class)
    private Collection<IgfsFileAffinityRange> fragmentRanges;

    public IgfsFragmentizerRequest() {
    }

    public IgfsFragmentizerRequest(IgniteUuid fileId, Collection<IgfsFileAffinityRange> fragmentRanges) {
        this.fileId = fileId;
        this.fragmentRanges = fragmentRanges;
    }

    public IgniteUuid fileId() {
        return this.fileId;
    }

    public Collection<IgfsFileAffinityRange> fragmentRanges() {
        return this.fragmentRanges;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(IgfsFragmentizerRequest.class, this);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeIgniteUuid("fileId", this.fileId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeCollection("fragmentRanges", this.fragmentRanges, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.fileId = reader.readIgniteUuid("fileId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.fragmentRanges = reader.readCollection("fragmentRanges", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(IgfsFragmentizerRequest.class);
    }

    @Override
    public byte directType() {
        return 69;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }
}

