/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.processors.igfs.IgfsPaths;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IgfsHandshakeResponse
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private String igfsName;
    private IgfsPaths paths;
    private long blockSize;
    private Boolean sampling;

    public IgfsHandshakeResponse() {
    }

    public IgfsHandshakeResponse(String igfsName, IgfsPaths paths, long blockSize, Boolean sampling) {
        assert (paths != null);
        this.igfsName = igfsName;
        this.paths = paths;
        this.blockSize = blockSize;
        this.sampling = sampling;
    }

    public String igfsName() {
        return this.igfsName;
    }

    public IgfsPaths secondaryPaths() {
        return this.paths;
    }

    public long blockSize() {
        return this.blockSize;
    }

    public Boolean sampling() {
        return this.sampling;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.igfsName);
        this.paths.writeExternal(out);
        out.writeLong(this.blockSize);
        if (this.sampling != null) {
            out.writeBoolean(true);
            out.writeBoolean(this.sampling);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.igfsName = U.readString(in);
        this.paths = new IgfsPaths();
        this.paths.readExternal(in);
        this.blockSize = in.readLong();
        if (in.readBoolean()) {
            this.sampling = in.readBoolean();
        }
    }
}

