/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.IOException;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystem;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystemPositionedReadable;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IgfsLazySecondaryFileSystemPositionedReadable
implements IgfsSecondaryFileSystemPositionedReadable {
    private final IgfsSecondaryFileSystem fs;
    private final IgfsPath path;
    private final int bufSize;
    private IgfsSecondaryFileSystemPositionedReadable target;

    public IgfsLazySecondaryFileSystemPositionedReadable(IgfsSecondaryFileSystem fs, IgfsPath path, int bufSize) {
        assert (fs != null);
        assert (path != null);
        this.fs = fs;
        this.path = path;
        this.bufSize = bufSize;
    }

    @Override
    public int read(long pos, byte[] buf, int off, int len) throws IOException {
        if (this.target == null) {
            this.target = this.fs.open(this.path, this.bufSize);
        }
        return this.target.read(pos, buf, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.target != null) {
            this.target.close();
        }
    }

    public String toString() {
        return S.toString(IgfsLazySecondaryFileSystemPositionedReadable.class, this);
    }
}

