/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jsr166.LongAdder8;

public class IgfsLocalMetrics {
    private volatile IgniteBiTuple<LongAdder8, LongAdder8> blocksRead;
    private volatile IgniteBiTuple<LongAdder8, LongAdder8> blocksWritten;
    private volatile IgniteBiTuple<LongAdder8, LongAdder8> bytesRead;
    private volatile IgniteBiTuple<LongAdder8, LongAdder8> bytesWritten;
    private final LongAdder8 filesOpenedForRead = new LongAdder8();
    private final LongAdder8 filesOpenedForWrite = new LongAdder8();

    IgfsLocalMetrics() {
        this.reset();
    }

    long readBytes() {
        return this.bytesRead.get1().longValue();
    }

    long readBytesTime() {
        return this.bytesRead.get2().longValue();
    }

    void addReadBytesTime(long readBytes, long readTime) {
        IgniteBiTuple<LongAdder8, LongAdder8> bytesRead0 = this.bytesRead;
        bytesRead0.get1().add(readBytes);
        bytesRead0.get2().add(readTime);
    }

    long writeBytes() {
        return this.bytesWritten.get1().longValue();
    }

    long writeBytesTime() {
        return this.bytesWritten.get2().longValue();
    }

    void addWrittenBytesTime(long writtenBytes, long writeTime) {
        IgniteBiTuple<LongAdder8, LongAdder8> bytesWritten0 = this.bytesWritten;
        bytesWritten0.get1().add(writtenBytes);
        bytesWritten0.get2().add(writeTime);
    }

    long readBlocks() {
        return this.blocksRead.get1().longValue();
    }

    long readBlocksSecondary() {
        return this.blocksRead.get2().longValue();
    }

    void addReadBlocks(int total, int secondary) {
        IgniteBiTuple<LongAdder8, LongAdder8> blocksRead0 = this.blocksRead;
        blocksRead0.get1().add(total);
        blocksRead0.get2().add(secondary);
    }

    long writeBlocks() {
        return this.blocksWritten.get1().longValue();
    }

    long writeBlocksSecondary() {
        return this.blocksWritten.get2().longValue();
    }

    void addWriteBlocks(int total, int secondary) {
        IgniteBiTuple<LongAdder8, LongAdder8> blocksWritten0 = this.blocksWritten;
        blocksWritten0.get1().add(total);
        blocksWritten0.get2().add(secondary);
    }

    void incrementFilesOpenedForRead() {
        this.filesOpenedForRead.increment();
    }

    void decrementFilesOpenedForRead() {
        this.filesOpenedForRead.decrement();
    }

    int filesOpenedForRead() {
        return this.filesOpenedForRead.intValue();
    }

    void incrementFilesOpenedForWrite() {
        this.filesOpenedForWrite.increment();
    }

    void decrementFilesOpenedForWrite() {
        this.filesOpenedForWrite.decrement();
    }

    int filesOpenedForWrite() {
        return this.filesOpenedForWrite.intValue();
    }

    void reset() {
        this.blocksRead = F.t(new LongAdder8(), new LongAdder8());
        this.blocksWritten = F.t(new LongAdder8(), new LongAdder8());
        this.bytesRead = F.t(new LongAdder8(), new LongAdder8());
        this.bytesWritten = F.t(new LongAdder8(), new LongAdder8());
    }
}

