/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.jetbrains.annotations.Nullable;

public class IgfsModeResolver {
    private static final int MAX_PATH_CACHE = 1000;
    private final IgfsMode dfltMode;
    private List<T2<IgfsPath, IgfsMode>> modes;
    private Map<IgfsPath, IgfsMode> modesCache;
    private final Set<IgfsPath> dualParentsWithPrimaryChildren;

    public IgfsModeResolver(IgfsMode dfltMode, @Nullable ArrayList<T2<IgfsPath, IgfsMode>> modes) throws IgniteCheckedException {
        assert (dfltMode != null);
        this.dfltMode = dfltMode;
        this.dualParentsWithPrimaryChildren = new HashSet<IgfsPath>();
        this.modes = IgfsUtils.preparePathModes(dfltMode, modes, this.dualParentsWithPrimaryChildren);
        if (modes != null) {
            this.modesCache = new GridBoundedConcurrentLinkedHashMap<IgfsPath, IgfsMode>(1000);
        }
    }

    public IgfsMode resolveMode(IgfsPath path) {
        assert (path != null);
        if (this.modes == null) {
            return this.dfltMode;
        }
        IgfsMode mode = this.modesCache.get(path);
        if (mode == null) {
            for (T2<IgfsPath, IgfsMode> entry : this.modes) {
                if (!F.eq(path, entry.getKey()) && !path.isSubDirectoryOf((IgfsPath)entry.getKey())) continue;
                mode = (IgfsMode)((Object)entry.getValue());
                break;
            }
            if (mode == null) {
                mode = this.dfltMode;
            }
            this.modesCache.put(path, mode);
        }
        return mode;
    }

    @Nullable
    public ArrayList<T2<IgfsPath, IgfsMode>> modesOrdered() {
        return this.modes != null ? new ArrayList<T2<IgfsPath, IgfsMode>>(this.modes) : null;
    }

    public boolean hasPrimaryChild(IgfsPath path) {
        return this.dualParentsWithPrimaryChildren.contains(path);
    }
}

