/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.jetbrains.annotations.Nullable;

public class IgfsPaths
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private byte[] payloadBytes;
    private IgfsMode dfltMode;
    private ArrayList<T2<IgfsPath, IgfsMode>> pathModes;

    public IgfsPaths() {
    }

    public IgfsPaths(Object payload, IgfsMode dfltMode, @Nullable ArrayList<T2<IgfsPath, IgfsMode>> pathModes) throws IgniteCheckedException {
        this.dfltMode = dfltMode;
        this.pathModes = pathModes;
        if (payload == null) {
            this.payloadBytes = null;
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            U.marshal(new JdkMarshaller(), payload, out);
            this.payloadBytes = out.toByteArray();
        }
    }

    public IgfsMode defaultMode() {
        return this.dfltMode;
    }

    @Nullable
    public ArrayList<T2<IgfsPath, IgfsMode>> pathModes() {
        return this.pathModes;
    }

    @Nullable
    public Object getPayload(ClassLoader clsLdr) throws IgniteCheckedException {
        if (this.payloadBytes == null) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(this.payloadBytes);
        return U.unmarshal((Marshaller)new JdkMarshaller(), in, clsLdr);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeByteArray(out, this.payloadBytes);
        U.writeEnum(out, this.dfltMode);
        if (this.pathModes != null) {
            out.writeBoolean(true);
            out.writeInt(this.pathModes.size());
            for (T2<IgfsPath, IgfsMode> pathMode : this.pathModes) {
                assert (pathMode.getKey() != null);
                ((IgfsPath)pathMode.getKey()).writeExternal(out);
                U.writeEnum(out, (Enum)pathMode.getValue());
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.payloadBytes = U.readByteArray(in);
        this.dfltMode = IgfsMode.fromOrdinal(in.readByte());
        if (in.readBoolean()) {
            int size = in.readInt();
            this.pathModes = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                IgfsPath path = IgfsUtils.readPath(in);
                this.pathModes.add(new T2<IgfsPath, IgfsMode>(path, IgfsMode.fromOrdinal(in.readByte())));
            }
        }
    }
}

