/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.client;

import org.apache.ignite.Ignite;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.IgfsEx;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jetbrains.annotations.Nullable;

public abstract class IgfsClientAbstractCallable<T>
implements IgniteCallable<T>,
Binarylizable {
    private static final long serialVersionUID = 0L;
    protected String igfsName;
    protected IgfsPath path;
    @IgniteInstanceResource
    private transient Ignite ignite;

    protected IgfsClientAbstractCallable() {
    }

    protected IgfsClientAbstractCallable(@Nullable String igfsName, @Nullable IgfsPath path) {
        this.igfsName = igfsName;
        this.path = path;
    }

    @Override
    public final T call() throws Exception {
        assert (this.ignite != null);
        IgfsEx igfs = (IgfsEx)this.ignite.fileSystem(this.igfsName);
        return this.call0(igfs.context());
    }

    protected abstract T call0(IgfsContext var1) throws Exception;

    @Override
    public final void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter rawWriter = writer.rawWriter();
        rawWriter.writeString(this.igfsName);
        IgfsUtils.writePath(rawWriter, this.path);
        this.writeBinary0(rawWriter);
    }

    @Override
    public final void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader rawReader = reader.rawReader();
        this.igfsName = rawReader.readString();
        this.path = IgfsUtils.readPath(rawReader);
        this.readBinary0(rawReader);
    }

    protected void writeBinary0(BinaryRawWriter rawWriter) {
    }

    protected void readBinary0(BinaryRawReader rawReader) {
    }
}

