/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.client;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientAbstractCallable;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class IgfsClientDeleteCallable
extends IgfsClientAbstractCallable<Boolean> {
    private static final long serialVersionUID = 0L;
    private boolean recursive;

    public IgfsClientDeleteCallable() {
    }

    public IgfsClientDeleteCallable(@Nullable String igfsName, IgfsPath path, boolean recursive) {
        super(igfsName, path);
        this.recursive = recursive;
    }

    @Override
    protected Boolean call0(IgfsContext ctx) throws Exception {
        return ctx.igfs().delete(this.path, this.recursive);
    }

    @Override
    public void writeBinary0(BinaryRawWriter writer) throws BinaryObjectException {
        writer.writeBoolean(this.recursive);
    }

    @Override
    public void readBinary0(BinaryRawReader reader) throws BinaryObjectException {
        this.recursive = reader.readBoolean();
    }

    public String toString() {
        return S.toString(IgfsClientDeleteCallable.class, this);
    }
}

