/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.client;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientAbstractCallable;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class IgfsClientRenameCallable
extends IgfsClientAbstractCallable<Void> {
    private static final long serialVersionUID = 0L;
    private IgfsPath destPath;

    public IgfsClientRenameCallable() {
    }

    public IgfsClientRenameCallable(@Nullable String igfsName, IgfsPath srcPath, IgfsPath destPath) {
        super(igfsName, srcPath);
        this.destPath = destPath;
    }

    @Override
    protected Void call0(IgfsContext ctx) throws Exception {
        ctx.igfs().rename(this.path, this.destPath);
        return null;
    }

    @Override
    public void writeBinary0(BinaryRawWriter writer) throws BinaryObjectException {
        IgfsUtils.writePath(writer, this.destPath);
    }

    @Override
    public void readBinary0(BinaryRawReader reader) throws BinaryObjectException {
        this.destPath = IgfsUtils.readPath(reader);
    }

    public String toString() {
        return S.toString(IgfsClientRenameCallable.class, this);
    }
}

