/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.secondary.local;

import java.util.Collections;
import java.util.Map;
import org.apache.ignite.igfs.IgfsFile;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.jetbrains.annotations.Nullable;

public class LocalFileSystemIgfsFile
implements IgfsFile {
    private final IgfsPath path;
    private final byte flags;
    private final int blockSize;
    private final long modTime;
    private final long len;
    private Map<String, String> props;

    public LocalFileSystemIgfsFile(IgfsPath path, boolean isFile, boolean isDir, int blockSize, long modTime, long len, Map<String, String> props) {
        assert (!isDir || blockSize == 0) : "blockSize must be 0 for dirs. [blockSize=" + blockSize + ']';
        assert (!isDir || len == 0L) : "length must be 0 for dirs. [length=" + len + ']';
        this.path = path;
        this.flags = IgfsUtils.flags(isDir, isFile);
        this.blockSize = blockSize;
        this.modTime = modTime;
        this.len = len;
        this.props = props;
    }

    @Override
    public IgfsPath path() {
        return this.path;
    }

    @Override
    public boolean isFile() {
        return IgfsUtils.isFile(this.flags);
    }

    @Override
    public boolean isDirectory() {
        return IgfsUtils.isDirectory(this.flags);
    }

    @Override
    public int blockSize() {
        return this.blockSize;
    }

    @Override
    public long groupBlockSize() {
        return this.blockSize();
    }

    @Override
    public long accessTime() {
        return 0L;
    }

    @Override
    public long modificationTime() {
        return this.modTime;
    }

    @Override
    public String property(String name) throws IllegalArgumentException {
        return this.property(name, null);
    }

    @Override
    @Nullable
    public String property(String name, @Nullable String dfltVal) {
        String res;
        if (this.props != null && (res = this.props.get(name)) != null) {
            return res;
        }
        return dfltVal;
    }

    @Override
    public Map<String, String> properties() {
        return this.props != null ? this.props : Collections.emptyMap();
    }

    @Override
    public long length() {
        return this.len;
    }
}

