/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.secondary.local;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystemPositionedReadable;

public class LocalIgfsSecondaryFileSystemPositionedReadable
extends BufferedInputStream
implements IgfsSecondaryFileSystemPositionedReadable {
    private long lastReadPos;

    public LocalIgfsSecondaryFileSystemPositionedReadable(FileInputStream in, int bufSize) {
        super(in, bufSize);
    }

    @Override
    public int read(long readPos, byte[] buf, int off, int len) throws IOException {
        int bytesRead;
        if (this.in == null) {
            throw new IOException("Stream is closed.");
        }
        if (readPos < this.lastReadPos || readPos + (long)len > this.lastReadPos + (long)this.buf.length) {
            ((FileInputStream)this.in).getChannel().position(readPos);
            this.pos = 0;
            this.count = 0;
        }
        if ((bytesRead = this.read(buf, off, len)) != -1) {
            this.lastReadPos = readPos + (long)bytesRead;
        }
        return bytesRead;
    }
}

