/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.odbc.OdbcUtils;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;

public class OdbcColumnMeta {
    private final String schemaName;
    private final String tableName;
    private final String columnName;
    private final Class<?> dataType;

    public OdbcColumnMeta(String schemaName, String tableName, String columnName, Class<?> dataType) {
        this.schemaName = OdbcUtils.addQuotationMarksIfNeeded(schemaName);
        this.tableName = tableName;
        this.columnName = columnName;
        this.dataType = dataType;
    }

    public OdbcColumnMeta(GridQueryFieldMetadata info) {
        Class<Object> type;
        this.schemaName = OdbcUtils.addQuotationMarksIfNeeded(info.schemaName());
        this.tableName = info.typeName();
        this.columnName = info.fieldName();
        try {
            type = Class.forName(info.fieldTypeName());
        }
        catch (Exception ignored) {
            type = Object.class;
        }
        this.dataType = type;
    }

    public int hashCode() {
        int hash = this.schemaName.hashCode();
        hash = 31 * hash + this.tableName.hashCode();
        hash = 31 * hash + this.columnName.hashCode();
        hash = 31 * hash + this.dataType.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof OdbcColumnMeta) {
            OdbcColumnMeta other = (OdbcColumnMeta)o;
            return this == other || this.schemaName.equals(other.schemaName) && this.tableName.equals(other.tableName) && this.columnName.equals(other.columnName) && this.dataType.equals(other.dataType);
        }
        return false;
    }

    public void write(BinaryRawWriter writer) {
        writer.writeString(this.schemaName);
        writer.writeString(this.tableName);
        writer.writeString(this.columnName);
        byte typeId = BinaryUtils.typeByClass(this.dataType);
        writer.writeByte(typeId);
    }
}

