/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.odbc.OdbcColumnMeta;
import org.apache.ignite.internal.processors.odbc.OdbcHandshakeRequest;
import org.apache.ignite.internal.processors.odbc.OdbcHandshakeResult;
import org.apache.ignite.internal.processors.odbc.OdbcProtocolVersion;
import org.apache.ignite.internal.processors.odbc.OdbcQueryCloseRequest;
import org.apache.ignite.internal.processors.odbc.OdbcQueryCloseResult;
import org.apache.ignite.internal.processors.odbc.OdbcQueryExecuteRequest;
import org.apache.ignite.internal.processors.odbc.OdbcQueryExecuteResult;
import org.apache.ignite.internal.processors.odbc.OdbcQueryFetchRequest;
import org.apache.ignite.internal.processors.odbc.OdbcQueryFetchResult;
import org.apache.ignite.internal.processors.odbc.OdbcQueryGetColumnsMetaRequest;
import org.apache.ignite.internal.processors.odbc.OdbcQueryGetColumnsMetaResult;
import org.apache.ignite.internal.processors.odbc.OdbcQueryGetParamsMetaRequest;
import org.apache.ignite.internal.processors.odbc.OdbcQueryGetParamsMetaResult;
import org.apache.ignite.internal.processors.odbc.OdbcQueryGetTablesMetaRequest;
import org.apache.ignite.internal.processors.odbc.OdbcQueryGetTablesMetaResult;
import org.apache.ignite.internal.processors.odbc.OdbcRequest;
import org.apache.ignite.internal.processors.odbc.OdbcResponse;
import org.apache.ignite.internal.processors.odbc.OdbcTableMeta;

public class OdbcMessageParser {
    private static final int INIT_CAP = 1024;
    private final GridBinaryMarshaller marsh;
    private final IgniteLogger log;
    private boolean verConfirmed = false;

    public OdbcMessageParser(GridKernalContext ctx) {
        CacheObjectBinaryProcessorImpl cacheObjProc = (CacheObjectBinaryProcessorImpl)ctx.cacheObjects();
        this.marsh = cacheObjProc.marshaller();
        this.log = ctx.log(this.getClass());
    }

    public OdbcRequest decode(byte[] msg) {
        OdbcRequest res;
        assert (msg != null);
        BinaryHeapInputStream stream = new BinaryHeapInputStream(msg);
        BinaryReaderExImpl reader = new BinaryReaderExImpl(null, stream, null, true);
        byte cmd = reader.readByte();
        if (!this.verConfirmed) {
            if (cmd == 1) {
                long longVersion = reader.readLong();
                OdbcHandshakeRequest res2 = new OdbcHandshakeRequest(longVersion);
                OdbcProtocolVersion version = res2.version();
                if (version.isUnknown()) {
                    return res2;
                }
                if (version.isDistributedJoinsSupported()) {
                    res2.distributedJoins(reader.readBoolean());
                    res2.enforceJoinOrder(reader.readBoolean());
                }
                return res2;
            }
            throw new IgniteException("Unexpected ODBC command (first message is not a handshake request): [cmd=" + cmd + ']');
        }
        switch (cmd) {
            case 2: {
                String cache = reader.readString();
                String sql = reader.readString();
                int argsNum = reader.readInt();
                Object[] params = new Object[argsNum];
                for (int i = 0; i < argsNum; ++i) {
                    params[i] = reader.readObjectDetached();
                }
                res = new OdbcQueryExecuteRequest(cache, sql, params);
                break;
            }
            case 3: {
                long queryId = reader.readLong();
                int pageSize = reader.readInt();
                res = new OdbcQueryFetchRequest(queryId, pageSize);
                break;
            }
            case 4: {
                long queryId = reader.readLong();
                res = new OdbcQueryCloseRequest(queryId);
                break;
            }
            case 5: {
                String cache = reader.readString();
                String table = reader.readString();
                String column = reader.readString();
                res = new OdbcQueryGetColumnsMetaRequest(cache, table, column);
                break;
            }
            case 6: {
                String catalog = reader.readString();
                String schema = reader.readString();
                String table = reader.readString();
                String tableType = reader.readString();
                res = new OdbcQueryGetTablesMetaRequest(catalog, schema, table, tableType);
                break;
            }
            case 7: {
                String cacheName = reader.readString();
                String sqlQuery = reader.readString();
                res = new OdbcQueryGetParamsMetaRequest(cacheName, sqlQuery);
                break;
            }
            default: {
                throw new IgniteException("Unknown ODBC command: [cmd=" + cmd + ']');
            }
        }
        return res;
    }

    public byte[] encode(OdbcResponse msg) {
        assert (msg != null);
        BinaryWriterExImpl writer = this.marsh.writer(new BinaryHeapOutputStream(1024));
        writer.writeByte((byte)msg.status());
        if (msg.status() != 0) {
            writer.writeString(msg.error());
            return writer.array();
        }
        Object res0 = msg.response();
        if (res0 == null) {
            return writer.array();
        }
        if (res0 instanceof OdbcHandshakeResult) {
            OdbcHandshakeResult res = (OdbcHandshakeResult)res0;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Handshake result: " + (res.accepted() ? "accepted" : "rejected"));
            }
            this.verConfirmed = res.accepted();
            if (res.accepted()) {
                this.verConfirmed = true;
                writer.writeBoolean(true);
            } else {
                writer.writeBoolean(false);
                writer.writeString(res.protocolVersionSince());
                writer.writeString(res.currentVersion());
            }
        } else if (res0 instanceof OdbcQueryExecuteResult) {
            OdbcQueryExecuteResult res = (OdbcQueryExecuteResult)res0;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Resulting query ID: " + res.getQueryId());
            }
            writer.writeLong(res.getQueryId());
            Collection<OdbcColumnMeta> metas = res.getColumnsMetadata();
            assert (metas != null);
            writer.writeInt(metas.size());
            for (OdbcColumnMeta meta : metas) {
                meta.write(writer);
            }
        } else if (res0 instanceof OdbcQueryFetchResult) {
            OdbcQueryFetchResult res = (OdbcQueryFetchResult)res0;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Resulting query ID: " + res.queryId());
            }
            writer.writeLong(res.queryId());
            Collection<?> items0 = res.items();
            assert (items0 != null);
            writer.writeBoolean(res.last());
            writer.writeInt(items0.size());
            for (Object row0 : items0) {
                if (row0 == null) continue;
                Collection row = (Collection)row0;
                writer.writeInt(row.size());
                for (Object obj : row) {
                    if (obj instanceof Timestamp) {
                        writer.writeTimestamp((Timestamp)obj);
                        continue;
                    }
                    if (obj instanceof Date) {
                        writer.writeDate((Date)obj);
                        continue;
                    }
                    writer.writeObjectDetached(obj);
                }
            }
        } else if (res0 instanceof OdbcQueryCloseResult) {
            OdbcQueryCloseResult res = (OdbcQueryCloseResult)res0;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Resulting query ID: " + res.getQueryId());
            }
            writer.writeLong(res.getQueryId());
        } else if (res0 instanceof OdbcQueryGetColumnsMetaResult) {
            OdbcQueryGetColumnsMetaResult res = (OdbcQueryGetColumnsMetaResult)res0;
            Collection<OdbcColumnMeta> columnsMeta = res.meta();
            assert (columnsMeta != null);
            writer.writeInt(columnsMeta.size());
            for (OdbcColumnMeta columnMeta : columnsMeta) {
                columnMeta.write(writer);
            }
        } else if (res0 instanceof OdbcQueryGetTablesMetaResult) {
            OdbcQueryGetTablesMetaResult res = (OdbcQueryGetTablesMetaResult)res0;
            Collection<OdbcTableMeta> tablesMeta = res.meta();
            assert (tablesMeta != null);
            writer.writeInt(tablesMeta.size());
            for (OdbcTableMeta tableMeta : tablesMeta) {
                tableMeta.writeBinary(writer);
            }
        } else if (res0 instanceof OdbcQueryGetParamsMetaResult) {
            OdbcQueryGetParamsMetaResult res = (OdbcQueryGetParamsMetaResult)res0;
            byte[] typeIds = res.typeIds();
            writer.writeObjectDetached(typeIds);
        } else assert (false) : "Should not reach here.";
        return writer.array();
    }
}

