/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.odbc.OdbcMessageParser;
import org.apache.ignite.internal.processors.odbc.OdbcRequest;
import org.apache.ignite.internal.processors.odbc.OdbcRequestHandler;
import org.apache.ignite.internal.processors.odbc.OdbcResponse;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.nio.GridNioServerListenerAdapter;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.jetbrains.annotations.Nullable;

public class OdbcNioListener
extends GridNioServerListenerAdapter<byte[]> {
    private static final int CONNECTION_DATA_META_KEY = GridNioSessionMetaKey.nextUniqueKey();
    private static final AtomicLong REQ_ID_GEN = new AtomicLong();
    private final GridSpinBusyLock busyLock;
    private final GridKernalContext ctx;
    private final int maxCursors;
    private final IgniteLogger log;

    public OdbcNioListener(GridKernalContext ctx, GridSpinBusyLock busyLock, int maxCursors) {
        this.ctx = ctx;
        this.busyLock = busyLock;
        this.maxCursors = maxCursors;
        this.log = ctx.log(this.getClass());
    }

    @Override
    public void onConnected(GridNioSession ses) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("ODBC client connected: " + ses.remoteAddress());
        }
        ses.addMeta(CONNECTION_DATA_META_KEY, new ConnectionData(this.ctx, this.busyLock));
    }

    @Override
    public void onDisconnected(GridNioSession ses, @Nullable Exception e) {
        if (this.log.isDebugEnabled()) {
            if (e == null) {
                this.log.debug("ODBC client disconnected: " + ses.remoteAddress());
            } else {
                this.log.debug("ODBC client disconnected due to an error [addr=" + ses.remoteAddress() + ", err=" + e + ']');
            }
        }
    }

    @Override
    public void onMessage(GridNioSession ses, byte[] msg) {
        OdbcRequest req;
        assert (msg != null);
        long reqId = REQ_ID_GEN.incrementAndGet();
        ConnectionData connData = (ConnectionData)ses.meta(CONNECTION_DATA_META_KEY);
        assert (connData != null);
        OdbcMessageParser parser = connData.getParser();
        try {
            req = parser.decode(msg);
        }
        catch (Exception e) {
            this.log.error("Failed to parse message [id=" + reqId + ", err=" + e + ']');
            ses.close();
            return;
        }
        assert (req != null);
        try {
            long startTime = 0L;
            if (this.log.isDebugEnabled()) {
                startTime = System.nanoTime();
                this.log.debug("ODBC request received [id=" + reqId + ", addr=" + ses.remoteAddress() + ", req=" + req + ']');
            }
            OdbcRequestHandler handler = connData.getHandler();
            OdbcResponse resp = handler.handle(reqId, req);
            if (this.log.isDebugEnabled()) {
                long dur = (System.nanoTime() - startTime) / 1000L;
                this.log.debug("ODBC request processed [id=" + reqId + ", dur(mcs)=" + dur + ", resp=" + resp.status() + ']');
            }
            byte[] outMsg = parser.encode(resp);
            ses.send(outMsg);
        }
        catch (Exception e) {
            this.log.error("Failed to process ODBC request [id=" + reqId + ", err=" + e + ']');
            ses.send(parser.encode(new OdbcResponse(1, e.toString())));
        }
    }

    private class ConnectionData {
        private final OdbcRequestHandler handler;
        private final OdbcMessageParser parser;

        public ConnectionData(GridKernalContext ctx, GridSpinBusyLock busyLock) {
            this.handler = new OdbcRequestHandler(ctx, busyLock, OdbcNioListener.this.maxCursors);
            this.parser = new OdbcMessageParser(ctx);
        }

        public OdbcRequestHandler getHandler() {
            return this.handler;
        }

        public OdbcMessageParser getParser() {
            return this.parser;
        }
    }
}

