/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.net.InetAddress;
import java.nio.ByteOrder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.OdbcConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.odbc.OdbcBufferedParser;
import org.apache.ignite.internal.processors.odbc.OdbcNioListener;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.HostAndPortRange;
import org.apache.ignite.internal.util.nio.GridNioAsyncNotifyFilter;
import org.apache.ignite.internal.util.nio.GridNioCodecFilter;
import org.apache.ignite.internal.util.nio.GridNioFilter;
import org.apache.ignite.internal.util.nio.GridNioServer;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.IgnitePortProtocol;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;

public class OdbcProcessor
extends GridProcessorAdapter {
    private static final int DFLT_SELECTOR_CNT = Math.min(4, Runtime.getRuntime().availableProcessors());
    private static final boolean DFLT_TCP_NODELAY = true;
    private static final boolean DFLT_TCP_DIRECT_BUF = false;
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private GridNioServer<byte[]> srv;
    private ExecutorService odbcExecSvc;

    public OdbcProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public void start() throws IgniteCheckedException {
        IgniteConfiguration cfg = this.ctx.config();
        OdbcConfiguration odbcCfg = cfg.getOdbcConfiguration();
        if (odbcCfg != null) {
            try {
                InetAddress host;
                Marshaller marsh = cfg.getMarshaller();
                if (marsh != null && !(marsh instanceof BinaryMarshaller)) {
                    throw new IgniteCheckedException("ODBC can only be used with BinaryMarshaller (please set it through IgniteConfiguration.setMarshaller())");
                }
                HostAndPortRange hostPort = F.isEmpty(odbcCfg.getEndpointAddress()) ? new HostAndPortRange("0.0.0.0", 10800, 10810) : HostAndPortRange.parse(odbcCfg.getEndpointAddress(), 10800, 10810, "Failed to parse ODBC endpoint address");
                this.assertParameter(odbcCfg.getThreadPoolSize() > 0, "threadPoolSize > 0");
                this.odbcExecSvc = new IgniteThreadPoolExecutor("odbc", cfg.getGridName(), odbcCfg.getThreadPoolSize(), odbcCfg.getThreadPoolSize(), 0L, new LinkedBlockingQueue<Runnable>());
                try {
                    host = InetAddress.getByName(hostPort.host());
                }
                catch (Exception e) {
                    throw new IgniteCheckedException("Failed to resolve ODBC host: " + hostPort.host(), e);
                }
                Exception lastErr = null;
                for (int port = hostPort.portFrom(); port <= hostPort.portTo(); ++port) {
                    try {
                        GridNioFilter[] filters = new GridNioFilter[]{new GridNioAsyncNotifyFilter(this.ctx.gridName(), this.odbcExecSvc, this.log){

                            @Override
                            public void onSessionOpened(GridNioSession ses) throws IgniteCheckedException {
                                this.proceedSessionOpened(ses);
                            }
                        }, new GridNioCodecFilter(new OdbcBufferedParser(), this.log, false)};
                        GridNioServer<byte[]> srv0 = GridNioServer.builder().address(host).port(port).listener(new OdbcNioListener(this.ctx, this.busyLock, odbcCfg.getMaxOpenCursors())).logger(this.log).selectorCount(DFLT_SELECTOR_CNT).gridName(this.ctx.gridName()).serverName("odbc").tcpNoDelay(true).directBuffer(false).byteOrder(ByteOrder.nativeOrder()).socketSendBufferSize(odbcCfg.getSocketSendBufferSize()).socketReceiveBufferSize(odbcCfg.getSocketReceiveBufferSize()).filters(filters).directMode(false).build();
                        srv0.start();
                        this.srv = srv0;
                        this.ctx.ports().registerPort(port, IgnitePortProtocol.TCP, this.getClass());
                        this.log.info("ODBC processor has started on TCP port " + port);
                        lastErr = null;
                        break;
                    }
                    catch (Exception e) {
                        lastErr = e;
                        continue;
                    }
                }
                assert (this.srv != null && lastErr == null || this.srv == null && lastErr != null);
                if (lastErr != null) {
                    throw new IgniteCheckedException("Failed to bind to any [host:port] from the range [address=" + hostPort + ", lastErr=" + lastErr + ']');
                }
            }
            catch (Exception e) {
                throw new IgniteCheckedException("Failed to start ODBC processor.", e);
            }
        }
    }

    @Override
    public void onKernalStop(boolean cancel) {
        if (this.srv != null) {
            this.busyLock.block();
            this.srv.stop();
            this.ctx.ports().deregisterPorts(this.getClass());
            if (this.odbcExecSvc != null) {
                U.shutdownNow(this.getClass(), this.odbcExecSvc, this.log);
                this.odbcExecSvc = null;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("ODBC processor stopped.");
            }
        }
    }
}

