/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.util.HashMap;
import java.util.Map;

public final class OdbcProtocolVersion
extends Enum<OdbcProtocolVersion> {
    public static final /* enum */ OdbcProtocolVersion VERSION_1_6_0 = new OdbcProtocolVersion(1L);
    public static final /* enum */ OdbcProtocolVersion VERSION_1_8_0 = new OdbcProtocolVersion(OdbcProtocolVersion.makeVersion(1, 8, 0));
    public static final /* enum */ OdbcProtocolVersion VERSION_UNKNOWN = new OdbcProtocolVersion(Long.MIN_VALUE);
    private static final long LONG_MASK = 65535L;
    private static final Map<Long, OdbcProtocolVersion> versions;
    private static final Map<OdbcProtocolVersion, String> since;
    private final long longVal;
    private static final /* synthetic */ OdbcProtocolVersion[] $VALUES;

    public static OdbcProtocolVersion[] values() {
        return (OdbcProtocolVersion[])$VALUES.clone();
    }

    public static OdbcProtocolVersion valueOf(String name) {
        return Enum.valueOf(OdbcProtocolVersion.class, name);
    }

    private OdbcProtocolVersion(long longVal) {
        this.longVal = longVal;
    }

    private static long makeVersion(int major, int minor, int maintenance) {
        return ((long)major & 0xFFFFL) << 48 | ((long)minor & 0xFFFFL) << 32 | ((long)maintenance & 0xFFFFL) << 16;
    }

    public static OdbcProtocolVersion fromLong(long longVal) {
        OdbcProtocolVersion res = versions.get(longVal);
        return res == null ? VERSION_UNKNOWN : res;
    }

    public static OdbcProtocolVersion current() {
        return VERSION_1_8_0;
    }

    public long longValue() {
        return this.longVal;
    }

    public boolean isUnknown() {
        return this.longVal == OdbcProtocolVersion.VERSION_UNKNOWN.longVal;
    }

    public boolean isDistributedJoinsSupported() {
        assert (!this.isUnknown());
        return this.longVal >= OdbcProtocolVersion.VERSION_1_8_0.longVal;
    }

    public String since() {
        assert (!this.isUnknown());
        return since.get((Object)this);
    }

    static {
        $VALUES = new OdbcProtocolVersion[]{VERSION_1_6_0, VERSION_1_8_0, VERSION_UNKNOWN};
        versions = new HashMap<Long, OdbcProtocolVersion>();
        since = new HashMap<OdbcProtocolVersion, String>();
        for (OdbcProtocolVersion version : OdbcProtocolVersion.values()) {
            versions.put(version.longValue(), version);
        }
        since.put(VERSION_1_6_0, "1.6.0");
        since.put(VERSION_1_8_0, "1.8.0");
    }
}

