/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.odbc.OdbcColumnMeta;
import org.apache.ignite.internal.processors.odbc.OdbcHandshakeRequest;
import org.apache.ignite.internal.processors.odbc.OdbcHandshakeResult;
import org.apache.ignite.internal.processors.odbc.OdbcProtocolVersion;
import org.apache.ignite.internal.processors.odbc.OdbcQueryCloseRequest;
import org.apache.ignite.internal.processors.odbc.OdbcQueryCloseResult;
import org.apache.ignite.internal.processors.odbc.OdbcQueryExecuteRequest;
import org.apache.ignite.internal.processors.odbc.OdbcQueryExecuteResult;
import org.apache.ignite.internal.processors.odbc.OdbcQueryFetchRequest;
import org.apache.ignite.internal.processors.odbc.OdbcQueryFetchResult;
import org.apache.ignite.internal.processors.odbc.OdbcQueryGetColumnsMetaRequest;
import org.apache.ignite.internal.processors.odbc.OdbcQueryGetColumnsMetaResult;
import org.apache.ignite.internal.processors.odbc.OdbcQueryGetParamsMetaRequest;
import org.apache.ignite.internal.processors.odbc.OdbcQueryGetParamsMetaResult;
import org.apache.ignite.internal.processors.odbc.OdbcQueryGetTablesMetaRequest;
import org.apache.ignite.internal.processors.odbc.OdbcQueryGetTablesMetaResult;
import org.apache.ignite.internal.processors.odbc.OdbcRequest;
import org.apache.ignite.internal.processors.odbc.OdbcResponse;
import org.apache.ignite.internal.processors.odbc.OdbcTableMeta;
import org.apache.ignite.internal.processors.odbc.OdbcUtils;
import org.apache.ignite.internal.processors.odbc.escape.OdbcEscapeUtils;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteProductVersion;

public class OdbcRequestHandler {
    private static final AtomicLong QRY_ID_GEN = new AtomicLong();
    private final GridKernalContext ctx;
    private final IgniteLogger log;
    private final GridSpinBusyLock busyLock;
    private final int maxCursors;
    private final ConcurrentHashMap<Long, IgniteBiTuple<QueryCursor, Iterator>> qryCursors = new ConcurrentHashMap();
    private boolean distributedJoins = false;
    private boolean enforceJoinOrder = false;

    public OdbcRequestHandler(GridKernalContext ctx, GridSpinBusyLock busyLock, int maxCursors) {
        this.ctx = ctx;
        this.busyLock = busyLock;
        this.maxCursors = maxCursors;
        this.log = ctx.log(OdbcRequestHandler.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OdbcResponse handle(long reqId, OdbcRequest req) {
        assert (req != null);
        if (!this.busyLock.enterBusy()) {
            return new OdbcResponse(1, "Failed to handle ODBC request because node is stopping: " + req);
        }
        try {
            switch (req.command()) {
                case 1: {
                    OdbcResponse odbcResponse = this.performHandshake(reqId, (OdbcHandshakeRequest)req);
                    return odbcResponse;
                }
                case 2: {
                    OdbcResponse odbcResponse = this.executeQuery(reqId, (OdbcQueryExecuteRequest)req);
                    return odbcResponse;
                }
                case 3: {
                    OdbcResponse odbcResponse = this.fetchQuery(reqId, (OdbcQueryFetchRequest)req);
                    return odbcResponse;
                }
                case 4: {
                    OdbcResponse odbcResponse = this.closeQuery(reqId, (OdbcQueryCloseRequest)req);
                    return odbcResponse;
                }
                case 5: {
                    OdbcResponse odbcResponse = this.getColumnsMeta(reqId, (OdbcQueryGetColumnsMetaRequest)req);
                    return odbcResponse;
                }
                case 6: {
                    OdbcResponse odbcResponse = this.getTablesMeta(reqId, (OdbcQueryGetTablesMetaRequest)req);
                    return odbcResponse;
                }
                case 7: {
                    OdbcResponse odbcResponse = this.getParamsMeta(reqId, (OdbcQueryGetParamsMetaRequest)req);
                    return odbcResponse;
                }
            }
            OdbcResponse odbcResponse = new OdbcResponse(1, "Unsupported ODBC request: " + req);
            return odbcResponse;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private OdbcResponse performHandshake(long reqId, OdbcHandshakeRequest req) {
        try {
            OdbcProtocolVersion version = req.version();
            if (version.isUnknown()) {
                IgniteProductVersion ver = this.ctx.grid().version();
                String verStr = Byte.toString(ver.major()) + '.' + ver.minor() + '.' + ver.maintenance();
                OdbcHandshakeResult res = new OdbcHandshakeResult(false, OdbcProtocolVersion.current().since(), verStr);
                return new OdbcResponse(res);
            }
            OdbcHandshakeResult res = new OdbcHandshakeResult(true, null, null);
            if (version.isDistributedJoinsSupported()) {
                this.distributedJoins = req.distributedJoins();
                this.enforceJoinOrder = req.enforceJoinOrder();
            }
            return new OdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to perform handshake [reqId=" + reqId + ", req=" + req + ']', e);
            return new OdbcResponse(1, e.toString());
        }
    }

    private OdbcResponse executeQuery(long reqId, OdbcQueryExecuteRequest req) {
        int cursorCnt = this.qryCursors.size();
        if (this.maxCursors > 0 && cursorCnt >= this.maxCursors) {
            return new OdbcResponse(1, "Too many opened cursors (either close other opened cursors or increase the limit through OdbcConfiguration.setMaxOpenCursors()) [maximum=" + this.maxCursors + ", current=" + cursorCnt + ']');
        }
        long qryId = QRY_ID_GEN.getAndIncrement();
        try {
            String sql = OdbcEscapeUtils.parse(req.sqlQuery());
            if (this.log.isDebugEnabled()) {
                this.log.debug("ODBC query parsed [reqId=" + reqId + ", original=" + req.sqlQuery() + ", parsed=" + sql + ']');
            }
            SqlFieldsQuery qry = new SqlFieldsQuery(sql);
            qry.setArgs(req.arguments());
            qry.setDistributedJoins(this.distributedJoins);
            qry.setEnforceJoinOrder(this.enforceJoinOrder);
            IgniteCache cache0 = this.ctx.grid().cache(req.cacheName());
            if (cache0 == null) {
                return new OdbcResponse(1, "Cache doesn't exist (did you configure it?): " + req.cacheName());
            }
            IgniteCache cache = cache0.withKeepBinary();
            if (cache == null) {
                return new OdbcResponse(1, "Can not get cache with keep binary: " + req.cacheName());
            }
            QueryCursor qryCur = cache.query(qry);
            this.qryCursors.put(qryId, new IgniteBiTuple(qryCur, null));
            List<GridQueryFieldMetadata> fieldsMeta = ((QueryCursorImpl)qryCur).fieldsMeta();
            OdbcQueryExecuteResult res = new OdbcQueryExecuteResult(qryId, OdbcRequestHandler.convertMetadata(fieldsMeta));
            return new OdbcResponse(res);
        }
        catch (Exception e) {
            this.qryCursors.remove(qryId);
            U.error(this.log, "Failed to execute SQL query [reqId=" + reqId + ", req=" + req + ']', e);
            return new OdbcResponse(1, e.toString());
        }
    }

    private OdbcResponse closeQuery(long reqId, OdbcQueryCloseRequest req) {
        try {
            IgniteBiTuple<QueryCursor, Iterator> tuple = this.qryCursors.get(req.queryId());
            if (tuple == null) {
                return new OdbcResponse(1, "Failed to find query with ID: " + req.queryId());
            }
            QueryCursor cur = tuple.get1();
            assert (cur != null);
            cur.close();
            this.qryCursors.remove(req.queryId());
            OdbcQueryCloseResult res = new OdbcQueryCloseResult(req.queryId());
            return new OdbcResponse(res);
        }
        catch (Exception e) {
            this.qryCursors.remove(req.queryId());
            U.error(this.log, "Failed to close SQL query [reqId=" + reqId + ", req=" + req.queryId() + ']', e);
            return new OdbcResponse(1, e.toString());
        }
    }

    private OdbcResponse fetchQuery(long reqId, OdbcQueryFetchRequest req) {
        try {
            IgniteBiTuple<QueryCursor, Iterator> tuple = this.qryCursors.get(req.queryId());
            if (tuple == null) {
                return new OdbcResponse(1, "Failed to find query with ID: " + req.queryId());
            }
            Iterator iter = tuple.get2();
            if (iter == null) {
                QueryCursor cur = tuple.get1();
                iter = cur.iterator();
                tuple.put(cur, iter);
            }
            ArrayList items = new ArrayList();
            for (int i = 0; i < req.pageSize() && iter.hasNext(); ++i) {
                items.add(iter.next());
            }
            OdbcQueryFetchResult res = new OdbcQueryFetchResult(req.queryId(), items, !iter.hasNext());
            return new OdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to fetch SQL query result [reqId=" + reqId + ", req=" + req + ']', e);
            return new OdbcResponse(1, e.toString());
        }
    }

    private OdbcResponse getColumnsMeta(long reqId, OdbcQueryGetColumnsMetaRequest req) {
        try {
            String tableName;
            String cacheName;
            ArrayList<OdbcColumnMeta> meta = new ArrayList<OdbcColumnMeta>();
            if (req.tableName().contains(".")) {
                String[] parts = req.tableName().split("\\.");
                cacheName = OdbcUtils.removeQuotationMarksIfNeeded(parts[0]);
                tableName = parts[1];
            } else {
                cacheName = OdbcUtils.removeQuotationMarksIfNeeded(req.cacheName());
                tableName = req.tableName();
            }
            Collection<GridQueryTypeDescriptor> tablesMeta = this.ctx.query().types(cacheName);
            for (GridQueryTypeDescriptor table : tablesMeta) {
                if (!OdbcRequestHandler.matches(table.name(), tableName)) continue;
                for (Map.Entry<String, Class<?>> field : table.fields().entrySet()) {
                    OdbcColumnMeta columnMeta;
                    if (!OdbcRequestHandler.matches(field.getKey(), req.columnName()) || meta.contains(columnMeta = new OdbcColumnMeta(req.cacheName(), table.name(), field.getKey(), field.getValue()))) continue;
                    meta.add(columnMeta);
                }
            }
            OdbcQueryGetColumnsMetaResult res = new OdbcQueryGetColumnsMetaResult(meta);
            return new OdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get columns metadata [reqId=" + reqId + ", req=" + req + ']', e);
            return new OdbcResponse(1, e.toString());
        }
    }

    private OdbcResponse getTablesMeta(long reqId, OdbcQueryGetTablesMetaRequest req) {
        try {
            ArrayList<OdbcTableMeta> meta = new ArrayList<OdbcTableMeta>();
            String realSchema = OdbcUtils.removeQuotationMarksIfNeeded(req.schema());
            for (String cacheName : this.ctx.cache().cacheNames()) {
                if (!OdbcRequestHandler.matches(cacheName, realSchema)) continue;
                Collection<GridQueryTypeDescriptor> tablesMeta = this.ctx.query().types(cacheName);
                for (GridQueryTypeDescriptor table : tablesMeta) {
                    OdbcTableMeta tableMeta;
                    if (!OdbcRequestHandler.matches(table.name(), req.table()) || !OdbcRequestHandler.matches("TABLE", req.tableType()) || meta.contains(tableMeta = new OdbcTableMeta(null, cacheName, table.name(), "TABLE"))) continue;
                    meta.add(tableMeta);
                }
            }
            OdbcQueryGetTablesMetaResult res = new OdbcQueryGetTablesMetaResult(meta);
            return new OdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get tables metadata [reqId=" + reqId + ", req=" + req + ']', e);
            return new OdbcResponse(1, e.toString());
        }
    }

    private OdbcResponse getParamsMeta(long reqId, OdbcQueryGetParamsMetaRequest req) {
        try {
            PreparedStatement stmt = this.ctx.query().prepareNativeStatement(req.cacheName(), req.query());
            ParameterMetaData pmd = stmt.getParameterMetaData();
            byte[] typeIds = new byte[pmd.getParameterCount()];
            for (int i = 1; i <= pmd.getParameterCount(); ++i) {
                int sqlType = pmd.getParameterType(i);
                typeIds[i - 1] = OdbcRequestHandler.sqlTypeToBinary(sqlType);
            }
            OdbcQueryGetParamsMetaResult res = new OdbcQueryGetParamsMetaResult(typeIds);
            return new OdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get params metadata [reqId=" + reqId + ", req=" + req + ']', e);
            return new OdbcResponse(1, e.toString());
        }
    }

    private static byte sqlTypeToBinary(int sqlType) {
        switch (sqlType) {
            case -5: {
                return 4;
            }
            case 16: {
                return 8;
            }
            case 91: {
                return 11;
            }
            case 8: {
                return 6;
            }
            case 6: 
            case 7: {
                return 5;
            }
            case 2: 
            case 3: {
                return 30;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 2;
            }
            case 92: 
            case 93: {
                return 33;
            }
            case -6: {
                return 1;
            }
            case -16: 
            case 1: 
            case 12: {
                return 9;
            }
            case 0: {
                return 101;
            }
        }
        return 12;
    }

    private static Collection<OdbcColumnMeta> convertMetadata(Collection<?> meta) {
        ArrayList<OdbcColumnMeta> res = new ArrayList<OdbcColumnMeta>();
        if (meta != null) {
            for (Object info : meta) {
                assert (info instanceof GridQueryFieldMetadata);
                res.add(new OdbcColumnMeta((GridQueryFieldMetadata)info));
            }
        }
        return res;
    }

    private static boolean matches(String str, String ptrn) {
        return str != null && (F.isEmpty(ptrn) || str.toUpperCase().matches(ptrn.toUpperCase().replace("%", ".*").replace("_", ".")));
    }
}

