/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import org.apache.ignite.IgniteException;

public class OdbcUtils {
    public static String addQuotationMarksIfNeeded(String str) {
        if (!(str == null || str.isEmpty() || str.startsWith("\"") && str.endsWith("\""))) {
            return "\"" + str + "\"";
        }
        return str;
    }

    public static String removeQuotationMarksIfNeeded(String str) {
        if (str != null && str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private OdbcUtils() {
    }

    public static String getIgniteTypeFromOdbcType(String odbcDataType) {
        assert (odbcDataType != null);
        switch (odbcDataType.toUpperCase()) {
            case "SQL_BIGINT": {
                return "BIGINT";
            }
            case "SQL_BINARY": 
            case "SQL_LONGVARBINARY": 
            case "SQL_VARBINARY": {
                return "BINARY";
            }
            case "SQL_BIT": {
                return "BIT";
            }
            case "SQL_CHAR": {
                return "CHAR";
            }
            case "SQL_DECIMAL": 
            case "SQL_NUMERIC": {
                return "DECIMAL";
            }
            case "SQL_LONGVARCHAR": 
            case "SQL_VARCHAR": 
            case "SQL_WCHAR": 
            case "SQL_WLONGVARCHAR": 
            case "SQL_WVARCHAR": {
                return "VARCHAR";
            }
            case "SQL_DOUBLE": 
            case "SQL_FLOAT": {
                return "DOUBLE";
            }
            case "SQL_REAL": {
                return "REAL";
            }
            case "SQL_GUID": {
                return "UUID";
            }
            case "SQL_SMALLINT": {
                return "SMALLINT";
            }
            case "SQL_INTEGER": {
                return "INTEGER";
            }
            case "SQL_DATE": {
                return "DATE";
            }
            case "SQL_TIME": {
                return "TIME";
            }
            case "SQL_TIMESTAMP": {
                return "TIMESTAMP";
            }
            case "SQL_TINYINT": {
                return "TINYINT";
            }
            case "SQL_INTERVAL_SECOND": 
            case "SQL_INTERVAL_MINUTE": 
            case "SQL_INTERVAL_HOUR": 
            case "SQL_INTERVAL_DAY": 
            case "SQL_INTERVAL_MONTH": 
            case "SQL_INTERVAL_YEAR": 
            case "SQL_INTERVAL_YEAR_TO_MONTH": 
            case "SQL_INTERVAL_HOUR_TO_MINUTE": 
            case "SQL_INTERVAL_HOUR_TO_SECOND": 
            case "SQL_INTERVAL_MINUTE_TO_SECOND": 
            case "SQL_INTERVAL_DAY_TO_HOUR": 
            case "SQL_INTERVAL_DAY_TO_MINUTE": 
            case "SQL_INTERVAL_DAY_TO_SECOND": {
                throw new IgniteException("Unsupported ODBC data type '" + odbcDataType + "'");
            }
        }
        throw new IgniteException("Invalid ODBC data type '" + odbcDataType + "'");
    }
}

